<main id="main" class="main">
  <section class="section">
    <div class="row">
      <div class="col-lg-12">
        <div class="card">
          <div class="card-body">

            <title>Create Zone</title>
            <style>
              #map { height: 500px; width: 100%; }
              .pac-container {
                z-index: 1051 !important;
              }
            </style>

            <h2 class="mb-3">Create New Zone</h2>

            <div class="row d-flex">
              <!-- Zone Form Inputs -->
              <div class="col-md-6 mb-2">
                <label class="form-label">Zone Name</label>
                <input type="text" id="zone_name" class="form-control" placeholder="Enter zone name" />
              </div>

              <div class="col-md-6 mb-2">
                <label class="form-label">Hottest Zone</label>
                <select id="hottest_zone" class="form-control">
                  <option value="">Select Any Option</option>
                  <option value="yes">Yes</option>
                  <option value="no">No</option>
                </select>
              </div>

              <div class="col-md-6 mb-2">
                <label class="form-label">Zone City</label>
                <select id="zone_city" class="form-control">
                  <option value="">Select Any City</option>
                  <?php foreach($cities as $city){ ?>
                    <option value="<?= $city->id ?>"><?= $city->city_name ?></option>
                  <?php } ?>
                </select>
              </div>

              <div class="col-md-6 mb-2">
                <label class="form-label">Zone Logo</label>
                <input type="file" id="zone_logo" class="form-control" />
              </div>

              <div class="col-md-6 mb-2">
                <label class="form-label">Zone Image</label>
                <input type="file" id="zone_pic" class="form-control" />
              </div>
            </div>

            <button type="button" onclick="submitZone()" class="btn btn-danger mb-3">Save Zone</button>

            <!-- ✅ Standard Search Input -->
            <div class="col-md-12 mb-2">
              <label class="form-label">Search Location</label>
              <input
                id="searchInput"
                type="text"
                class="form-control"
                placeholder="Search location to center map"
              />
            </div>

            <div id="map"></div>
            <input type="hidden" id="zoneData" />

            <!-- ✅ Load Google Maps API with async/defer -->
            <script
              src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBoW1OUopUOYWo6yNRNuLHTBphvawo-qew&libraries=places,drawing&callback=initMap"
              async defer>
            </script>

            <script>
              let map, drawingManager, selectedShape;

              function initMap() {
                map = new google.maps.Map(document.getElementById('map'), {
                  zoom: 10,
                  center: { lat: 17.385, lng: 78.486 }
                });

                // Initialize drawing manager
                drawingManager = new google.maps.drawing.DrawingManager({
                  drawingControl: true,
                  drawingControlOptions: {
                    position: google.maps.ControlPosition.TOP_CENTER,
                    drawingModes: ['polygon']
                  },
                  polygonOptions: {
                    editable: true,
                    fillColor: '#2196F3',
                    fillOpacity: 0.3,
                    strokeWeight: 2,
                    strokeColor: '#0D47A1'
                  }
                });

                drawingManager.setMap(map);

                // When polygon completed
                google.maps.event.addListener(drawingManager, 'overlaycomplete', function (event) {
                  if (selectedShape) selectedShape.setMap(null);
                  selectedShape = event.overlay;
                  getPolygonCoordinates(selectedShape);

                  google.maps.event.addListener(selectedShape.getPath(), 'set_at', () => getPolygonCoordinates(selectedShape));
                  google.maps.event.addListener(selectedShape.getPath(), 'insert_at', () => getPolygonCoordinates(selectedShape));
                });

                // ✅ Setup Places Autocomplete
                const input = document.getElementById("searchInput");
                const autocomplete = new google.maps.places.Autocomplete(input);

                autocomplete.addListener("place_changed", () => {
                  const place = autocomplete.getPlace();
                  if (place.geometry) {
                    map.setCenter(place.geometry.location);
                    map.setZoom(18);
                  } else {
                    alert("No geometry found for the place.");
                  }
                });
              }

              function getPolygonCoordinates(polygon) {
                const path = polygon.getPath();
                let coordinates = [];

                for (let i = 0; i < path.getLength(); i++) {
                  const latLng = path.getAt(i);
                  coordinates.push({ lat: latLng.lat(), lng: latLng.lng() });
                }

                document.getElementById("zoneData").value = JSON.stringify(coordinates);
              }

              function submitZone() {
                const name = document.getElementById("zone_name").value;
                const hottest_zone = document.getElementById("hottest_zone").value;
                const zone_city = document.getElementById("zone_city").value;
                const boundaries = document.getElementById("zoneData").value;
                const zone_logo = document.getElementById("zone_logo").files[0];
                const zone_pic = document.getElementById("zone_pic").files[0];

                if (!name || !boundaries || !hottest_zone || !zone_city) {
                  alert("Please fill all required fields and draw a zone.");
                  return;
                }

                const formData = new FormData();
                formData.append("zone_name", name);
                formData.append("hottest_zone", hottest_zone);
                formData.append("zone_city", zone_city);
                formData.append("boundaries", boundaries);
                formData.append("zone_logo", zone_logo);
                formData.append("zone_pic", zone_pic);

                fetch("<?= base_url('welcome/create_zone') ?>", {
                  method: "POST",
                  body: formData
                })
                .then(res => res.json())
                .then(data => {
                  alert(data.message);
                  location.reload();
                })
                .catch(err => {
                  console.error("Error:", err);
                });
              }
            </script>

          </div>
        </div>
      </div>
    </div>
  </section>
</main>
