<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Api_model extends CI_Model {


    /*Commom Fetch*/
function common_fetch($table,$where){
	$this->db->select()->from($table);
	$this->db->where($where);
    $this->db->order_by('id','desc');
	$query= $this->db->get();
    return $query->result_array();
	 
}
/*Commom Fetch*/

/*common insert*/
function common_insert($table,$data)
{
    $this->db->insert($table,$data);
    $id = $this->db->insert_id();
    return $id;
} 
/*common insert */
/*commonpermanent delete */
public function common_p_delete($table,$data)
{
    $this->db->where($data);
$this->db->delete($table);
return true;

}
/*commonpermanent delete */
/*common update */
function common_update($table,$data,$where)
{
    $this->db->where($where);
    $this->db->update($table,$data);
   // $id = $this->db->insert_id();
   return true;
   // return $this->db->last_query();
}
/*common update */
/*bussiness category*/
public function get_bussiness_categories($cat_type,$limit, $offset){
    // Fetch main report data
    $this->db->select('cmdr.id, cmdr.name, cmdr.image,cmdr.type');
    $this->db->from('bussiness_categories cmdr'); 
    $this->db->where([
        'cmdr.status'                => 1,
        'cmdr.delete_status'         => 1,
        'cmdr.type'                           => $cat_type
    ]);
    $this->db->order_by('cmdr.id', 'DESC');
    $this->db->limit($limit, $offset);
    $query  = $this->db->get();
    $result = $query->result_array();

   
    // Final mapped structure
    return array_map(function ($row) {
        return [
            'id'                    => intval($row['id']),
            'name'                  => $row['name'],
            'images'                => $row['image'],  // Array of image URLs/paths
            'type'                  => $row['type']
        ];
    }, $result);
}
public function get_bussiness_categories_rows(){
    $this->db->select('cmdr.*')->from('bussiness_categories cmdr');
    $this->db->where(['cmdr.status' => 1,'cmdr.delete_status' => 1]);
    $query = $this->db->get();
	return $query->num_rows();
}
/*bussiness category*/
/*audio songs*/
public function get_audio_songs($limit, $offset){ 
    // Fetch main report data
    $this->db->select('cmdr.id, cmdr.name, cmdr.description, cmdr.audio_file,cmdr.audio_image'); 
    $this->db->from('audio_songs cmdr'); 
    $this->db->where([
        'cmdr.status'                => 1,
        'cmdr.delete_status'         => 1
    ]);
    $this->db->order_by('cmdr.id', 'DESC');
    $this->db->limit($limit, $offset);
    $query  = $this->db->get();
    $result = $query->result_array();

   
    // Final mapped structure
    return array_map(function ($row) {
        return [
            'id'                    => intval($row['id']),
            'name'                  => $row['name'],
            'description'                  => $row['description'],
            'audio_file'                => $row['audio_file'],  // Array of image URLs/paths
            'audio_image'               =>$row['audio_image']
        ];
    }, $result);
}
public function get_audio_songs_rows(){
    $this->db->select('cmdr.*')->from('audio_songs cmdr');
    $this->db->where(['cmdr.status' => 1,'cmdr.delete_status' => 1]);
    $query = $this->db->get();
	return $query->num_rows();
}
public function get_audio_songs_search($search_key)
{
    // Fetch main report data
    $this->db->select('cmdr.id, cmdr.name, cmdr.description, cmdr.audio_file,cmdr.audio_image');
    $this->db->from('audio_songs cmdr');
    $this->db->where([
        'cmdr.status'        => 1,
        'cmdr.delete_status' => 1
    ]);

    // Add search condition if search key is provided
    if (!empty($search_key)) {
        //$this->db->group_start(); // Open bracket for grouping search conditions
        $this->db->like('cmdr.name', $search_key);
        //$this->db->or_like('cmdr.description', $search_key);
      //  $this->db->group_end(); // Close bracket
    }

    $this->db->order_by('cmdr.id', 'DESC');
    $query  = $this->db->get();
    $result = $query->result_array();

    // Final mapped structure
    return array_map(function ($row) {
        return [
            'id'          => intval($row['id']),
            'name'        => $row['name'],
            'description' => $row['description'],
            'audio_file'  => $row['audio_file'],
            'audio_image'  => $row['audio_image']
        ];
    }, $result);
}

/*audio songs*/

    // Get followers count
    public function get_followers_count($user_id,$user_mode) {
        return $this->db->where(array('following_id'=> $user_id))
                        ->count_all_results('user_followers');
    }

    // Get following count
    public function get_following_count($user_id,$user_mode) {
        // return $this->db->where(array('follower_id'=> $user_id,'follower_mode' => $user_mode))
        //                 ->count_all_results('user_followers');
        return $this->db->where(array('follower_id'=> $user_id))
                        ->count_all_results('user_followers');
    }
     public function get_post_count($user_id,$user_mode) {
        return $this->db->where(array('user_id'=> $user_id,'user_type' => $user_mode))
                        ->count_all_results('posts');
    }
    
        public function add_comment($user_id, $user_type, $content_type, $content_id, $comment_text) {
        $this->db->insert('comments', [
            'user_id' => $user_id,
           // 'user_type' => $user_type,
            'content_type' => $content_type,
            'content_id' => $content_id,
            'comment_text' => $comment_text
        ]);
        return $this->db->insert_id();
    }

    public function get_comments($content_type, $content_id) {
        $this->db->select('c.*, u.name, u.image asprofile_pic');
        $this->db->from('comments c');
        $this->db->join('users u', 'u.id = c.user_id');
        $this->db->where('c.content_type', $content_type);
        $this->db->where('c.content_id', $content_id);
        $this->db->order_by('c.id', 'ASC');
        return $this->db->get()->result();
    }

    public function delete_comment($comment_id, $user_id) {
        $this->db->where(['id' => $comment_id, 'user_id' => $user_id]);
        return $this->db->delete('comments');
    }
    
        public function toggle_like($user_id, $user_type, $content_type, $content_id) {
        $exists = $this->db->get_where('likes', [
            'user_id' => $user_id,
           // 'user_type' => $user_type,
            'content_type' => $content_type,
            'content_id' => $content_id
        ])->row();

        if ($exists) {
            $this->db->delete('likes', ['id' => $exists->id]);
            return ['status' => 'unliked'];
        } else {
            $this->db->insert('likes', [
                'user_id' => $user_id,
              ///  'user_type' => $user_type,
                'content_type' => $content_type,
                'content_id' => $content_id
            ]);
            return ['status' => 'liked'];
        }
    }

    public function get_likes_count($content_type, $content_id) {
        return $this->db->where([
                'content_type' => $content_type,
                'content_id' => $content_id
            ])
            ->count_all_results('likes');
    }

    public function is_liked($user_id, $user_type, $content_type, $content_id) {
        return $this->db->where([
                'user_id' => $user_id,
          //      'user_type' => $user_type,
                'content_type' => $content_type,
                'content_id' => $content_id
            ])->count_all_results('likes') > 0;
    }
    
        public function add_share($user_id, $user_type, $content_type, $content_id, $shared_to = 'story') {
        $this->db->insert('shares', [
            'user_id' => $user_id,
           // 'user_type' => $user_type,
            'content_type' => $content_type,
            'content_id' => $content_id,
            'shared_to' => $shared_to
        ]);
        return $this->db->insert_id();
    }
       public function add_view($user_id, $user_type, $content_type, $content_id) {
        $this->db->insert('content_views', [
            'user_id' => $user_id,
           // 'user_type' => $user_type,
            'content_type' => $content_type,
            'content_id' => $content_id,
            'viewed_at' => date('Y-m-d H:i:s')
            //'shared_to' => $shared_to
        ]);
        return $this->db->insert_id();
    }
    
 

    public function get_shares_count($content_type, $content_id) {
        return $this->db->where([
                'content_type' => $content_type,
                'content_id' => $content_id
            ])
            ->count_all_results('shares');
    }
    
    
    /*view user social profile */
    
    public function get_user_social_profile_details($user_id,$user_mode)
    {
         // Fetch user info
    $user = $this->db->select('id, username, profile_name, bio, profile_image')
                     ->from('users')
                     ->where('id', $user_id)
                     ->get()
                     ->row_array();

    if (!$user) {
        echo json_encode(["status" => false, "message" => "User not found"]);
        return;
    }

    // ---- Counts ----
    $total_posts = $this->db->where(['user_id' => $user_id, 'user_type' => $user_mode])->count_all_results('posts');
    $followers_count = $this->db->where(['following_id'=> $user_id,'following_mode' =>$user_mode])->count_all_results('user_followers');
    $following_count = $this->db->where(['follower_id'=> $user_id,'follower_mode' => $user_mode])->count_all_results('user_followers');

    // ---- Check if logged-in user follows ----
    $is_following = false;
    if ($auth_user_id) {
        $is_following = $this->db->where(['user_id' => $user_id, 'follower_id' => $auth_user_id])
                                 ->count_all_results('followers') > 0;
    }

    // ---- Recent Story (within 24 hours) ----
    $story = $this->db->select('id as story_id, file_url, created_on')
                      ->from('stories')
                      ->where('user_id', $user_id)
                      ->where('created_on >=', date('Y-m-d H:i:s', strtotime('-24 hours')))
                      ->order_by('id', 'DESC')
                      ->limit(1)
                      ->get()
                      ->row_array();

    $story_data = [
        "has_story" => !empty($story),
        "story_id" => $story['story_id'] ?? null,
        "story_file_url" => !empty($story['file_url']) ? base_url('uploads/stories/'.$story['file_url']) : null,
        "created_on" => $story['created_on'] ?? null
    ];

    // ---- Reels ----
    $reels = $this->db->select('id as reel_id, file_url, thumbnail, created_on')
                      ->from('reels')
                      ->where(['user_id' => $user_id, 'status' => 1])
                      ->order_by('id', 'DESC')
                      ->get()
                      ->result_array();

    foreach ($reels as &$r) {
        $r['file_url'] = base_url('uploads/reels/' . $r['file_url']);
        $r['thumbnail'] = base_url('uploads/reels/thumbs/' . $r['thumbnail']);
    }

    // ---- Posts ----
    $posts = $this->db->select('id as post_id, file_type, file_url, created_on')
                      ->from('posts')
                      ->where(['user_id' => $user_id, 'status' => 1])
                      ->order_by('id', 'DESC')
                      ->get()
                      ->result_array();

    foreach ($posts as &$p) {
        $p['file_url'] = base_url('uploads/posts/' . $p['file_url']);
    }

    // ---- Final Response ----
    $data = [
        'user_id' => $user['id'],
        'username' => $user['username'],
        'profile_name' => $user['profile_name'],
        'bio' => $user['bio'],
        'profile_image' => base_url('uploads/profile/' . $user['profile_image']),
        'total_posts' => $total_posts,
        'followers_count' => $followers_count,
        'following_count' => $following_count,
        'is_following' => $is_following,
        'story' => $story_data,
        'reels' => $reels,
        'posts' => $posts
    ];

    }
    
    public function get_user_profile_data($profile_user_id, $auth_user_id = null, $account_type = null)
    {
        // Fetch user
        $user = $this->db->select('id, personal_username, name, bio, image, user_type,private_account')
                         ->from('users')
                         ->where('id', $profile_user_id)
                         ->get()
                         ->row_array();

        if (!$user) {
            return ["status" => false, "message" => "User not found"];
        }

        $is_self_profile = ($auth_user_id == $profile_user_id);

        // Handle account type
        // if ($user['user_type'] == 'both') {
        //     if (empty($account_type)) {
        //         $account_type = 'personal';
        //     }
        // } else {
        //     $account_type = $user['user_type'];
        // }
        
      

       // ---- Counts ----
    $total_posts = $this->db->where(['user_id' => $profile_user_id, 'user_type' => $account_type])->count_all_results('posts');
    $followers_count = $this->db->where(['follower_id'=> $profile_user_id])->count_all_results('user_followers');
    $following_count = $this->db->where(['following_id'=> $profile_user_id])->count_all_results('user_followers');
$is_following = false;
       if (!$is_self_profile && $auth_user_id) {

    $is_following = $this->db->where([
                        'following_id' => $auth_user_id,      // Who is following
                        'follower_id' => $profile_user_id,   // Whom they follow
                    ])
                    ->count_all_results('user_followers') > 0;
}
$is_following = $is_following ? "1" : "0";
        // Active story (24 hrs)
        $story = $this->db->select('id as story_id, post, created_on')
                          ->from('stories')
                          ->where('user_id', $profile_user_id)
                          ->where('user_type', $account_type)
                          ->where('created_on >=', date('Y-m-d H:i:s', strtotime('-24 hours')))
                          ->order_by('id', 'DESC')
                          ->limit(1)
                          ->get()
                          ->row_array();

        $story_data = [
            "has_story" => !empty($story),
            "story_id" => $story['story_id'] ?? null,
            "story_file_url" => !empty($story['post']) ? $story['post'] : null,
            "created_on" => $story['created_on'] ?? null
        ];

        // Reels
        $reels = $this->db->select('id as reel_id, post, post_type, created_on')
                          ->from('reels')
                          ->where(['user_id' => $profile_user_id, 'user_type' => $account_type])
                          ->order_by('id', 'DESC')
                          ->get()
                          ->result_array();
//echo $this->db->last_query();exit;
        foreach ($reels as &$r) {
            $r['post'] = $r['post'];
            $r['post_type'] = $r['post_type'];
        }

        // Posts
        $posts = $this->db->select('id as post_id, post, post_type, created_on')
                          ->from('posts')
                          ->where(['user_id' => $profile_user_id, 'user_type' => $account_type])
                          ->order_by('id', 'DESC')
                          ->get()
                          ->result_array();

        foreach ($posts as &$p) {
            $p['post'] = $p['post'];
            $p['post_type'] = $p['post_type'];
        }

        // Prepare final data
        $data = [
            'is_self_profile' => $is_self_profile,
            'user_id' => $user['id'],
            'name' => $user['name'],
            'image' => $user['image'],
            'personal_username' => $user['personal_username'],
            'bussiness_username' => $user['bussiness_username'],
            'bio' => $user['bio'],
            'private_account' => $user['private_account'],
            'location' => $user['location'],
            'bussiness_username' => $user['bussiness_username'],
            'user_type' => $user['user_type'],
            'selected_account_type' => $account_type,
            'total_posts' => $total_posts,
            'followers_count' => $followers_count,
            'following_count' => $following_count,
            'is_following' => $is_following, 
            'story' => $story_data,
            'reels' => $reels,
            'posts' => $posts
        ];
        $data = $this->replace_null_with_empty($data);
          return $data;
       // return ["status" => true, "message" => "Profile details fetched successfully", "data" => $data];
    }
    
    private function replace_null_with_empty($data) {
    foreach ($data as $key => $value) {
        if (is_array($value)) {
            $data[$key] = $this->replace_null_with_empty($value); // recursive
        } else {
            if (is_null($value)) {
                $data[$key] = "";
            }
        }
    }
    return $data;
}

    
   // Fetch posts for selected mode (personal/business)
    // public function get_user_feed($auth_user_id, $user_mode,$cat_id,$type, $limit, $offset)
    // {
    //     // 1️⃣ Get all following users based on the same mode
    //     $following = $this->db->select('following_id')
    //                           ->where('follower_id', $auth_user_id)
    //                           //->where('follower_mode', $user_mode)
    //                          // ->where('following_mode', $user_mode)
    //                           ->get('user_followers')
    //                           ->result_array();

    //     if (empty($following)) return [];

    //     $following_ids = array_column($following, 'following_id');

    //     // 2️⃣ Fetch posts of those users in the same mode
    //     $this->db->select('p.id as post_id, p.post_content,p.user_id, p.post, p.post_type, p.user_type, p.created_on,p.*,
    //                       u.name, u.personal_username, u.bussiness_username, u.image,a.name as song_name,a.audio_file,a.description as audio_description');
    //     $this->db->from('posts p');
    //     $this->db->join('users u', 'u.id = p.user_id', 'left');
    //     $this->db->join('audio_songs a', 'a.id = p.song_id', 'left');
    //     $this->db->where_in('p.user_id', $following_ids);
    //     $this->db->where('p.user_type', $user_mode);
    //     if(!empty($cat_id)){
    //     $this->db->where('p.cat_id', $cat_id);
    //     }
    //     if(!empty($type)){
    //     $this->db->where('p.type', $type);
    //     }
    //     $this->db->order_by('p.id', 'DESC');
    //     $this->db->limit($limit, $offset);
    //     $posts = $this->db->get()->result_array();

    //     if (empty($posts)) return [];

    //     // 3️⃣ Enrich with likes/comments/shares
    //     foreach ($posts as &$p) {
    //         $pid = $p['post_id'];

    //         $p['like_count'] = $this->db
    //             ->where(['content_type' => 'post', 'content_id' => $pid])
    //             ->count_all_results('likes');

    //         $p['comment_count'] = $this->db
    //             ->where(['content_type' => 'post', 'content_id' => $pid])
    //             ->count_all_results('comments');

    //         $p['share_count'] = $this->db
    //             ->where(['content_type' => 'post', 'content_id' => $pid])
    //             ->count_all_results('shares');

    //         $p['is_liked'] = $this->db
    //             ->where(['user_id' => $auth_user_id, 'content_type' => 'post', 'content_id' => $pid])
    //             ->count_all_results('likes') > 0;

    //       // $p['post_url'] = $p['post'];
    //       // $p['profile_image'] = $p['image'];
    //         $p['time_ago'] = $this->time_elapsed_string($p['created_on']);
    //     }

    //     return $posts;
    // }

    // Count total posts for pagination
    // public function get_user_feed_rows($auth_user_id, $user_mode,$cat_id,$type)
    // {
    //     $following = $this->db->select('following_id')
    //                           ->where('follower_id', $auth_user_id)
    //                          // ->where('follower_mode', $user_mode)
    //                           //->where('following_mode', $user_mode)
    //                           ->get('user_followers')
    //                           ->result_array();

    //     if (empty($following)) return 0;

    //     $following_ids = array_column($following, 'following_id');

    //     $this->db->where_in('user_id', $following_ids);
    //     $this->db->where('user_type', $user_mode);
    //     if(!empty($cat_id)){
    //     $this->db->where('cat_id', $cat_id);
    //     }
    //      if(!empty($type)){
    //     $this->db->where('type', $type);
    //     }
    //     return $this->db->count_all_results('posts');
    // }
    
    public function get_user_feed($auth_user_id, $user_mode, $cat_id, $type, $limit, $offset, $only_user_id = null)
{
    // 1️⃣ If specific user id is given → fetch ONLY THEIR POSTS
    if (!empty($only_user_id)) {

        $this->db->select('p.id as post_id, p.post_content, p.user_id, p.post, p.post_type, 
                           p.user_type, p.created_on, p.*, 
                           u.name, u.personal_username, u.bussiness_username, u.image,
                           a.name as song_name, a.audio_file, a.description as audio_description');
        $this->db->from('posts p');
        $this->db->join('users u', 'u.id = p.user_id', 'left');
        $this->db->join('audio_songs a', 'a.id = p.song_id', 'left');

        $this->db->where('p.user_id', $only_user_id);
        $this->db->where('p.user_type', $user_mode);

        if (!empty($cat_id)) {
            $this->db->where('p.cat_id', $cat_id);
        }
        if (!empty($type)) {
            $this->db->where('p.type', $type);
        }

        $this->db->order_by('p.id', 'DESC');
        $this->db->limit($limit, $offset);

        $posts = $this->db->get()->result_array();
    }

    // 2️⃣ ELSE normal feed (following users)
    else {
        // Get all following IDs
        $following = $this->db->select('follower_id')
                              ->where('following_id', $auth_user_id)
                              ->get('user_followers')
                              ->result_array();

        if (empty($following)) return [];

        $following_ids = array_column($following, 'follower_id');

        // Fetch posts of following users
        $this->db->select('p.id as post_id, p.post_content, p.user_id, p.post, p.post_type, 
                           p.user_type, p.created_on, p.*, 
                           u.name, u.personal_username, u.bussiness_username, u.image,
                           a.name as song_name, a.audio_file, a.description as audio_description');
        $this->db->from('posts p');
        $this->db->join('users u', 'u.id = p.user_id', 'left');
        $this->db->join('audio_songs a', 'a.id = p.song_id', 'left');

        $this->db->where_in('p.user_id', $following_ids);
        $this->db->where('p.user_type', $user_mode);

        if (!empty($cat_id)) {
            $this->db->where('p.cat_id', $cat_id);
        }
        if (!empty($type)) {
            $this->db->where('p.type', $type);
        }

        $this->db->order_by('p.id', 'DESC');
        $this->db->limit($limit, $offset);

        $posts = $this->db->get()->result_array();
    }

    // Common enrichment
    if (empty($posts)) return [];

    foreach ($posts as &$p) {
        $pid = $p['post_id'];

        $p['like_count'] = $this->db
            ->where(['content_type' => 'post', 'content_id' => $pid])
            ->count_all_results('likes');

        $p['comment_count'] = $this->db
            ->where(['content_type' => 'post', 'content_id' => $pid])
            ->count_all_results('comments');

        $p['share_count'] = $this->db
            ->where(['content_type' => 'post', 'content_id' => $pid])
            ->count_all_results('shares');

        $p['is_liked'] = $this->db
            ->where(['user_id' => $auth_user_id, 'content_type' => 'post', 'content_id' => $pid])
            ->count_all_results('likes') > 0;

        $p['time_ago'] = $this->time_elapsed_string($p['created_on']);
        // 👇 NEW CODE HERE
    $p['is_following'] = $this->db
        ->where('follower_id', $auth_user_id)
        ->where('following_id', $p['user_id'])
        ->count_all_results('user_followers') > 0;
    }

    return $posts;
}

    public function get_user_feed_rows($auth_user_id, $user_mode, $cat_id, $type, $only_user_id = null)
{
    // 1️⃣ If specific user ID is given → return ONLY their post count
    if (!empty($only_user_id)) {

        $this->db->where('user_id', $only_user_id);
        $this->db->where('user_type', $user_mode);

        if (!empty($cat_id)) {
            $this->db->where('cat_id', $cat_id);
        }
        if (!empty($type)) {
            $this->db->where('type', $type);
        }

        return $this->db->count_all_results('posts');
    }

    // 2️⃣ Normal feed mode (following users)
    $following = $this->db->select('follower_id')
                          ->where('following_id', $auth_user_id)
                          ->get('user_followers')
                          ->result_array();

    if (empty($following)) return 0;

    $following_ids = array_column($following, 'follower_id');

    $this->db->where_in('user_id', $following_ids);
    $this->db->where('user_type', $user_mode);

    if (!empty($cat_id)) {
        $this->db->where('cat_id', $cat_id);
    }
    if (!empty($type)) {
        $this->db->where('type', $type);
    }

    return $this->db->count_all_results('posts');
}

    
    // // Fetch posts for selected mode (personal/business)
    // public function get_user_reels($auth_user_id, $user_mode,$cat_id,$type, $limit, $offset)
    // {
    //     // 1️⃣ Get all following users based on the same mode
    //     $following = $this->db->select('following_id')
    //                           ->where('follower_id', $auth_user_id)
    //                         //  ->where('follower_mode', $user_mode)
    //                         //  ->where('following_mode', $user_mode)
    //                           ->get('user_followers')
    //                           ->result_array();

    //     if (empty($following)) return [];

    //     $following_ids = array_column($following, 'following_id');

    //     // 2️⃣ Fetch posts of those users in the same mode
    //     $this->db->select('p.id as post_id, p.*,
    //                       u.name, u.personal_username, u.bussiness_username, u.image,a.name as song_name,a.audio_file,a.description as audio_description');
    //     $this->db->from('reels p');
    //     $this->db->join('users u', 'u.id = p.user_id', 'left');
    //     $this->db->join('audio_songs a', 'a.id = p.song_id', 'left');
    //     $this->db->where_in('p.user_id', $following_ids);
    //     $this->db->where('p.user_type', $user_mode);
    //     if(!empty($cat_id)){
    //     $this->db->where('p.cat_id', $cat_id);
    //     }
    //     if(!empty($type)){
    //     $this->db->where('p.type', $type);
    //     }
    //     $this->db->order_by('p.id', 'DESC');
    //     $this->db->limit($limit, $offset);
    //     $posts = $this->db->get()->result_array();

    //     if (empty($posts)) return [];

    //     // 3️⃣ Enrich with likes/comments/shares
    //     foreach ($posts as &$p) {
    //         $pid = $p['post_id'];

    //         $p['like_count'] = $this->db
    //             ->where(['content_type' => 'reel', 'content_id' => $pid])
    //             ->count_all_results('likes');

    //         $p['comment_count'] = $this->db
    //             ->where(['content_type' => 'reel', 'content_id' => $pid])
    //             ->count_all_results('comments');

    //         $p['share_count'] = $this->db
    //             ->where(['content_type' => 'reel', 'content_id' => $pid])
    //             ->count_all_results('shares');

    //         $p['is_liked'] = $this->db
    //             ->where(['user_id' => $auth_user_id, 'content_type' => 'reel', 'content_id' => $pid])
    //             ->count_all_results('likes') > 0;

    //       // $p['post_url'] = $p['post'];
    //       // $p['profile_image'] = $p['image'];
    //         $p['time_ago'] = $this->time_elapsed_string($p['created_on']);
    //     }

    //     return $posts;
    // }

    // // Count total posts for pagination
    // public function get_user_reels_rows($auth_user_id, $user_mode,$cat_id,$type)
    // {
    //     $following = $this->db->select('following_id')
    //                           ->where('follower_id', $auth_user_id)
    //                          // ->where('follower_mode', $user_mode)
    //                          // ->where('following_mode', $user_mode)
    //                           ->get('user_followers')
    //                           ->result_array();

    //     if (empty($following)) return 0;

    //     $following_ids = array_column($following, 'following_id');

    //     $this->db->where_in('user_id', $following_ids);
    //     $this->db->where('user_type', $user_mode);
    //     if(!empty($cat_id)){
    //     $this->db->where('cat_id', $cat_id);
    //     }
    //     if(!empty($type)){
    //     $this->db->where('type', $type);
    //     }
    //     return $this->db->count_all_results('reels');
    // }
    public function get_user_reels($auth_user_id, $user_mode, $cat_id, $type, $limit, $offset, $only_user_id = null)
{
    // 1️⃣ If specific user reels required
    if (!empty($only_user_id)) {

        $this->db->select('p.id as post_id, p.*, 
                           u.name, u.personal_username, u.bussiness_username, u.image,
                           a.name as song_name, a.audio_file, a.description as audio_description');
        $this->db->from('reels p');
        $this->db->join('users u', 'u.id = p.user_id', 'left');
        $this->db->join('audio_songs a', 'a.id = p.song_id', 'left');

        $this->db->where('p.user_id', $only_user_id);
        $this->db->where('p.user_type', $user_mode);

        if (!empty($cat_id)) {
            $this->db->where('p.cat_id', $cat_id);
        }
        if (!empty($type)) {
            $this->db->where('p.type', $type);
        }

        $this->db->order_by('p.id', 'DESC');
        $this->db->limit($limit, $offset);

        $posts = $this->db->get()->result_array();
    }

    // 2️⃣ Normal feed → only reels of following users
    else {
        $following = $this->db->select('follower_id')
                              ->where('following_id', $auth_user_id)
                              ->get('user_followers')
                              ->result_array();

        if (empty($following)) return [];

        $following_ids = array_column($following, 'follower_id');

        $this->db->select('p.id as post_id, p.*, 
                           u.name, u.personal_username, u.bussiness_username, u.image,
                           a.name as song_name, a.audio_file, a.description as audio_description');
        $this->db->from('reels p');
        $this->db->join('users u', 'u.id = p.user_id', 'left');
        $this->db->join('audio_songs a', 'a.id = p.song_id', 'left');

        $this->db->where_in('p.user_id', $following_ids);
        $this->db->where('p.user_type', $user_mode);

        if (!empty($cat_id)) {
            $this->db->where('p.cat_id', $cat_id);
        }
        if (!empty($type)) {
            $this->db->where('p.type', $type);
        }

        $this->db->order_by('p.id', 'DESC');
        $this->db->limit($limit, $offset);

        $posts = $this->db->get()->result_array();
    }

    if (empty($posts)) return [];

    // 3️⃣ Enrich with counts
    foreach ($posts as &$p) {
        $pid = $p['post_id'];

        $p['like_count'] = $this->db
            ->where(['content_type' => 'reel', 'content_id' => $pid])
            ->count_all_results('likes');

        $p['comment_count'] = $this->db
            ->where(['content_type' => 'reel', 'content_id' => $pid])
            ->count_all_results('comments');

        $p['share_count'] = $this->db
            ->where(['content_type' => 'reel', 'content_id' => $pid])
            ->count_all_results('shares');

        $p['is_liked'] = $this->db
            ->where(['user_id' => $auth_user_id, 'content_type' => 'reel', 'content_id' => $pid])
            ->count_all_results('likes') > 0;

        $p['time_ago'] = $this->time_elapsed_string($p['created_on']);
        
        // 👇 NEW CODE HERE
    $p['is_following'] = $this->db
        ->where('follower_id', $auth_user_id)
        ->where('following_id', $p['user_id'])
        ->count_all_results('user_followers') > 0;
    
    }

    return $posts;
}
public function get_user_reels_rows($auth_user_id, $user_mode, $cat_id, $type, $only_user_id = null)
{
    // 1️⃣ Count only specific user's reels
    if (!empty($only_user_id)) {

        $this->db->where('user_id', $only_user_id);
        $this->db->where('user_type', $user_mode);

        if (!empty($cat_id)) {
            $this->db->where('cat_id', $cat_id);
        }
        if (!empty($type)) {
            $this->db->where('type', $type);
        }

        return $this->db->count_all_results('reels');
    }

    // 2️⃣ Normal feed (following users)
    $following = $this->db->select('follower_id')
                          ->where('following_id', $auth_user_id)
                          ->get('user_followers')
                          ->result_array();

    if (empty($following)) return 0;

    $following_ids = array_column($following, 'follower_id');

    $this->db->where_in('user_id', $following_ids);
    $this->db->where('user_type', $user_mode);

    if (!empty($cat_id)) {
        $this->db->where('cat_id', $cat_id);
    }
    if (!empty($type)) {
        $this->db->where('type', $type);
    }

    return $this->db->count_all_results('reels');
}

   // Fetch stories for selected mode (personal/business) - only last 24 hours
public function get_user_stories($auth_user_id, $user_mode, $cat_id, $type, $limit, $offset)
{
    // 1️⃣ Get all following users based on the same mode
    $following = $this->db->select('follower_id')
                          ->where('following_id', $auth_user_id)
                          //->where('follower_mode', $user_mode)
                         // ->where('following_mode', $user_mode)
                          ->get('user_followers')
                          ->result_array();
//echo $this->db->last_query();exit;
    if (empty($following)) return [];

    $following_ids = array_column($following, 'follower_id');

    // 2️⃣ Fetch stories of those users in the same mode (only last 24 hours)
    $this->db->select('p.id as post_id, p.*, 
                       u.name, u.personal_username, u.bussiness_username, u.image, 
                       a.name as song_name, a.audio_file, a.description as audio_description');
    $this->db->from('stories p');
    $this->db->join('users u', 'u.id = p.user_id', 'left');
    $this->db->join('audio_songs a', 'a.id = p.song_id', 'left');
    $this->db->where_in('p.user_id', $following_ids);
    $this->db->where('p.user_type', $user_mode);
   if(!empty($type)){
        $this->db->where('p.type', $type);
        }

    // Filter by category if provided
    if (!empty($cat_id)) {
        $this->db->where('p.cat_id', $cat_id);
    }

    // Filter only last 24 hours
    $this->db->where('p.created_on >=', date('Y-m-d H:i:s', strtotime('-24 hours')));

    $this->db->order_by('p.id', 'DESC');
    $this->db->limit($limit, $offset);
    $stories = $this->db->get()->result_array();
//echo $this->db->last_query();exit;
    if (empty($stories)) return [];

   // 3️⃣ Enrich with likes/comments/shares + viewed
foreach ($stories as &$p) {
    $pid = $p['post_id'];

    // ✅ View status
    $p['is_viewed'] = $this->db
        ->where([
            'content_type' => 'story',
            'content_id'   => $pid,
            'user_id'      => $auth_user_id
        ])
        ->count_all_results('content_views') > 0;

    // ✅ View count
    $p['view_count'] = $this->db
        ->where([
            'content_type' => 'story',
            'content_id'   => $pid
        ])
        ->count_all_results('content_views');

    $p['like_count'] = $this->db
        ->where(['content_type' => 'story', 'content_id' => $pid])
        ->count_all_results('likes');

    $p['comment_count'] = $this->db
        ->where(['content_type' => 'story', 'content_id' => $pid])
        ->count_all_results('comments');

    $p['share_count'] = $this->db
        ->where(['content_type' => 'story', 'content_id' => $pid])
        ->count_all_results('shares');

    $p['is_liked'] = $this->db
        ->where([
            'user_id'      => $auth_user_id,
            'content_type' => 'story',
            'content_id'   => $pid
        ])
        ->count_all_results('likes') > 0;

    $p['time_ago'] = $this->time_elapsed_string($p['created_on']);
}


    return $stories;
}


   // Count total stories for pagination (only last 24 hours)
public function get_user_stories_rows($auth_user_id, $user_mode, $cat_id, $type)
{
    $following = $this->db->select('follower_id')
                          ->where('following_id', $auth_user_id)
                         // ->where('follower_mode', $user_mode)
                         // ->where('following_mode', $user_mode)
                          ->get('user_followers')
                          ->result_array();

    if (empty($following)) return 0;

    $following_ids = array_column($following, 'follower_id');

    $this->db->from('stories p');
    $this->db->where_in('p.user_id', $following_ids);
    $this->db->where('p.user_type', $user_mode);

    if (!empty($cat_id)) {
        $this->db->where('p.cat_id', $cat_id);
    }
    if(!empty($type)){
        $this->db->where('type', $type);
        }

    // Count only last 24 hours stories
    $this->db->where('p.created_on >=', date('Y-m-d H:i:s', strtotime('-24 hours')));

    return $this->db->count_all_results();
}
    // helper: convert datetime to time ago
    private function time_elapsed_string($datetime, $full = false) {
        $now = new DateTime;
        $ago = new DateTime($datetime);
        $diff = $now->diff($ago);

        $diff->w = floor($diff->d / 7);
        $diff->d -= $diff->w * 7;

        $string = [
            'y' => 'year',
            'm' => 'month',
            'w' => 'week',
            'd' => 'day',
            'h' => 'hour',
            'i' => 'minute',
            's' => 'second',
        ];
        foreach ($string as $k => &$v) {
            if ($diff->$k) {
                $v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');
            } else {
                unset($string[$k]);
            }
        }

        if (!$full) $string = array_slice($string, 0, 1);
        return $string ? implode(', ', $string) . ' ago' : 'just now';
    }
    
    public function view_single_post_reel_story($user_id,$content_type,$content_id){
         $table = "";
    if ($content_type == 'post')  { $table = 'posts'; }
    if ($content_type == 'reel')  { $table = 'reels'; }
    if ($content_type == 'story') { $table = 'stories'; }

    // Fetch content
    $this->db->select("p.*, u.name, u.personal_username, u.bussiness_username, u.image, a.name as song_name, a.audio_file, a.description as audio_description");
    $this->db->from("$table p");
    $this->db->join('users u', 'u.id = p.user_id');
    $this->db->join('audio_songs a', 'a.id = p.song_id', 'left');
    $this->db->where("p.id", $content_id);
    $post = $this->db->get()->row_array();

    if (!$post) {
        echo json_encode(["status" => false, "message" => "Content not found"]); return;
    }

    // counts
    $post['like_count'] = $this->db->where(['content_type'=>$content_type,'content_id'=>$content_id])->count_all_results('likes');
    $post['comment_count'] = $this->db->where(['content_type'=>$content_type,'content_id'=>$content_id])->count_all_results('comments');
    $post['share_count'] = $this->db->where(['content_type'=>$content_type,'content_id'=>$content_id])->count_all_results('shares');

    // is liked
    $post['is_liked'] = $this->db->where([
        'content_type'=>$content_type,
        'content_id'=>$content_id,
        'user_id'=>$user_id
    ])->count_all_results('likes') > 0;

    // is viewed
    $post['is_viewed'] = $this->db->where([
        'content_type'=>$content_type,
        'content_id'=>$content_id,
        'user_id'=>$user_id
    ])->count_all_results('content_views') > 0;

    // total views
    $post['view_count'] = $this->db->where([
        'content_type'=>$content_type,
        'content_id'=>$content_id
    ])->count_all_results('content_views');

    // time ago if exists
    if (isset($post['created_on'])) {
        $post['time_ago'] = $this->time_elapsed_string($post['created_on']);
    }

    // echo json_encode([
    //     "status" => true,
    //     "message" => ucfirst($content_type)." fetched",
    //     "data" => $post
    // ]);
    return $post;
    
    }
    
      // ✅ Following list (I follow them)
    public function get_following($user_id, $mode)
    {
        $this->db->select('u.id, u.name, u.personal_username, u.bussiness_username, u.image, f.following_mode');
        $this->db->from('user_followers f');
        $this->db->join('users u', 'u.id = f.follower_id');

        $this->db->where('f.following_id', $user_id);

        if ($mode != "both") {
           // $this->db->where('f.follower_mode', $mode);
        }

        return $this->db->get()->result_array();
    }

    // ✅ Followers list (they follow me)
    public function get_followers($user_id, $mode)
    {
        $this->db->select('u.id, u.name, u.personal_username, u.bussiness_username, u.image, f.follower_mode');
        $this->db->from('user_followers f');
        $this->db->join('users u', 'u.id = f.following_id');

        $this->db->where('f.follower_id', $user_id);

        if ($mode != "both") {
         //   $this->db->where('f.following_mode', $mode);
        }

        return $this->db->get()->result_array();
    }
    public function get_friends($user_id, $mode)
{
    // ✅ first get people I follow
    $this->db->select('following_id');
    $this->db->where('follower_id', $user_id);

    if ($mode != "both") {
       // $this->db->where('follower_mode', $mode);
    }

    $following = $this->db->get('user_followers')->result_array();
    if (empty($following)) return [];

    $following_ids = array_column($following, 'following_id');

    // ✅ now find users who follow me back from this list
    $this->db->select('u.id, u.name, u.personal_username, u.bussiness_username, u.image, f.follower_mode');
    $this->db->from('user_followers f');
    $this->db->join('users u', 'u.id = f.follower_id');
    $this->db->where('f.following_id', $user_id);
    $this->db->where_in('f.follower_id', $following_ids); // mutual follow

    if ($mode != "both") {
       // $this->db->where('f.following_mode', $mode);
    }

    return $this->db->get()->result_array();
}

// public function search_personal_users($keyword)
// {
//     $this->db->select('id, name, personal_username, image');
//     $this->db->from('users');
//     $this->db->like('name', $keyword);
//     $this->db->or_like('personal_username', $keyword);

//     // ✅ Filter only personal accounts
//     $this->db->where("(user_type = 'personal' OR user_type = 'both')");

//     $this->db->limit(20); // optional
//     $this->db->order_by("name", "ASC");

//     return $this->db->get()->result_array();
// }
public function search_personal_users($keyword, $user_id = null)
{
    $this->db->select('id, name, personal_username,  image,"personal" as user_type');
    $this->db->from('users');
     $this->db->group_start();
    $this->db->like('name', $keyword);
    $this->db->or_like('personal_username', $keyword);
    $this->db->group_end();
    $this->db->where('delete_status', 1);
    $this->db->where('id != ',$user_id);

    // ✅ Filter only personal accounts
    $this->db->where("(user_type = 'personal' OR user_type = 'both')");

    // ✅ Exclude blocked users
    if (!empty($auth_user_id)) {
        $this->db->where("id NOT IN (
            SELECT blocked_id FROM user_blocks WHERE blocker_id = $user_id
            UNION
            SELECT blocker_id FROM user_blocks WHERE blocked_id = $user_id
        )");
    }

    $this->db->limit(20);
    $this->db->order_by("name", "ASC");

    return $this->db->get()->result_array();
}

// public function search_business_users($keyword)
// {
//     $this->db->select('id, name, bussiness_username, image');
//     $this->db->from('users');

//     $this->db->like('name', $keyword);
//     $this->db->or_like('bussiness_username', $keyword);

//     // ✅ Only business type users
//     $this->db->where("(user_type = 'creator' OR user_type = 'both')");

//     $this->db->limit(20);
//     $this->db->order_by("name", "ASC");

//     return $this->db->get()->result_array();
// }
public function search_business_users($keyword, $user_id = null)
{
    $this->db->select('id, name, personal_username, image,"creator" as user_type');
    $this->db->from('users');

    //$this->db->like('name', $keyword);
    //$this->db->or_like('personal_username', $keyword);
    $this->db->group_start();
    $this->db->like('name', $keyword);
    $this->db->or_like('personal_username', $keyword);
    $this->db->group_end();
    $this->db->where('delete_status', 1);
    $this->db->where('id != ',$user_id);

    // ✅ Only business/creator accounts
    $this->db->where("(user_type = 'creator' OR user_type = 'both')");

    // ✅ Exclude blocked users (do not show them in search)
    if (!empty($auth_user_id)) {

        $this->db->where("id NOT IN (
            SELECT blocked_id FROM user_blocks WHERE blocker_id = $user_id
            UNION
            SELECT blocker_id FROM user_blocks WHERE blocked_id = $user_id
        )");
    }

    $this->db->limit(20);
    $this->db->order_by("name", "ASC");

    return $this->db->get()->result_array();
}
public function get_notifications($user_id)
{
    // 1️⃣ USER NOTIFICATIONS
    $user_notifications = $this->db
        ->select('n.id, n.sender_id, n.type, n.message, n.is_read, n.created_at,
                  u.name AS sender_name, u.image AS sender_image')
        ->from('notifications n')
        ->join('users u', 'u.id = n.sender_id', 'left') // left join → admin sender=NULL
        ->where('n.user_id', $user_id)
        ->order_by('n.created_at', 'DESC')
        ->get()
        ->result_array();

    // Format: if sender_id = null → admin
    foreach ($user_notifications as &$n) {
        if (empty($n['sender_id'])) {
            $n['sender_name']  = "";
            $n['sender_image'] = "";
        }
    }

    // 2️⃣ ADMIN BROADCAST NOTIFICATIONS
    $admin = $this->db
        ->select("id, sender_id,type, message, created_at")
        ->from('admin_notifications')
        ->order_by('created_at', 'DESC')
        ->get()
        ->result_array();

    // Add sender details for admin notifications
    foreach ($admin as &$a) {
        $a['sender_name']  = "";
        $a['sender_image'] = "";
        $a['is_read']      = 0;  // will be calculated using last_seen logic
    }

    // 3️⃣ MERGE BOTH
    $all = array_merge($admin, $user_notifications);
    

    // 4️⃣ SORT DESC BY TIME
    usort($all, function($a, $b) {
        return strtotime($b['created_at']) - strtotime($a['created_at']);
    });
    // Add time ago format
    foreach ($all as &$n) {
        $n['time_ago'] = $this->time_ago($n['created_at']);
    }

    return $all;
}

public function mark_notifications_read($user_id)
{
    // mark user notifications as read
    $this->db->where('user_id', $user_id)
             ->update('notifications', ['is_read' => 1]);

    // update last seen time for admin notifications
    $this->db->where('id', $user_id)
             ->update('users', ['last_notification_seen' => date('Y-m-d H:i:s')]);
}

public function get_unread_user_notifications($user_id)
{
    return $this->db
        ->where('user_id', $user_id)
        ->where('is_read', 0)
        ->count_all_results('notifications');
}
public function get_unread_admin_notifications($user_id)
{
    // get user's last seen time
    $user = $this->db->select('last_notification_seen')
                     ->where('id', $user_id)
                     ->get('users')
                     ->row_array();

    $last_seen = $user['last_notification_seen'];

    // if never opened notifications → all admin notifications are unread
    if (empty($last_seen)) {
        return $this->db->count_all_results('admin_notifications');
    }

    // unread = created_at > last_seen
    return $this->db
        ->where('created_at >', $last_seen)
        ->count_all_results('admin_notifications');
}
public function get_total_unread_notifications($user_id)
{
    $user_unread  = $this->get_unread_user_notifications($user_id);
    $admin_unread = $this->get_unread_admin_notifications($user_id);

    return $user_unread + $admin_unread;
}

public function time_ago($datetime)
{
    $timestamp = strtotime($datetime);
    $difference = time() - $timestamp;

    if ($difference < 60) { 
        return "1m"; // under 1 minute
    }
    if ($difference < 3600) {
        return floor($difference / 60) . "m"; // minutes
    }
    if ($difference < 86400) {
        return floor($difference / 3600) . "h"; // hours
    }
    if ($difference < 604800) {
        return floor($difference / 86400) . "d"; // days
    }
    if ($difference < 2592000) {
        return floor($difference / 604800) . "w"; // weeks
    }

    return floor($difference / 2592000) . "mo"; // months
}

public function get_user_story_only($user_id,$account_type)
{
     $story = $this->db->select('id as story_id, post, created_on')
                          ->from('stories')
                          ->where('user_id', $user_id)
                          ->where('user_type', $account_type)
                          ->where('created_on >=', date('Y-m-d H:i:s', strtotime('-24 hours')))
                          ->order_by('id', 'DESC')
                          ->limit(1)
                          ->get()
                          ->row_array();

        // $story_data = [
        //     "has_story" => !empty($story),
        //     "story_id" => $story['story_id'] ?? null,
        //     "story_file_url" => !empty($story['post']) ? $story['post'] : null,
        //     "created_on" => $story['created_on'] ?? null
        // ];
        return $story;
}
public function get_user_accounts($token)
{
     $user = $this->db->select('id, personal_username, image')
                     ->from('users')
                     ->where('token', $token)
                     ->get()
                     ->result_array();
        return $user;
}

public function add_notification($receiver_id, $sender_id, $type, $message, $content_id)
{
    $data = [
        'user_id'   => $receiver_id,
        'sender_id' => $sender_id,
        'type'      => $type,
        'message'   => $message,
        'content_id'=> $content_id,
        'is_read'   => 0,
        'created_at'=> date('Y-m-d H:i:s')
    ];

    $this->db->insert('notifications', $data);
}
public function get_owner($content_type, $content_id)
{
    $table = '';

    if ($content_type == 'post') $table = 'posts';
    if ($content_type == 'reel') $table = 'reels';
    if ($content_type == 'story') $table = 'stories';

    if ($table == '') return null;

    $row = $this->db->get_where($table, ['id' => $content_id])->row();
    return $row ? $row->user_id : null;
}











}