<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';

//require_once APPPATH . 'third_party/vendor/autoload.php';

require_once APPPATH . 'third_party/Twilio/autoload.php'; // ✅ Correct path to SDK

use Twilio\Jwt\AccessToken;
use Twilio\Jwt\Grants\VideoGrant;
use Twilio\Jwt\Grants\ChatGrant;
use Twilio\Jwt\Grants\VoiceGrant;

use Twilio\TwiML\VoiceResponse;


class Api extends REST_Controller {

	protected $client_request = NULL;

	public function __construct()
	{
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		error_reporting(0);
		set_time_limit(0);
			$this->load->database();

		$this->load->model('api/Api_model','user_model');
		//$this->load->library('Notifications');
		$this->load->library('form_validation');
		$this->load->library('auth_token');
	//	$this->load->database();
	

		
		$this->client_request = new stdClass();
		$this->client_request = json_decode(file_get_contents('php://input', true));
		$this->client_request = json_decode(json_encode($this->client_request), true);
	}
	
	
	/* twilio token generation */
	private $twilioAccountSid = 'ACb4cc47cd9a08f21e30f335f6606e1fdd';
    private $twilioApiKey = 'SKf4c8226854a39de85b358333089ea0aa';
    private $twilioApiSecret = 'Vht7anlX06j6OqQCKCFtSACQ1xEJBDII';
    private $twilioChatServiceSid = ''; // Optional

    public function generate_token($user_id) {
        $identity = $user_id;  // e.g., user ID or username

        // Create access token with credentials
        $token = new AccessToken(
            $this->twilioAccountSid,
            $this->twilioApiKey,
            $this->twilioApiSecret,
            3600,
            $identity
        );

        // Grant access to Video
        $videoGrant = new VideoGrant();
        $token->addGrant($videoGrant);

        // Grant access to Chat (optional)
        $chatGrant = new ChatGrant();
        $chatGrant->setServiceSid($this->twilioChatServiceSid);
        $token->addGrant($chatGrant);

        // Return the token as JSON
        // echo json_encode([
        //     'identity' => $identity,
        //     'token' => $token->toJWT()
        // ]);
        return $token->toJWT();
    }
    
    //use Twilio\Jwt\AccessToken;

public function generate_voice_token_post($user_id) {
    $identity = $user_id;
    if (!$identity) {
        return $this->output->set_status_header(400)->set_output('Missing identity');
    }

    $accountSid = 'ACb4cc47cd9a08f21e30f335f6606e1fdd';
    $apiKeySid = 'SKf4c8226854a39de85b358333089ea0aa';
    $apiKeySecret = 'Vht7anlX06j6OqQCKCFtSACQ1xEJBDII';
    $appSid = 'APeaa990404e6d6ccaca4b762225c5ff71'; // TwiML App SID

    $token = new AccessToken($accountSid, $apiKeySid, $apiKeySecret, 3600, $identity);

    $voiceGrant = new VoiceGrant();
    $voiceGrant->setOutgoingApplicationSid($appSid);
    $voiceGrant->setIncomingAllow(true); // ✅ Allow incoming calls
    $token->addGrant($voiceGrant);

    return $token->toJWT();
}


public function generate_voice_token_new_post($user_id) {
    $identity = $user_id;
    if (!$identity) {
        return $this->output->set_status_header(400)->set_output('Missing identity');
    }

    $accountSid = 'ACa9881846dbacb61101968cfd15dd541e';
    $apiKeySid = 'SK721c8eba862ebfde37226e3a20069698';
    $apiKeySecret = 'g6IpJLuqemqAQEbIZ6Tnlv4HM4aHkbwb';
    $appSid = 'APe4a5cb5feb1278d76992bb2ea8f73759'; // TwiML App SID

    $token = new AccessToken($accountSid, $apiKeySid, $apiKeySecret, 3600, $identity);

    $voiceGrant = new VoiceGrant();
    $voiceGrant->setOutgoingApplicationSid($appSid);
    $voiceGrant->setIncomingAllow(true); // ✅ Allow incoming calls
    $token->addGrant($voiceGrant);

    return $token->toJWT();
}


/* twilio token generation */

/* one signal notification */
public function sendNotification_get($playerId, $title, $message, $user_type = null) {
    $appId = '3c331bfb-1483-4d23-9c4c-bab4caa36b3a'; // Replace with your OneSignal App ID
    $apiKey = 'os_v2_app_hqzrx6yuqngshhcmxk2mvi3lhizn2rajc6ne36v6x7uz7vt6fjbshdrdxueytuit3wuh2tnxle6mxq3nfhr4ay4okjrebkamiekkdoa'; // Replace with your OneSignal REST API Key
    
    $curl = curl_init();

    // Common notification data
    $notificationData = [
        "app_id" => $appId,
        "headings" => ["en" => $title], // Notification title
        "contents" => ["en" => $message], // Notification content
        "small_icon" => "no_bg_logo", // Android Small Icon (Place inside res/drawable),
    ];

    // 1️⃣ *Sending to ALL Users*
    if ($playerId === 'all') {
        //$notificationData["included_segments"] = ["All"]; // Send to all users
        $notificationData["filters"] = [
            ["field" => "tag", "key" => "user_type", "relation" => "=", "value" => $user_type]
        ];
    
    // 2️⃣ *Sending to a Filtered User Type (e.g., Only Employees or Only Users)*
    } /*elseif ($userType !== null) {
        
    
    // 3️⃣ *Sending to Multiple Specific Users*
    }*/ elseif (is_array($playerId)) {
        $notificationData["include_player_ids"] = $playerId; // Send to multiple users
    
    // 4️⃣ *Sending to a Single User*
    } else {
        $notificationData["include_player_ids"] = [$playerId]; // Send to a single user
    }

    curl_setopt_array($curl, [
        CURLOPT_URL => "https://onesignal.com/api/v1/notifications",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => json_encode($notificationData),
        CURLOPT_HTTPHEADER => [
            "Authorization: Key $apiKey", // API Key in Authorization header
            "Content-Type: application/json"
        ],
        CURLOPT_SSL_VERIFYPEER => false, // Disable SSL verification for debugging
    ]);

    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    if ($err) {
        return "cURL Error: " . $err;
    } else {
        return  $response;
    }
}

/* one signal notification */
	
	/*access token*/
public function getAccessToken(){
    $serviceAccountFile = FCPATH . 'application/libraries/firebase.json'; // Update this path
    $jsonKey = json_decode(file_get_contents($serviceAccountFile), true);

    $header = json_encode(['alg' => 'RS256', 'typ' => 'JWT']);
    $now = time();
    $exp = $now + 3600;

    $payload = json_encode([
        'iss' => $jsonKey['client_email'],
        'sub' => $jsonKey['client_email'],
        'aud' => 'https://oauth2.googleapis.com/token',
        'iat' => $now,
        'exp' => $exp,
        'scope' => 'https://www.googleapis.com/auth/firebase.messaging'
    ]);

    $base64UrlHeader = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($header));
    $base64UrlPayload = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($payload));
    $signature = '';

    $data = $base64UrlHeader . '.' . $base64UrlPayload;
    openssl_sign($data, $signature, $jsonKey['private_key'], 'sha256');

    $base64UrlSignature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($signature));
    $jwt = $data . '.' . $base64UrlSignature;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://oauth2.googleapis.com/token');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
        'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
        'assertion' => $jwt
    ]));

    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        echo 'Curl error: ' . curl_error($ch);
    }
    curl_close($ch);

    $responseData = json_decode($response, true);
    //print_r($responseData);exit;
    if (isset($responseData['access_token'])) {
        return $responseData['access_token'];
    } else {
        echo 'Error fetching access token: ' . $response;
        return null;
    }
}
/*access token*/

	/*REFERANCE CODE*/
	function referance_post(){
		$response = array('status' => false, 'message' => '', 'response' => array());
		$user_input = $this->client_request;
		extract($user_input);
		if(!$id)
		{
			$response = array('status' => false, 'message' => 'Enter Email ID!', 'response' => array());
			$this->response($response);
		}
		
		
		$this->response($response);
	}
    /*REFERANCE CODE*/
    
    /*token authentication*/
    public function token_get($mobile,$token,$player_id,$app_version)
    {
        $key = "Uappkey";
    	$iat = time(); // current timestamp value
        //$exp = $iat + 60;
        
    	/*$payload = array(
            "iss" => "Issuer of the JWT",
            "aud" => "Audience that the JWT",
            "sub" => "Subject of the JWT",
            "iat" => $iat, //Time the JWT issued at
            //"exp" => $exp, // Expiration time of token
            "email" => 'adi@gmail.com',
        );*/
        
        $payload = array(
            //"id"            => $check_user[0]['id'],
            "phone_number"        => $mobile,
           // "email"         => $check_user[0]['email'],
            "iat"           => $iat, //Time the JWT issued at
            //"exp"           => $exp, // Expiration time of token
        );
              
        $auth_token = $this->auth_token->generateToken($payload,$key,'HS256');
       // echo $token;exit;
      //  $check_user[0]['auth_token'] = $auth_token;
      $check = $this->user_model->common_fetch('users',array('mobile' => $mobile,'delete_status' => 1));
     // echo $check[0]['status'];exit;
      if(empty($check)){
        //   $data = array(
        //       'mobile' => $mobile,
        //   'auth_token'     => $auth_token,
        //   'token'          => $token,
        //   'status'       => 1,
        //   'created_on' => date('Y-m-d H:i:s')
        // );
        // $insert = $this->user_model->common_insert('users',$data);
        // $check = $this->user_model->common_fetch('users',array('id' => $insert,'delete_status' => 1));
        
        
        $response = array('status' => true, 'message' => 'No user with this number.Please register.', 'response' => array('user_details' => array()));
        $this->response($response);
      }else if($check[0]['status'] == 0){
          $response = array('status' => false, 'message' => 'User is In Active.', 'response' => array('user_details' => array()));
        $this->response($response);
      }else{
          $data = array(
           'auth_token'     => $auth_token,
           'token'          => $token,
           'player_id'     => $player_id,
         //  'app_version'  => $app_version,
          'updated_on' => date('Y-m-d H:i:s')
        );
        $update = $this->user_model->common_update('users',$data,array('mobile' => $mobile,'delete_status' => 1));
        $check = $this->user_model->common_fetch('users',array('mobile' => $mobile,'delete_status' => 1));
        
         $response = array('status' => true, 'message' => 'User logged in successfully', 'response' => array('user_details' =>$check));
        $this->response($response);
      }
       
    }
    
     public function token_get_registration($id,$token,$player_id)
    {
        $check = $this->user_model->common_fetch('users',array('id' => $id));
        $key = "Freeaddbizkey";
    	$iat = time(); // current timestamp value
        //$exp = $iat + 60;
        
    	/*$payload = array(
            "iss" => "Issuer of the JWT",
            "aud" => "Audience that the JWT",
            "sub" => "Subject of the JWT",
            "iat" => $iat, //Time the JWT issued at
            //"exp" => $exp, // Expiration time of token
            "email" => 'adi@gmail.com',
        );*/
        
        $payload = array(
            //"id"            => $check_user[0]['id'],
            "phone_number"        => $check[0]['mobile'],
           // "email"         => $check_user[0]['email'],
            "iat"           => $iat, //Time the JWT issued at
            //"exp"           => $exp, // Expiration time of token
        );
              
        $auth_token = $this->auth_token->generateToken($payload,$key,'HS256');
       // echo $token;exit;
      //  $check_user[0]['auth_token'] = $auth_token;
     // $check = $this->user_model->common_fetch('users',array('mobile' => $mobile,'delete_status' => 1));
      if(empty($check)){
        //   $data = array(
        //       'mobile' => $mobile,
        //   'auth_token'     => $auth_token,
        //   'token'          => $token,
        //   'status'       => 1,
        //   'created_on' => date('Y-m-d H:i:s')
        // );
        // $insert = $this->user_model->common_insert('users',$data);
        // $check = $this->user_model->common_fetch('users',array('id' => $insert,'delete_status' => 1));
        
        
        $response = array('status' => false, 'message' => 'Invalid mobile number.', 'response' => (object)array());
        $this->response($response);
      }else{
          $data = array(
           'auth_token'     => $auth_token,
           'token'          => $token,
           'player_id'     => $player_id,
          'updated_on' => date('Y-m-d H:i:s')
        );
        $update = $this->user_model->common_update('users',$data,array('id' => $id));
        $check = $this->user_model->common_fetch('users',array('id' => $id));
     //   $get_profiles = $this->user_model->get_user_profiles($id);
       // $check[0]['profiles'] = $get_profiles['has_data'];
        
        
        //   $title = "Welcome Message";
        //     $message = "Welcome to U App uniting worlds.";
        //     $user_type = 1;
        //     $member_id = $check_user[0]['player_id'];
        //     $this->sendNotification_get($member_id,$title,$message,$user_type);//exit;
            
     
      
        $response = array('status' => true, 'message' => 'User Registeation successfully', 'response' => array('user_details' =>$check));
        $this->response($response);
      }
    }

    /*token authentication*/

	/* login module*/
    public function user_login_post()
    {
        $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($token)){
			$response = array('status' => false, 'message' => 'Token Is Empty', 'response' => (object)array());
            $this->response($response);
		}else if(empty($password)){
			$response = array('status' => false, 'message' => 'OTP Confirm Is Empty', 'response' => (object)array());
            $this->response($response);
		}else{
		    	$check_user = $this->user_model->common_fetch('users',array('mobile' => $mobile,'delete_status' => 1));
		    	if(empty($check_user)){
		    	    	$response = array('status' => false, 'message' => 'No User With this details', 'response' => (object)array());
            $this->response($response);
		    	}else{
		    	    if($check_user[0]['password'] != md5($password)){
		    	        $response = array('status' => false, 'message' => 'Wrong password...!', 'response' => (object)array());
            $this->response($response);
		    	    }else{
		    	        $app_versionq = '';
		    	         $this->token_get($mobile,$token,$player_id,$app_versionq);
		    	    }
		    	    
		    	}
		    
		    
		   // if($otp_confirmed == 'no'){
           // $otp = mt_rand(1000, 9999);
           // $this->send_otp_sms_post($mobile,$otp);
         //   $message = "$otp is your OTP for U app login.";
            //$this->send_otp_sms_post($mobile,$otp);
       //  echo  $this->send_otp_sms_post($mobile,$otp);exit;
            // SendSMS($mobile, $message);
            //$message = "Dear user, OTP for Yummazing App is " . $otp . ", please don't share. Valid for 10 mins. Regards, Yummazing Team ";
            //SendSMSSarvi($mobile, $message);
            //$subject = "Sami Grocery-OTP";
            //SendMAIL($email_id, $message, $subject);
            
           
        //   $response = array('status' => true, 'message' => 'Otp sent successfully!', 'response' => array('otp' => "$otp") );
        //     $this->response($response);
          
            
       // }
//         else if($otp_confirmed == 'yes'){
            
//      $app_versionq = "";      	
// 	//	$check_user = $this->user_model->common_fetch('users',array('mobile' => $mobile,'delete_status' => 1));
// 	if(!empty($app_version)){
// 	    $app_versionq = $app_version;
// 	}
		
// 			  $this->token_get($mobile,$token,$player_id,$app_versionq);
//         }
		
	
		}
	}

	/* login module*/
	
	/* forgot password*/
	public function forgot_password_post()
    {
        $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($password)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
		
	//	$check_user = $this->user_model->common_fetch('users',array('mobile' => $mobile,'delete_status' => 1,'status' => 1));
		//print_r($check_user);
// 			if(empty($check_user[0])){
// 				$response = array('status' => false, 'message' => 'No User With These Details', 'response' => (object)array());
// 				$this->response($response);
// 			}else{
			   		   if($otp_confirmed == 'no'){
 
			    
                            $otp = mt_rand(1000, 9999);
                           // $this->send_otp_sms_post($mobile,$otp);
                            $message = "$otp is your OTP for U app login.";
                            //$this->send_otp_sms_post($mobile,$otp);
                       //  echo  $this->send_otp_sms_post($mobile,$otp);exit;
                            // SendSMS($mobile, $message);
                            //$message = "Dear user, OTP for Yummazing App is " . $otp . ", please don't share. Valid for 10 mins. Regards, Yummazing Team ";
                            //SendSMSSarvi($mobile, $message);
                            //$subject = "Sami Grocery-OTP";
                            //SendMAIL($email_id, $message, $subject);
                            
                           
                           $response = array('status' => true, 'message' => 'Otp sent successfully!', 'response' => array('otp' => "$otp") );
                            $this->response($response);
			   		   }else{
			   		       $data = array(
			   		           'password' => md5($password),
			   		           'updated_on' => date('Y-m-d H:i:s')
			   		           );
			   		            $this->user_model->common_update('users',$data,array('mobile' => $mobile,'delete_status' => 1));
			   		            $response = array('status' => true, 'message' => 'Registration Completed Successfully', 'response' => (object)array());
    				$this->response($response);
			   		   }
          
            
        
       
		//	}
		}
	}
	
	/* forgot password*/
	/* resend otp*/
	public function resend_otp_post()
    {
        $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'Mobile Number Is Empty', 'response' => (object)array());
            $this->response($response);
        }else{
		
	//	$check_user = $this->user_model->common_fetch('users',array('mobile' => $mobile,'delete_status' => 1,'status' => 1));
		//print_r($check_user);
// 			if(empty($check_user[0])){
// 				$response = array('status' => false, 'message' => 'No User With These Details', 'response' => (object)array());
// 				$this->response($response);
// 			}else{
			   		
 
			    
                            $otp = mt_rand(1000, 9999);
                           // $this->send_otp_sms_post($mobile,$otp);
                            $message = "$otp is your OTP for U app login.";
                            //$this->send_otp_sms_post($mobile,$otp);
                       //  echo  $this->send_otp_sms_post($mobile,$otp);exit;
                            // SendSMS($mobile, $message);
                            //$message = "Dear user, OTP for Yummazing App is " . $otp . ", please don't share. Valid for 10 mins. Regards, Yummazing Team ";
                            //SendSMSSarvi($mobile, $message);
                            //$subject = "Sami Grocery-OTP";
                            //SendMAIL($email_id, $message, $subject);
                            
                           
                           $response = array('status' => true, 'message' => 'Otp sent successfully!', 'response' => array('otp' => "$otp") );
                            $this->response($response);
			   		  
          
            
        
       
		//	}
		}
	}
	
	/* resend otp*/
	
		/*user registartion update*/
	public function user_registration_post()
	{
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($mobile)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($otp_confirmed)){
 			$response = array('status' => false, 'message' => 'OTP Confirm Is Empty', 'response' => (object)array());
            $this->response($response);
 		}

        else if(empty($token)){
			$response = array('status' => false, 'message' => 'Token Is Empty', 'response' => (object)array());
            $this->response($response);
		}
//else if(empty($otp_confirmed)){
// 			$response = array('status' => false, 'message' => 'OTP Confirm Is Empty', 'response' => (object)array());
//             $this->response($response);
// 		}else if(empty($email)){
//             $response = array('status' => false, 'message' => 'Email ID Is Empty', 'response' => array());
//             $this->response($response);
//         }else if(empty($name)){
//             $response = array('status' => false, 'message' => 'name Is Empty', 'response' => array());
//             $this->response($response);
//         }else if(empty($dob)){
//             $response = array('status' => false, 'message' => 'Date of birth Is Empty', 'response' => array());
//             $this->response($response);
//         }else if(empty($gender)){
//             $response = array('status' => false, 'message' => 'Gender Is Empty', 'response' => array());
//             $this->response($response);
//         }else if(empty($from_city)){
//             $response = array('status' => false, 'message' => 'From city Is Empty', 'response' => array());
//             $this->response($response);
//         }else if(empty($stay_city)){
//             $response = array('status' => false, 'message' => 'Stay city Is Empty', 'response' => array());
//             $this->response($response);
//         }else if(empty($latitude)){
//             $response = array('status' => false, 'message' => 'Latitude Is Empty', 'response' => array());
//             $this->response($response);
//         }else if(empty($longitude)){
//             $response = array('status' => false, 'message' => 'Longitude Is Empty', 'response' => array());
//             $this->response($response);
//         }else if(empty($token)){
//             $response = array('status' => false, 'message' => 'Token Is Empty', 'response' => array());
//             $this->response($response);
//         }else{
            
            $check_user = $this->user_model->common_fetch('users',array('mobile' => $mobile,'delete_status' => 1));
            if(!empty($check_user)){
                $app_version = '';
               //  $this->token_get($mobile,$token,$player_id,$app_version);
                $response = array('status' => false, 'message' => 'Your mobile number already have a account.please login.', 'response' => array());
            $this->response($response);
            }else{
                
            
            
               if($otp_confirmed == 'no'){
            $otp = mt_rand(1000, 9999);
           // $this->send_otp_sms_post($mobile,$otp);
            $message = "$otp is your OTP for U app login.";
            //$this->send_otp_sms_post($mobile,$otp);
       //  echo  $this->send_otp_sms_post($mobile,$otp);exit;
            // SendSMS($mobile, $message);
            //$message = "Dear user, OTP for Yummazing App is " . $otp . ", please don't share. Valid for 10 mins. Regards, Yummazing Team ";
            //SendSMSSarvi($mobile, $message);
            //$subject = "Sami Grocery-OTP";
            //SendMAIL($email_id, $message, $subject);
            
           
           $response = array('status' => true, 'message' => 'Otp sent successfully!', 'response' => array('otp' => "$otp") );
            $this->response($response);
          
            
               }else if($otp_confirmed == 'yes'){
                   
                //   if(empty($languages)){
                       
                         if(!empty($image)){
                                   define('IMAGE_UPLOAD_DIR','assets/images/users/');
                    				$img = str_replace('data:image/jpeg;base64','',$image);
                    				$img = str_replace(' ','+',$img);
                    				$user_data = base64_decode($img);
                    				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
                    				$success = file_put_contents($user_file,$user_data); 
				
                    				if($success){
                    				    $image_link = $user_file;
                    				//     unlink($get_child_detaiils[0]['father_image']);
                        				
                        			
                    				}else{
                    				    $image_link = '';
                    				}
                               }else{
                                   $response = array('status' => false, 'message' => 'Profile Image Is Empty', 'response' => array());
            $this->response($response);
                               } 
           
               $data = array(
                            'user_type' => $user_type,
    			            'name' => $name,
    			            'personal_username' => $personal_username,
    			            'bussiness_username' => $bussiness_username,
    			            'mobile' => $mobile,
    			            'dob' => $dob,
    			            'bio' => $bio,
    			            'image' => $image_link,
    			            'password' => md5($password),
    			            'private_account' => $private_account,
    			            'created_on' =>date('Y-m-d H:i:s')
    			            );
    			            $insert = $this->user_model->common_insert('users',$data);
    			            if($insert){
    			                 $this->token_get_registration($insert,$token,$player_id);
    			               
    			            }
    			           
    			            
    				$response = array('status' => true, 'message' => 'Registration Completed Successfully', 'response' => array());
    				$this->response($response);
      //  }
             
    			
    			    
    			     
    			
            

        }
        
            }
           			
	//	}
	}
	/*user registartion update*/
	
	/*user location update */
	public function profile_post()
    {
        $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Latitude Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($view_type)){
            $response = array('status' => false, 'message' => 'Longitude Is Empty', 'response' => (object)array());
            $this->response($response);
        }
        // else if(empty($address)){
        //     $response = array('status' => false, 'message' => 'Address Is Empty', 'response' => (object)array());
        //     $this->response($response);
        // }
        else{
             $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
	    if($check_user[0]['status']==1){
    	    if($auth_token==$check_user[0]['auth_token']){
    
            if($view_type == 'view_profile'){
                $profile = $this->user_model->common_fetch('users',array('id' => $user_id));
                $response = array('status' => true, 'message' => 'Data fetched successfully..!', 'response' => $profile);
    				$this->response($response);
            }elseif($view_type == 'update_profile'){
                 if(!empty($image)){
                                   define('IMAGE_UPLOAD_DIR','assets/images/users/');
                    				$img = str_replace('data:image/jpeg;base64','',$pic);
                    				$img = str_replace(' ','+',$img);
                    				$user_data = base64_decode($img);
                    				$user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
                    				$success = file_put_contents($user_file,$user_data); 
                    					if($success){
                    				    $image_link = $user_file;
                    				//     unlink($get_child_detaiils[0]['father_image']);
                        				
                        			
                    				}else{
                    				    $image_link =  $image_link = $check_user[0]['image'] ;
                    				}
                               }else{
                                  $image_link = $check_user[0]['image'];
                               }
              $data = array( 
    			            'name' => $name,
    			            'personal_username' => $personal_username,
    			            'bussiness_username' => $bussiness_username,
    			            'dob' => $dob,
    			            'bio' => $bio,
    			            'image' => $image_link,
    			            
    			            'updated_on' =>date('Y-m-d H:i:s')
    			            );
    			    $this->user_model->common_update('users',$data,array('id' => $user_id));
    			//echo $this->db->last_query();exit;
    			   	$response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array());
    				$this->response($response);
            }else if($view_type == 'update_bussiness_address'){
                 $data = array(
    			            'house_no' => $house_no,
    			            'area' => $area,
    			            'landmark' => $landmark,
    			            'pincode' => $pincode,
    			            'state' => $state,
    			            'bussiness_mobile' => $bussiness_mobile,
    			            'city_village' => $city_village,
    			            'price'    => $price,
    			            'updated_on' =>date('Y-m-d H:i:s')
    			            );
    			    $this->user_model->common_update('users',$data,array('id' => $user_id));
    			     $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array());
    				$this->response($response);
            }else if($view_type == 'update_account_privacy'){
                 $data = array(
    			            'private_account' => $private_account,
    			            'updated_on' =>date('Y-m-d H:i:s')
    			            );
    			    $this->user_model->common_update('users',$data,array('id' => $user_id));
    			    $response = array('status' => true, 'message' => 'Data Updated Successfully', 'response' => array());
    				$this->response($response);
            }
    	    }else if($view_type == 'view_accounts'){
    	        if(!empty($token)){
    	            $profile = $this->user_model->get_user_accounts($token);
            $response = array('status' => false, 'message' => 'Data fetched successfully..!', 'response' => $profile);
            $this->response($response);
            }else{
                $response = array('status' => true, 'message' => 'Token is empty', 'response' => (object)array());
    				$this->response($response);
            }
    	    }else{
    	        $response = array('status' => false, 'message' => 'token not verified', 'response' => (object)array());
            $this->response($response);
    	    }
	    }else{
	        $response = array('status' => false, 'message' => 'Your account is inactive', 'response' => (object)array());
            $this->response($response);
	    }
			
		}
    }
	/*user location update */
	
		/*user location update */
	public function user_notifications_post()
    {
        $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Latitude Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($view_type)){
            $response = array('status' => false, 'message' => 'Longitude Is Empty', 'response' => (object)array());
            $this->response($response);
        }
        // else if(empty($address)){
        //     $response = array('status' => false, 'message' => 'Address Is Empty', 'response' => (object)array());
        //     $this->response($response);
        // }
        else{
             $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
	    if($check_user[0]['status']==1){
    	    if($auth_token==$check_user[0]['auth_token']){
    
            if($view_type == 'view_notifications'){
                $notifications = $this->user_model->get_notifications($user_id);
                $update = $this->user_model->mark_notifications_read($user_id);
                 $response = array('status' => true, 'message' => 'Data fetched successfully..!', 'response' => $notifications);
    				$this->response($response);
            }else if($view_type == 'view_notification_count'){
                $count = $this->user_model->get_total_unread_notifications($user_id);
                $response = array('status' => true, 'message' => 'Data fetched successfully..!', 'response' => $count);
    				$this->response($response);
            }
    	    }else{
    	        $response = array('status' => false, 'message' => 'token not verified', 'response' => (object)array());
            $this->response($response);
    	    }
	    }else{
	        $response = array('status' => false, 'message' => 'Your account is inactive', 'response' => (object)array());
            $this->response($response);
	    }
			
		}
    }
	/*user location update */
	/*locations details*/
	public function all_items_post()
	{
	    $user_input = $this->client_request;
	    extract($user_input);
	    
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($view_type)){
            $response = array('status' => false, 'message' => 'View Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($page)){
            $response = array('status' => false, 'message' => 'Page Is Empty', 'response' => (object)array());
            $this->response($response);
        }
        // else if(empty($address)){
        //     $response = array('status' => false, 'message' => 'Address Is Empty', 'response' => (object)array());
        //     $this->response($response);
        // }
        else{
             switch($view_type){
        case 'view_category':
            if(empty($page) && empty($cat_type)){
                return $this->response([
                    'status' => false,
                    'message' => 'please fill all required fields',
                    'response' => (object)[]
                ]);
            }
            $page       = isset($user_input['page']) ? (int)$user_input['page'] : 1;
            $limit      = isset($user_input['limit']) ? (int)$user_input['limit'] : 10; 
            $offset     = ($page - 1) * $limit;
            $get_main_data = $this->user_model->get_bussiness_categories($cat_type,$limit, $offset);
            if (!$get_main_data) {
                return $this->response(['status' => false, 'message' => 'no data found', 'response' => (object)[]]);
            }
        
        
            $translated_main_data = $get_main_data;
            
            $final['categories'] = $translated_main_data;
            
            $total_records = $this->user_model->get_bussiness_categories_rows(); // Function to count total records
            $total_pages = ceil($total_records / $limit);
            $pages = [];
        
            for ($t = 1; $t <= $total_pages; $t++) {
                $pages[] = ['page' => $t];
            }
        
            $final['pagination'] = [
                'total_pages' => $pages,
                'current_page' => $page,
                'limit' => $limit
            ];
            return $this->response(['status' => true, 'message' => 'data fetched successfully', 'response' => $final]);
            break;
        case 'view_audio':
            if(empty($page)){
                return $this->response([
                    'status' => false,
                    'message' => 'please fill all required fields',
                    'response' => (object)[]
                ]);
            }
            $page       = isset($user_input['page']) ? (int)$user_input['page'] : 1;
            $limit      = isset($user_input['limit']) ? (int)$user_input['limit'] : 10; 
            $offset     = ($page - 1) * $limit;
            $get_main_data = $this->user_model->get_audio_songs($limit, $offset);
           // echo $this->db->last_query();exit;
            if (!$get_main_data) {
                return $this->response(['status' => false, 'message' => 'no data found', 'response' => (object)[]]);
            }
        
        
            $translated_main_data = $get_main_data;
            
            $final['songs'] = $get_main_data;
            
            $total_records = $this->user_model->get_audio_songs_rows(); // Function to count total records
            $total_pages = ceil($total_records / $limit);
            $pages = [];
        
            for ($t = 1; $t <= $total_pages; $t++) {
                $pages[] = ['page' => $t];
            } 
        
            $final['pagination'] = [
                'total_pages' => $pages,
                'current_page' => $page,
                'limit' => $limit
            ];
            return $this->response(['status' => true, 'message' => 'data fetched successfully', 'response' => $final]);
            break;
        case 'search_audio':
            if(empty($search_key)){
                return $this->response([
                    'status' => false,
                    'message' => 'please fill all required fields',
                    'response' => (object)[]
                ]);
            }
            // $page       = isset($user_input['page']) ? (int)$user_input['page'] : 1;
            // $limit      = isset($user_input['limit']) ? (int)$user_input['limit'] : 10; 
            // $offset     = ($page - 1) * $limit;
            $get_main_data = $this->user_model->get_audio_songs_search($search_key);
            if (!$get_main_data) {
                return $this->response(['status' => false, 'message' => 'no data found', 'response' => (object)[]]);
            }
        
        
            $translated_main_data = $get_main_data;
            
            $final['songs'] = $translated_main_data;
            
            return $this->response(['status' => true, 'message' => 'data fetched successfully', 'response' => $final]);
            break;
        case 'insert':
        
            // Validate required fields
            if (empty($name) || empty($date) || empty($time) || empty($notes) || empty($image)) {
                return $this->response([
                    'status' => false,
                    'message' => 'Please fill all required fields',
                    'response' => (object)[]
                ]);
            }
        
            //  Insert main report
            $data = [
                'main_data_id'          => $main_data_id,
                'trade_marketer_id' => $user_id,
                'name'                  => $name,
                'date'                  => $date,
                'time'                  => $time,
                'notes'                 => $notes,
                'created_on'            => date('Y-m-d H:i:s'),
            ];
        
            $insert_id = $this->user_model->common_insert('trade_marketer_daily_reports', $data);
        
            if (!$insert_id) {
                return $this->response([
                    'status' => false,
                    'message' => 'Failed to insert report',
                    'response' => (object)[]
                ]);
            }
        
            // Setup upload folder (full server path)
            $upload_dir = FCPATH . 'assets/admin/daily_reports/';
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir, 0777, true);
            }
        
            $allowed_types = ['jpg', 'jpeg', 'png'];
            $uploaded_files = [];
            $failed_files = [];
        
            // Function to detect file extension
            function guess_file_extension($decoded)
            {
                if (substr($decoded, 0, 8) === "\x89PNG\x0D\x0A\x1A\x0A") return 'png';
                if (substr($decoded, 0, 3) === "\xFF\xD8\xFF") return 'jpg';
                return false;
            }
        
            // Loop through each image
            $img = explode(',',$image);
            foreach ($img as $key => $base64_data) {
        
                // Remove base64 prefix if exists
                if (strpos($base64_data, 'base64,') !== false) {
                    $base64_data = explode('base64,', $base64_data)[1];
                }
        
                $base64_data = str_replace(' ', '+', $base64_data);
                $decoded = base64_decode($base64_data);
        
                if ($decoded === false) {
                    $failed_files[] = ['index' => $key, 'reason' => 'Invalid base64 data'];
                    continue;
                }
        
                $ext = guess_file_extension($decoded);
                if (!$ext || !in_array($ext, $allowed_types)) {
                    $failed_files[] = ['index' => $key, 'reason' => 'Unsupported or unknown format'];
                    continue;
                }
        
                // Save file
                $file_name = uniqid('report_') . '.' . $ext;
                $file_path = $upload_dir . $file_name;
                $db_path = 'assets/admin/daily_reports/' . $file_name;
        
                if (file_put_contents($file_path, $decoded) !== false) {
                    // Success
                    $uploaded_files[] = base_url($db_path);
        
                    // Save to DB
                    $this->user_model->common_insert('trade_marketer_daily_report_images', [
                        'report_id'  => $insert_id,
                        'image'      => $db_path,
                        'created_on' => date('Y-m-d H:i:s')
                    ]);
                } else {
                    $failed_files[] = ['index' => $key, 'reason' => 'File write failed', 'path' => $file_path];
                }
            }
        
            // Final response
            $message = 'data inserted successfully';
            if (!empty($failed_files)) {
                $message .= ', but some images failed to upload';
            }
        
            return $this->response([
                'status' => true,
                'message' => $message,
                'response' => (object)[
                    'report_id'      => $insert_id,
                    'uploaded_files' => $uploaded_files,
                    'failed_files'   => $failed_files
                ]
            ]);

            break;
        default:
        // Fallback if no case matches
        return $this->response([
            'status' => false,
            'message' => 'Invalid view_type provided',
            'response' => (object)[]
        ]);
    } 
        }
	    
	    $cities = $this->user_model->common_fetch('cities',array('delete_status' => '1'));
	    if(empty($cities)){
	        $response = array('status' => false, 'message' => 'Empty Cities Details', 'response' => array());
				$this->response($response);
	    }else{
	            $response = array('status' => true, 'message' => 'All Cities Details Fetched', 'response' => $cities);
				$this->response($response);
	    }
	}
	/*loactions get*/
	
	/*upload posts reels stories */
	public function upload_all_posts_post(){
    // Retrieve POST fields (from multipart/form-data)
    $user_id          = $this->input->post('user_id');
    $user_type             = $this->input->post('user_type');
    $view_type          = $this->input->post('view_type');
    $type            = $this->input->post('type');
    $cat_id            = $this->input->post('cat_id');
   // $post            = $this->input->post('image');
    $post_type            = $this->input->post('post_type');
    $song_id            = $this->input->post('song_id');
    $shop_name            = $this->input->post('shop_name');
    $house_no            = $this->input->post('house_no');
    $area            = $this->input->post('area');
     $landmark            = $this->input->post('landmark');
      $pincode            = $this->input->post('pincode');
       $state            = $this->input->post('state');
        $lat            = $this->input->post('lat');
        $lon            = $this->input->post('lon');
        $price           = $this->input->post('price');
        $address_status            = $this->input->post('address_status');
        $post_content = $this->input->post('post_content');
        $price_view = $this->input->post('price_view');
        $tag = $this->input->post('tag');
    
//print_r($_FILES['image']);exit;
    // Validate required fields
    if (empty($user_id) || empty($view_type)) {
        $response = array(
            'status' => false,
            'message' => 'Please fill all the required fields',
            'response' => (object)[]
        );
        return $this->response($response);
    }
    
        switch($view_type){
        case 'upload_story':
            
           $uploadPath = 'assets/stories/';
            $imageFileName = '';
            if (!empty($_FILES['post']['name'])) {
                $config['upload_path']   = $uploadPath;
                $config['allowed_types'] = 'jpg|jpeg|JPG|JPEG|png|mp4|mov|avi|mkv';

                $config['max_size']      = 20480; // 2 MB
                $config['file_name']     = uniqid() . '_' . $_FILES['post']['name'];
                $config['detect_mime']   = true;
$config['overwrite']     = false;
        
                $this->load->library('upload', $config);
                // ✅ Add MIME override here
// $this->upload->set_mimes([
//     'jpeg' => ['image/jpeg', 'image/pjpeg'],
//     'jpg'  => ['image/jpeg', 'image/pjpeg', 'image/jpg'],
// ]);
        
                if ($this->upload->do_upload('post')) {
                    $uploadData    = $this->upload->data();
                    $imageFileName = $uploadPath . $uploadData['file_name'];
                } else {
                    $response = array(
                        'status' => false,
                        'message' => strip_tags($this->upload->display_errors()),
                        'response' => (object)[]
                    );
                    return $this->response($response);
                }
            } else {
                $response = array(
                    'status' => false,
                    'message' => 'Please upload an image',
                    'response' => (object)[]
                );
                return $this->response($response);
            }
            
            
        
            // Prepare insert data
            $data = array(
                'user_type'  => $user_type,
                'user_id'           => $user_id,
                'type'              => $type,
                'cat_id'              => $cat_id,
                'post'             => $imageFileName,
                'post_type'        => $post_type,
                'post_content'     => $post_content,
                'posted_date'       => date('Y-m-d H:i:s'),
                'song_id'           => $song_id,
                'shop_name'         => $shop_name,
                'house_no'         => $house_no,
                'area'     => $area,
                'landmark'     => $landmark,
                'pincode' => $pincode,
                'state'   => $state,
                'address_status' => $address_status,
                'lat'           => $lat,
                'lon'         => $lon,
                'price'       => $price,
                'price_view'   => $price_view,
                'tag'         => $tag,
                'created_on'        => date('Y-m-d H:i:s')
            );
        
            // Insert into DB
            $insert = $this->user_model->common_insert('stories', $data);
        
            
        
                $response = array(
                    'status' => true,
                    'message' => 'data inserted successfully',
                    'response' => (object)[]
                );
            return $this->response($response);
                    
            break;
         case 'upload_reel':
            
           $uploadPath = 'assets/reels/';
            $imageFileName = '';
            if (!empty($_FILES['post']['name'])) {
                $config['upload_path']   = $uploadPath;
                $config['allowed_types'] = 'jpg|jpeg|png|mp4|mov|avi|mkv';
                $config['max_size']      = 20480; // 2 MB
                $config['file_name']     = uniqid() . '_' . $_FILES['post']['name'];
        
                $this->load->library('upload', $config);
        
                if ($this->upload->do_upload('post')) {
                    $uploadData    = $this->upload->data();
                    $imageFileName = $uploadPath . $uploadData['file_name'];
                } else {
                    $response = array(
                        'status' => false,
                        'message' => strip_tags($this->upload->display_errors()),
                        'response' => (object)[]
                    );
                    return $this->response($response);
                }
            } else {
                $response = array(
                    'status' => false,
                    'message' => 'Please upload an image',
                    'response' => (object)[]
                );
                return $this->response($response);
            }
        
            // Prepare insert data
            $data = array(
                'user_type'  => $user_type,
                'user_id'           => $user_id,
                'type'              => $type,
                'cat_id'              => $cat_id,
                'post'             => $imageFileName,
                'post_type'        => $post_type,
                'post_content'     => $post_content,
                'posted_date'       => date('Y-m-d H:i:s'),
                'song_id'           => $song_id,
                'shop_name'         => $shop_name,
                'house_no'         => $house_no,
                'area'     => $area,
                'landmark'     => $landmark,
                'pincode' => $pincode,
                'state'   => $state,
                'address_status' => $address_status,
                'lat'           => $lat,
                'lon'         => $lon,
                'price'       => $price,
                'price_view'   => $price_view,
                'tag'         => $tag,
                'created_on'        => date('Y-m-d H:i:s')
            );
        
            // Insert into DB
            $insert = $this->user_model->common_insert('reels', $data);
        
            
        
                $response = array(
                    'status' => true,
                    'message' => 'data inserted successfully',
                    'response' => (object)[]
                );
            return $this->response($response);
                    
            break;
        case 'upload_post':
            
           $uploadPath = 'assets/posts/';
            $imageFileName = '';
            if (!empty($_FILES['post']['name'])) {
                $config['upload_path']   = $uploadPath;
                $config['allowed_types'] = 'jpg|jpeg|png|mp4|mov|avi|mkv';
                $config['max_size']      = 20480; // 2 MB
                $config['file_name']     = uniqid() . '_' . $_FILES['post']['name'];
        
                $this->load->library('upload', $config);
        
                if ($this->upload->do_upload('post')) {
                    $uploadData    = $this->upload->data();
                    $imageFileName = $uploadPath . $uploadData['file_name'];
                } else {
                    $response = array(
                        'status' => false,
                        'message' => strip_tags($this->upload->display_errors()),
                        'response' => (object)[]
                    );
                    return $this->response($response);
                }
            } else {
                $response = array(
                    'status' => false,
                    'message' => 'Please upload an image',
                    'response' => (object)[]
                );
                return $this->response($response);
            }
        
            // Prepare insert data
            $data = array(
                'user_type'  => $user_type,
                'user_id'           => $user_id,
                'type'              => $type,
                'cat_id'              => $cat_id,
                'post'             => $imageFileName,
                'post_type'        => $post_type,
                'post_content'     => $post_content,
                'posted_date'       => date('Y-m-d H:i:s'),
                'song_id'           => $song_id,
                'shop_name'         => $shop_name,
                'house_no'         => $house_no,
                'area'     => $area,
                'landmark'     => $landmark,
                'pincode' => $pincode,
                'state'   => $state,
                'address_status' => $address_status,
                'lat'           => $lat,
                'lon'         => $lon,
                'price'       => $price,
                'price_view'   => $price_view,
                'tag'         => $tag,
                'created_on'        => date('Y-m-d H:i:s')
            );
      //  print_r($data);exit;
            // Insert into DB
            $insert = $this->user_model->common_insert('posts', $data);
        
            
        
                $response = array(
                    'status' => true,
                    'message' => 'data inserted successfully',
                    'response' => (object)[]
                );
            return $this->response($response);
                    
            break;
       
              default:
        // Fallback if no case matches
        return $this->response([
            'status' => false,
            'message' => 'Invalid view_type provided',
            'response' => (object)[]
        ]);
            
        }


}

/* upload reels post stoties */

    // Follow a user
    public function follow_unfollow_user_post(){
    	$response = array('status' => false, 'message' => '', 'response' => array());
	$user_input = $this->client_request;
	extract($user_input);
	
	if(empty($user_id) || empty($user_mode) || empty($auth_token)  || empty($view_type)){
	    $response = array('status' => false, 'message' => 'please fill all the required fields', 'response' => (object)array());
        $this->response($response);
	}else{
	    $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
	  //  echo $this->db->last_query();
	 //   print_r($check_user);
	  //  echo $check_user[0]['status'];exit;
	    if($check_user[0]['status']==1){
    	    if($auth_token==$check_user[0]['auth_token']){
    	        if($view_type=='follow'){
    	             if ($follower_id == $user_id) 
    	             {
    	                 $response = array('status' => false, 'message' => 'cannot follow self', 'response' => (object)array());
				$this->response($response);
    	                // return false; // cannot follow self
                      }
       // $exists = $this->Ws_model->common_fetch('user_followers', [ 'follower_id' => $follower_id,'following_id' => $user_id,'follower_mode' => $follower_mode,'following_mode' => $user_mode]);
          $exists = $this->user_model->common_fetch('user_followers', [ 'following_id' => $user_id,'follower_id' => $follower_id]);
        if (!empty($exists)) {
            $response = array('status' => false, 'message' => 'already following', 'response' => (object)array());
				$this->response($response);
           // return false; // already following
        }

                  // $this->db->insert('user_followers', ['follower_id' => $follower_id,'following_id' => $user_id,'follower_mode' => $follower_mode,'following_mode' => $user_mode]);
    	           $this->db->insert('user_followers', ['following_id' => $user_id,'follower_id' => $follower_id]);
    	             $response = array('status' => true, 'message' => 'following successfully', 'response' => (object)array());
				    $this->response($response);
    	        }else if($view_type == 'unfollow'){
    	           // $this->db->delete('user_followers', ['follower_id' => $follower_id, 'following_id' => $user_id,'follower_mode' => $follower_mode,'following_mode' => $user_mode]);
    	            $this->db->delete('user_followers', ['following_id' => $user_id, 'follower_id' => $follower_id]);
    	            $response = array('status' => true, 'message' => 'unfollowing successfully', 'response' => (object)array());
				    $this->response($response);
    	        }else if($view_type == "follow_count"){
    	           $followers_count =  $this->user_model->get_followers_count($user_id,$user_mode);
    	           $following_count =  $this->user_model->get_following_count($user_id,$user_mode);
    	           $post_count =  $this->user_model->get_post_count($user_id,$user_mode);
    	           $response = array('status' => true, 'message' => 'data fetched successfully', 'response' => 
    	           array('followers' => $followers_count,'following' => $following_count,'post' => $post_count));
				    $this->response($response);
    	        }else if($view_type == "followers_list"){
    	           $followers =  $this->user_model->get_followers($user_id,$user_mode);
    	           $response = array('status' => true, 'message' => 'data fetched successfully', 'response' => 
    	           $followers);
				    $this->response($response);
    	        }else if($view_type == "following_list"){
    	           $following =  $this->user_model->get_following($user_id,$user_mode);
    	           $response = array('status' => true, 'message' => 'data fetched successfully', 'response' => $following);
				    $this->response($response);
    	        }else if($view_type == "friends"){
    	                $friends = $this->user_model->get_friends($user_id, $user_mode);
                    $response = array('status' => true, 'message' => 'data fetched successfully', 'response' => $friends);
				    $this->response($response);
    	        }else if($view_type == "search_personal_account_user"){
    	                $friends = $this->user_model->search_personal_users($keyword,$user_id);
                    $response = array('status' => true, 'message' => 'data fetched successfully', 'response' => $friends);
				    $this->response($response);
    	        }else if($view_type == "search_bussiness_account_user"){
    	                $friends = $this->user_model->search_business_users($keyword,$user_id);
                    $response = array('status' => true, 'message' => 'data fetched successfully', 'response' => $friends);
				    $this->response($response);
    	        }else  if($view_type="block"){
    	         if ($user_id == $follower_id) {
        $response = array('status' => false, 'message' => 'cannot block self', 'response' => (object)array());
        $this->response($response);
    }

    // Already blocked?
    $exists = $this->db->where([
        'blocker_id' => $follower_id,
        'blocked_id' => $user_id
    ])->get('user_blocks')->row_array();

    if (!empty($exists)) {
        $response = array('status' => false, 'message' => 'already blocked', 'response' => (object)array());
        $this->response($response);
    }

    // Add block record
    $this->db->insert('user_blocks', [
        'blocker_id' => $follower_id,
        'blocked_id' => $user_id,
       // 'mode' => $follower_mode
    ]);

    // Remove follow relationships if exist
    $this->db->delete('user_followers', ['follower_id' => $follower_id, 'following_id' => $user_id]);
    $this->db->delete('user_followers', ['follower_id' => $user_id, 'following_id' => $follower_id]);

    $response = array('status' => true, 'message' => 'user blocked successfully', 'response' => (object)array());
    $this->response($response);
    	     }else if($view_type == "unblock"){
    	         $this->db->delete('user_blocks', ['blocker_id' => $follower_id, 'blocked_id' => $user_id]);
    $response = array('status' => true, 'message' => 'user unblocked successfully', 'response' => (object)array());
    $this->response($response);
    	     }
			}else{
				$response = array('status' => false, 'message' => 'token not verified', 'response' => (object)array());
				$this->response($response);
			}
	    }else{
	        $response = array('status' => false, 'message' => 'Your account is inactive', 'response' => (object)array());
            $this->response($response);
	    }
	}
}
    
    public function like_comment_share_view_post(){
    	$response = array('status' => false, 'message' => '', 'response' => array());
	$user_input = $this->client_request;
	extract($user_input);
	
	if(empty($user_id) || empty($user_type) || empty($auth_token) || empty($view_type) || empty($content_id)){
	    $response = array('status' => false, 'message' => 'please fill all the required fields', 'response' => (object)array());
        $this->response($response);
	}else{
	    $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
	    if($check_user[0]['status']==1){
    	    if($auth_token==$check_user[0]['auth_token']){
    	        
    	        // Get Content Owner
    $owner_id = $this->user_model->get_owner($content_type, $content_id);
    $sender_name = $user[0]['personal_username'];
    $sender_player_id = $user[0]['player_id'];
    
    
    	        if($view_type=='like'){
    	                     $data = $this->user_model->toggle_like($user_id,$user_type,$content_type,$content_id);

                      
        //     $message = $check_user[0]['personal_username']." liked your ".$content_type;
             
        //     $member_id = $check_user[0]['player_id'];
        //     $this->sendNotification_get($member_id,$title,$message,$user_type);//exit;
         // Save Notification
         $title = "Liked ".$content_type;
         $user_type = "";
               $msg = "$sender_name liked your $content_type.";
               $this->user_model->add_notification($owner_id, $user_id, 'like', $msg, $content_id);
                $this->sendNotification_get($sender_player_id,$title,$msg,$user_type);//exit;

       
                    $response = array('status' => true, 'message' => 'Liked successfully', 'response' => (object)array());
				    $this->response($response);
    	        }else if($view_type == 'comment'){
    	                    $id = $this->user_model->add_comment($user_id, $user_type, $content_type, $content_id, $comment_text);
    	                    $title = "Commented on ".$content_type;
         $user_type = "";
               $msg = "$sender_name Commented on your $content_type.";
               $this->user_model->add_notification($owner_id, $user_id, 'comment', $msg, $content_id);
                $this->sendNotification_get($sender_player_id,$title,$msg,$user_type);//exit;

    	            $response = array('status' => true, 'message' => 'comment added successfully', 'response' => (object)array());
				    $this->response($response);
    	        }else if($view_type == "share"){
    	          $id = $this->user_model->add_share($user_id,$user_type,$content_type,$content_id,$shared_to);
    	           $response = array('status' => true, 'message' => 'share added successfully', 'response' => (object)array());
				    $this->response($response);
    	        }else if($view_type == "view"){
    	          $id = $this->user_model->add_view($user_id,$user_type,$content_type,$content_id);
    	           $response = array('status' => true, 'message' => 'share added successfully', 'response' => (object)array());
				    $this->response($response);
    	        }else if($view_type == "view_comments"){
    	          $id = $this->user_model->get_comments($content_type,$content_id);
    	           $response = array('status' => true, 'message' => 'Data fetched successfully', 'response' => $id);
				    $this->response($response);
    	        }
			}else{
				$response = array('status' => false, 'message' => 'token not verified', 'response' => (object)array());
				$this->response($response);
			}
	    }else{
	        $response = array('status' => false, 'message' => 'Your account is inactive', 'response' => (object)array());
            $this->response($response);
	    }
	}
}
    public function view_social_profile_details_post(){
    	$response = array('status' => false, 'message' => '', 'response' => array());
	$user_input = $this->client_request;
	extract($user_input);
	
	if(empty($user_id) || empty($user_mode) || empty($auth_token) || empty($profile_user_id) || empty($profile_mode) || empty($view_type)){
	    $response = array('status' => false, 'message' => 'please fill all the required fields', 'response' => (object)array());
        $this->response($response);
	}else{
	    $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
	    if($check_user[0]['status']==1){
    	    if($auth_token==$check_user[0]['auth_token']){
    	        if($view_type=='view_social_profile'){
    	         //   $data = $this->Ws_model->get_user_social_profile_details($profile_id,$profile_mode);
    	                    $data = $this->user_model->get_user_profile_data($profile_user_id, $user_id, $profile_mode);
                  
    	            $response = array('status' => true, 'message' => 'data fetched successfully', 'response' => $data);
				    $this->response($response);
    	        }else if($view_type == 'unfollow'){
    	            $this->db->delete('user_followers', ['follower_id' => $follower_id, 'following_id' => $user_id]);
    	            $response = array('status' => true, 'message' => 'unfollowing successfully', 'response' => (object)array());
				    $this->response($response);
    	        }else if($view_type == "follow_count"){
    	           $followers_count =  $this->user_model->get_followers_count($user_id,$user_mode);
    	           $following_count =  $this->user_model->get_following_count($user_id,$user_mode);
    	           $post_count =  $this->user_model->get_post_count($user_id,$user_mode);
    	           $response = array('status' => true, 'message' => 'data fetched successfully', 'response' => 
    	           array('followers' => $followers_count,'following' => $following_count,'post' => $post_count));
				    $this->response($response);
    	        }
			}else{
				$response = array('status' => false, 'message' => 'token not verified', 'response' => (object)array());
				$this->response($response);
			}
	    }else{
	        $response = array('status' => false, 'message' => 'Your account is inactive', 'response' => (object)array());
            $this->response($response);
	    }
	}
}
	public function view_post_reels_stories_post()
	{
	    $user_input = $this->client_request;
	    extract($user_input);
	    
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($view_type)){
            $response = array('status' => false, 'message' => 'View Type Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($page)){
            $response = array('status' => false, 'message' => 'Page Is Empty', 'response' => (object)array());
            $this->response($response);
        }
        // else if(empty($address)){
        //     $response = array('status' => false, 'message' => 'Address Is Empty', 'response' => (object)array());
        //     $this->response($response);
        // }
        else{
             switch($view_type){
        case 'view_posts':
    if (empty($user_input['page']) || empty($user_input['user_id'])) {
        return $this->response([
            'status' => false,
            'message' => 'Please fill all required fields',
            'response' => (object)[]
        ]);
    }
   $user_details = $this->user_model->common_fetch('users',array('id' => $user_id));
    $user_id    = $user_input['user_id'];
    $user_mode  = isset($user_input['user_mode']) ? $user_input['user_mode'] : 'personal'; 
    $page       = isset($user_input['page']) ? (int)$user_input['page'] : 1;
    $limit      = isset($user_input['limit']) ? (int)$user_input['limit'] : 10;
    $offset     = ($page - 1) * $limit;
    $cat_id = $cat_id;
   // $type = !empty($type) ? $user_details['state']:'';
    // Fetch paginated feed data
    $get_main_data = $this->user_model->get_user_feed($user_id, $user_mode,$cat_id,$type, $limit, $offset);
//echo $this->db->last_query();
    if (!$get_main_data) {
        return $this->response([
            'status' => false,
            'message' => 'No data found',
            'response' => (object)[]
        ]);
    }

    // Assign to output
    $final['posts'] = $get_main_data;

    // Total count
    $total_records = $this->user_model->get_user_feed_rows($user_id, $user_mode,$cat_id,$type);
    $total_pages = ceil($total_records / $limit);
    $pages = [];

    for ($t = 1; $t <= $total_pages; $t++) {
        $pages[] = ['page' => $t];
    }

    $final['pagination'] = [
        'total_pages' => $pages,
        'current_page' => $page,
        'limit' => $limit
    ];

    return $this->response([
        'status' => true,
        'message' => 'Data fetched successfully',
        'response' => $final
    ]);
    break;

        case 'view_reels':
    if (empty($user_input['page']) || empty($user_input['user_id'])) {
        return $this->response([
            'status' => false,
            'message' => 'Please fill all required fields',
            'response' => (object)[]
        ]);
    }

    $user_id    = $user_input['user_id'];
    $user_mode  = isset($user_input['user_mode']) ? $user_input['user_mode'] : 'personal';
    $page       = isset($user_input['page']) ? (int)$user_input['page'] : 1;
    $limit      = isset($user_input['limit']) ? (int)$user_input['limit'] : 10;
    $offset     = ($page - 1) * $limit;
    $cat_id = $cat_id;
   // $type = '';
    // Fetch paginated feed data
    $get_main_data = $this->user_model->get_user_reels($user_id, $user_mode,$cat_id,$type, $limit, $offset);

    if (!$get_main_data) {
        return $this->response([
            'status' => false,
            'message' => 'No data found',
            'response' => (object)[]
        ]);
    }

    // Assign to output
    $final['posts'] = $get_main_data;

    // Total count
    $total_records = $this->user_model->get_user_reels_rows($user_id, $user_mode,$cat_id,$type);
    $total_pages = ceil($total_records / $limit);
    $pages = [];

    for ($t = 1; $t <= $total_pages; $t++) {
        $pages[] = ['page' => $t];
    }

    $final['pagination'] = [
        'total_pages' => $pages,
        'current_page' => $page,
        'limit' => $limit
    ];

    return $this->response([
        'status' => true,
        'message' => 'Data fetched successfully',
        'response' => $final
    ]);
    break;
       case 'view_stories':
    if (empty($user_input['page']) || empty($user_input['user_id'])) {
        return $this->response([
            'status' => false,
            'message' => 'Please fill all required fields',
            'response' => (object)[]
        ]);
    }

    $user_id    = $user_input['user_id'];
    $user_mode  = isset($user_input['user_mode']) ? $user_input['user_mode'] : 'personal';
    $page       = isset($user_input['page']) ? (int)$user_input['page'] : 1;
    $limit      = isset($user_input['limit']) ? (int)$user_input['limit'] : 10;
    $offset     = ($page - 1) * $limit;
    $cat_id = $cat_id;
   // $type = '';
    // Fetch paginated feed data
    $get_main_data = $this->user_model->get_user_stories($user_id, $user_mode,$cat_id,$type, $limit, $offset);
    $get_user_story = $this->user_model->get_user_story_only($user_id, $user_mode);
    if (!$get_main_data &&  !$get_user_story ) {
        return $this->response([
            'status' => false,
            'message' => 'No data found',
            'response' => (object)[]
        ]);
    }

    // Assign to output
    $final['posts'] = $get_main_data;
    $final['my_story'] = $get_user_story;

    // Total count
    $total_records = $this->user_model->get_user_stories_rows($user_id, $user_mode,$cat_id,$type);
    $total_pages = ceil($total_records / $limit);
    $pages = [];

    for ($t = 1; $t <= $total_pages; $t++) {
        $pages[] = ['page' => $t];
    }

    $final['pagination'] = [
        'total_pages' => $pages,
        'current_page' => $page,
        'limit' => $limit
    ];

    return $this->response([
        'status' => true,
        'message' => 'Data fetched successfully',
        'response' => $final
    ]);
    break;
   case 'view_posts_user':

    if (empty($user_input['page']) || empty($user_input['view_user_id'])) {
        return $this->response([
            'status' => false,
            'message' => 'view_user_id and page are required',
            'response' => (object)[]
        ]);
    }

    $view_user_id = $user_input['view_user_id']; // whose posts you want
    $page   = (int)$user_input['page'];
    $limit  = isset($user_input['limit']) ? (int)$user_input['limit'] : 10;
    $offset = ($page - 1) * $limit;
    $user_mode = isset($user_input['user_mode']) ? $user_input['user_mode'] : 'personal';

    // Get ONLY this user's posts
    $posts = $this->user_model->get_user_feed($user_id, $user_mode, $cat_id, $type, $limit, $offset,$view_user_id);

    if (!$posts) {
        return $this->response([
            'status' => false,
            'message' => 'No posts found for this user',
            'response' => (object)[]
        ]);
    }

    $total = $this->user_model->get_user_feed_rows($user_id, $user_mode, $cat_id, $type,$view_user_id);
    $total_pages = ceil($total / $limit);

    $pages = [];
    for ($i = 1; $i <= $total_pages; $i++) {
        $pages[] = ['page' => $i];
    }

    return $this->response([
        'status' => true,
        'message' => 'User posts fetched successfully',
        'response' => [
            'posts' => $posts,
            'pagination' => [
                'total_pages' => $pages,
                'current_page' => $page,
                'limit' => $limit
            ]
        ]
    ]);

break;

    case 'view_reels_user':

    if (empty($user_input['page']) || empty($user_input['view_user_id'])) {
        return $this->response([
            'status' => false,
            'message' => 'view_user_id and page are required',
            'response' => (object)[]
        ]);
    }

    $view_user_id = $user_input['view_user_id']; // whose reels you want
    $page   = (int)$user_input['page'];
    $limit  = isset($user_input['limit']) ? (int)$user_input['limit'] : 10;
    $offset = ($page - 1) * $limit;
    $user_mode = isset($user_input['user_mode']) ? $user_input['user_mode'] : 'personal';

    // Get ONLY this user’s reels
    $reels = $this->user_model->get_user_reels($user_id, $user_mode, $cat_id, $type, $limit, $offset,$view_user_id);

    if (!$reels) {
        return $this->response([
            'status' => false,
            'message' => 'No reels found for this user',
            'response' => (object)[]
        ]);
    }

    $total = $this->user_model->get_user_reels_rows($user_id, $user_mode, $cat_id, $type,$view_user_id);
    $total_pages = ceil($total / $limit);

    $pages = [];
    for ($i = 1; $i <= $total_pages; $i++) {
        $pages[] = ['page' => $i];
    }

    return $this->response([
        'status' => true,
        'message' => 'User reels fetched successfully',
        'response' => [
            'posts' => $reels,
            'pagination' => [
                'total_pages' => $pages,
                'current_page' => $page,
                'limit' => $limit
            ]
        ]
    ]);

break;


       
        default:
        // Fallback if no case matches
        return $this->response([
            'status' => false,
            'message' => 'Invalid view_type provided',
            'response' => (object)[]
        ]);
    } 
        }
	    
	    
	}
	public function view_single_post_reel_story_post()
	{
	   $response = array('status' => false, 'message' => '', 'response' => array());
	$user_input = $this->client_request;
	extract($user_input);

	if(empty($user_id) || empty($auth_token) || empty($content_type) || empty($content_id)){
	    $response = array('status' => false, 'message' => 'please fill all the required fields', 'response' => (object)array());
        $this->response($response);
	}else{
	    $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
	    if($check_user[0]['status']==1){
    	    if($auth_token==$check_user[0]['auth_token']){
    	        
    	            $data = $this->user_model->view_single_post_reel_story($user_id,$content_type,$content_id);
    	            $response = array('status' => true, 'message' => 'data fetched successfully', 'response' => $data);
				    $this->response($response);
    	  
			}else{
				$response = array('status' => false, 'message' => 'token not verified', 'response' => (object)array());
				$this->response($response);
			}
	    }else{
	        $response = array('status' => false, 'message' => 'Your account is inactive', 'response' => (object)array());
            $this->response($response);
	    }
	} 
	}
	 public function view_coins_withdraws_post(){
    	$response = array('status' => false, 'message' => '', 'response' => array());
	$user_input = $this->client_request;
	extract($user_input);
	
	if(empty($user_id) || empty($user_type) || empty($auth_token) || empty($view_type)){
	    $response = array('status' => false, 'message' => 'please fill all the required fields', 'response' => (object)array());
        $this->response($response);
	}else{
	    $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
	    if($check_user[0]['status']==1){
    	    if($auth_token==$check_user[0]['auth_token']){
    	        if($view_type=='view_coins'){
    	                     $data = $this->user_model->common_fetch('users',array('id' => $user_id));

                        $final['coins'] = $data[0]['coins'];
                        $final['watching_earned_coins'] = $data[0]['watching_earned_coins'];
                    $response = array('status' => true, 'message' => 'Data Fetched successfully', 'response' => $final);
				    $this->response($response);
    	        }else if($view_type == 'history'){
    	                    $coin_history =$this->user_model->common_fetch('user_coins_withdraw_history',array('id' => $user_id,'coin_type' => 'coin'));
    	                    $watching_earned_coin_history =$this->user_model->common_fetch('user_coins_withdraw_history',array('id' => $user_id,'coin_type' => 'watching_earned_coin'));
                    $final['coin_history'] = $coin_history;
                    $final['watching_earned_coin_history'] = $watching_earned_coin_history;
    	            $response = array('status' => true, 'message' => 'comment added successfully', 'response' => $final);
				    $this->response($response);
    	        }else if($view_type == "withdraw_request"){
    	          $data = array(
    	              'user_id' => $user_id,
    	              'coin_type' => $coin_type,
    	              'type'   => $type,
    	              'description' => $description,
    	              'coins'    => $coins,
    	              'status'  => 'request',
    	              'created_on' => date('Y-m-d H:i:s')
    	              );
    	              $this->user_model->common_insert('user_coins_withdraw_history',$data);
    	           $response = array('status' => true, 'message' => 'share added successfully', 'response' => (object)array());
				    $this->response($response);
    	        }else if($view_type == "view_coins"){
    	          $id = $this->user_model->add_view($user_id,$user_type,$content_type,$content_id);
    	           $response = array('status' => true, 'message' => 'share added successfully', 'response' => (object)array());
				    $this->response($response);
    	        }
			}else{
				$response = array('status' => false, 'message' => 'token not verified', 'response' => (object)array());
				$this->response($response);
			}
	    }else{
	        $response = array('status' => false, 'message' => 'Your account is inactive', 'response' => (object)array());
            $this->response($response);
	    }
	}
}
    public function follow_user_user() {
        if ($follower_id == $following_id) return false; // cannot follow self

        $exists = $this->db->get_where('user_followers', ['follower_id' => $follower_id,'following_id' => $following_id])->row();

        if ($exists) {
            return false; // already following
        }

        $this->db->insert('user_followers', [
            'follower_id' => $follower_id,
            'following_id' => $following_id
        ]);
        return true;
    }
    public function unfollow_user($follower_id, $following_id) {
        return $this->db->delete('user_followers', [
            'follower_id' => $follower_id,
            'following_id' => $following_id
        ]);
    }
public function contact_us_post(){
	$response = array('status' => false, 'message' => '', 'response' => array());
	$user_input = $this->client_request;
	extract($user_input);
	$i=0;
	$j=0;
	$k=0;
	$main = array();
	$final = array();
	$rev = array();
    $sum = 0;
	$count=0;
	if(empty($user_id) || empty($auth_token) || empty($view_type)){
	    $response = array('status' => false, 'message' => 'please fill all the required fields', 'response' => (object)array());
        $this->response($response);
	}else{
	    $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
	    if($check_user[0]['status']==1){
    	    if($auth_token==$check_user[0]['auth_token']){
    	        if($view_type=='view'){
    	            $mobile = $this->user_model->common_fetch('contact_number',array());
    	            $response = array('status' => true, 'message' => 'data fetched successfully', 'response' => ['mobile' => intval($mobile[0]['mobile'])]);
				    $this->response($response);
    	        }else{
    	            if(empty($name) || empty($email) || empty($mobile) || empty($message)){
                	    $response = array('status' => false, 'message' => 'please fill all the required fields', 'response' => (object)array());
                        $this->response($response);
                	}else{
        				$data = array(
        				   'user_id'		=> $user_id,
        				   'name'			=> $name,
        				   'email'			=> $email,
        				   'mobile'			=> $mobile,
        				   'message'		=> $message,
        				   'created_on'		=> date('Y-m-d H:i:s'),
        				);
        				$insert = $this->user_model->common_insert('contact_us',$data);
        				$response = array('status' => true, 'message' => 'data inserted successfully', 'response' => (object)array());
        				$this->response($response);
                	}
    	        }
			}else{
				$response = array('status' => false, 'message' => 'token not verified', 'response' => (object)array());
				$this->response($response);
			}
	    }else{
	        $response = array('status' => false, 'message' => 'Your account is inactive', 'response' => (object)array());
            $this->response($response);
	    }
	}
}
public function content_pages_post() {
    $response = ['status' => false, 'message' => '', 'response' => (object)[]];
    $user_input = $this->client_request;
    extract($user_input);

    if (empty($view_type)) {
        $response = [
            'status' => false,
            'message' => 'Please fill all the required fields',
            'response' => (object)[]
        ];
        return $this->response($response);
    }

    // Define default English table and field
    $table = '';
    $field_key = '';
    $content_label = '';

    if ($view_type === 'about_us') {
        $table = 'about_us';
        $field_key = 'name';
    } elseif ($view_type === 'terms') {
        $table = 'terms';
        $field_key = 'name';
    } elseif ($view_type === 'privacy') {
        $table = 'privacy';
        $field_key = 'name';
    } elseif ($view_type === 'refund') {
        $table = 'refund';
        $field_key = 'name';
    } else {
        return $this->response([
            'status' => false,
            'message' => 'invalid view_type',
            'response' => (object)[]
        ]);
    }

    $data = $this->user_model->common_fetch($table, []);
    if (empty($data)) {
        return $this->response([
            'status' => false,
            'message' => 'no content found',
            'response' => (object)[]
        ]);
    }

    
    $response = [
        'status' => true,
        'message' => 'data fetched successfully',
        'response' => $data
    ];
    return $this->response($response);
}
	 /* block user */
    public function block_user_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($view_type)){
            $response = array('status' => false, 'message' => 'Name Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($follower_id)){
            $response = array('status' => false, 'message' => 'Email ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    	     
    	     if($view_type="block"){
    	         if ($user_id == $follower_id) {
        $response = array('status' => false, 'message' => 'cannot block self', 'response' => (object)array());
        $this->response($response);
    }

    // Already blocked?
    $exists = $this->db->where([
        'blocker_id' => $follower_id,
        'blocked_id' => $user_id
    ])->get('user_blocks')->row_array();

    if (!empty($exists)) {
        $response = array('status' => false, 'message' => 'already blocked', 'response' => (object)array());
        $this->response($response);
    }

    // Add block record
    $this->db->insert('user_blocks', [
        'blocker_id' => $follower_id,
        'blocked_id' => $user_id,
       // 'mode' => $follower_mode
    ]);

    // Remove follow relationships if exist
    $this->db->delete('user_followers', ['follower_id' => $follower_id, 'following_id' => $user_id]);
    $this->db->delete('user_followers', ['follower_id' => $user_id, 'following_id' => $follower_id]);

    $response = array('status' => true, 'message' => 'user blocked successfully', 'response' => (object)array());
    $this->response($response);
    	     }else if($view_type == "unblock"){
    	         $this->db->delete('user_blocks', ['blocker_id' => $follower_id, 'blocked_id' => $user_id]);
    $response = array('status' => true, 'message' => 'user unblocked successfully', 'response' => (object)array());
    $this->response($response);
    	     }
    			  
    			       
    			    
    				
    			
            }
			
		}
	}
	/* block user */
	 /* delete user */
    public function delete_user_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Your Account Deleted or Inactive', 'response' => array());
                $this->response($response);
            }else{
                $data = array(
                    'delete_status' => 1,
                    'updated_on'    => date('Y-m-d H:i:s')
                );
    			       $this->user_model->common_update('users',$data,array('id' => $user_id));
    			        $response = array('status' => true, 'message' => 'User Deleted Successfully', 'response' => array());
    				$this->response($response);
    			    
            }
			
		}
	}
	/* delete user */
	
	 /* un friend user */
    public function unfriend_user_post()
     {
	    $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($friend_id)){
            $response = array('status' => false, 'message' => 'Name Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($auth_token)){
            $response = array('status' => false, 'message' => 'Authentication Token Is Empty', 'response' => array());
            $this->response($response);
        }else{
            $check_user = $this->user_model->common_fetch('users',array('id' => $user_id));
            if($check_user[0]['auth_token'] != $auth_token){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else if($check_user[0]['status'] == 0 || $check_user[0]['delete_status'] == 0){
                $response = array('status' => false, 'message' => 'Authentication Token Expired', 'response' => array());
                $this->response($response);
            }else{
    			
    			       $this->user_model->common_p_delete('friend_requests',array('from_user_id' => $user_id, 'to_user_id' => $friend_id));
    			       $this->user_model->common_p_delete('friend_requests',array('to_user_id' => $user_id, 'from_user_id' => $friend_id));
    			        $response = array('status' => true, 'message' => 'Un Friend Successfully', 'response' => array());
    				$this->response($response);
    			    
            }
			
		}
	}
	/* un friend user */
	
     public function send_mail_get()
     {
           $this->load->config('email');
        $this->load->library('email');
            
            // $config['protocol']    = 'smtp';
            // $config['smtp_host']    = 'ssl://smtp.gmail.com';
            // $config['smtp_port']    = '465';
            // $config['smtp_timeout'] = '7';
            // $config['smtp_user']    = 'sagarnalluri22@gmail.com';
            // $config['smtp_pass']    = '';
            // $config['charset']    = 'utf-8';
            // $config['newline']    = "\r\n";
            // $config['mailtype'] = 'text'; // or html
            // $config['validation'] = TRUE; // bool whether to validate email or not      
            
            // $this->email->initialize($config);
            
            // $this->email->from('sagarnalluri22@gmail.com', 'sender_name');
            // $this->email->to('sagarnalluri22@gmail.com'); 
            // $this->email->subject('Email Test');
            // $this->email->message('Testing the email class.');  
            
            // $this->email->send();
           // $this->email->initialize($config);
            $from = 'sagarnalluri22@gmail.com';
            $to = 'sagarnalluri22@gmail.com';
            $subject = 'test';
            $message = 'test';
             $this->email->set_newline("\r\n");
        $this->email->from($from);
        $this->email->to($to);
        $this->email->subject($subject);
        $this->email->message($message);

        if ($this->email->send()) {
            echo 'Your Email has successfully been sent.';
        } else {
            show_error($this->email->print_debugger());
        }
             
            echo $this->email->print_debugger();
            exit;
            $response = array('status' => true, 'message' => 'Email Sent Successfully', 'response' => $mail);
                   $this->response($response);
            
     }
	 /*user location update */
	public function view_update_ios_version_post()
    {
        $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_id)){
            $response = array('status' => false, 'message' => 'User ID Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($type)){
            $response = array('status' => false, 'message' => 'Latitude Is Empty', 'response' => (object)array());
            $this->response($response);
        }else if(empty($version)){
            $response = array('status' => false, 'message' => 'Longitude Is Empty', 'response' => (object)array());
            $this->response($response);
        }
        // else if(empty($address)){
        //     $response = array('status' => false, 'message' => 'Address Is Empty', 'response' => (object)array());
        //     $this->response($response);
        // }
        else{
            if($type == "view"){
              $user_version =   $this->user_model->common_fetch('users',array('id' => $user_id));
               $app_version =  $this->user_model->common_fetch('ios_app_version',array('id' => 1));
               
               $response = array('status' => true, 'message' => 'Version Details  Fetched Successfully', 'response' => 
               array( 'user_version' => $user_version[0]['app_version'], 
                      'app_version' => $app_version[0]['version'], 
                      'status' => $app_version[0]['status']));
    				$this->response($response);
                 
            }else{
    			$data = array(
    			    'app_version' => $version,
    			    'updated_on' => date('Y-m-d H:i:s')
    			    );
    			    $this->user_model->common_update('users',$data,array('id' => $user_id));
    			//echo $this->db->last_query();exit;
    			   	$response = array('status' => true, 'message' => 'Version Details  Updated Successfully', 'response' => (object)array());
    				$this->response($response);
            }
            
			
		}
    }
	/*user location update */
	
	

}

?>