<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Register extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/userguide3/general/urls.html
	 */
	function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->is_logged_in();
		$this->load->model('mainmodel');
		$this->db->query('SET SESSION sql_mode =
                  REPLACE(REPLACE(REPLACE(
                  @@sql_mode,
                  "ONLY_FULL_GROUP_BY,", ""),
                  ",ONLY_FULL_GROUP_BY", ""),
                  "ONLY_FULL_GROUP_BY", "")');
		date_default_timezone_set("Asia/Kolkata");
	}


	public function index()
	{
		$this->load->view('includes/header');
		$this->load->view('schooldashboard');
		$this->load->view('includes/footer');
	}
	public function is_logged_in()
	{
		$is_logged_in = $this->session->userdata('is_logged_in');
		$role = $this->session->userdata('role');
		if(!isset($is_logged_in) || $is_logged_in != true )
		{
			//|| $role != "superadmin"
			redirect('/', 'refresh');
		}
	}
	
	function is_logged_out()
    {
        $this->session->unset_userdata('is_logged_in');
        redirect('/', 'refresh');
	}
	/*class creation start*/
	function add_class()
	{
	    $data['sessions'] = $this->mainmodel->common_fetch('school_sessions',array('delete_status' => 1, 'status' => 1));
	    $this->load->view('includes/header');
		$this->load->view('add_class',$data);
		$this->load->view('includes/footer');
	}
	
	function all_schools_info()
	{
	    $categories = $this->mainmodel->get_all_details_school($_POST);
        $result_count=$this->mainmodel->get_all_details_school($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	function classes_list()
	{
	    $data['classes'] = $this->mainmodel->common_fetch('class',array('delete_status' => 1, 'school_id' => $this->session->userdata('school_id')));
	    $data['sessions'] = $this->mainmodel->common_fetch('school_sessions',array('delete_status' => 1, 'status' => 1));
	    $data['all_classes'] = $this->mainmodel->get_all_classes_data($this->session->userdata('school_id'));
	    $this->load->view('includes/header');
		$this->load->view('list_classes',$data);
		$this->load->view('includes/footer');
	}
	function update_class_status()
	{
	    $id = $this->input->post('id');
	    $status = $this->input->post('status');
	    if(!empty($id)){
	        if($status == 1)
	    {
	        $status = 0;
	    }else if($status == 0){
	       $status = 1; 
	    }
	    
	       $data = array(
	            'status' => $status,
	            'updated_on' => date('Y-m-d H:i:s')
	            );
	           // print_r($data);
	           // echo $amenity.$id;exit;
	            $update_area = $this->mainmodel->common_update("class",$data,array('id' => $id));
	      // echo      $update_area;exit;
	      $josn_data = array(
	          'status' => true,
	          'message' => "Class status changed successfully"
	          );
	    
	    }else{
	         $josn_data = array(
	          'status' => false,
	          'message' => "Class status Not changed"
	          );
	    }
	    echo json_encode($josn_data);
				exit;
	}
	public function get_class_search_data()
	{
	     // print_r($_POST);exit;
	   // if($this->input->post('search')){
	       // print_r($_POST);exit;
	       $deactivate = '';
	       $deactivate = isset($deactivate) ? $this->input->post('deactivate') : '';
	        $session_id = $this->input->post('session_id');
	        $class_id = $this->input->post('class_id');
	        //$deactivate = $this->input->post('deactivate');
	        
	      // echo $deactivate;exit;
	        
	        $data['all_classes'] = $this->mainmodel->get_search_all_classes_data($this->session->userdata('school_id'),$session_id,$class_id,$deactivate);
	        //$this->load->view('includes/header');
		$this->load->view('ajax_class_details',$data);
		
		//$this->load->view('includes/footer');
	   // }
	}
	function add_class_details()
	{
	    $class_name = $this->input->post('class_name');
	    $school_id = $this->input->post('school_id');
	    $class_section = $this->input->post('class_section');
	    $session = $this->input->post('session');
	   // echo $class_name.$school_id.$class_section.$session;exit;
	    if(!empty($class_name) && !empty($school_id) && !empty($class_section) && !empty($session)){
	        $checkschool  = $this->mainmodel->common_fetch('class',array('class_name' => $class_name, 'school_id' =>$school_id, 
	                                                            'class_section' => $class_section, 'session_id' => $session)); 
	       
	        if(empty($checkschool)){
	            $data = array(
	                'class_name' =>$class_name,
	                'school_id' => $school_id,
	                'class_section' => $class_section,
	                'session_id' => $session,
	                'status' => 1,
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $insert = $this->mainmodel->common_insert('class',$data);
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Class details added successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry,Class name with grade and session already exists."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	    
	}
	function edit_class($id)
	{
	    $url_param = rtrim($id, '=');
        // and later:
        $base_64 = $url_param . str_repeat('=', strlen($url_param) % 4);
        $id = base64_decode($base_64);
	    $data['class'] = $this->mainmodel->common_fetch('class',array('id' => $id));
	    $data['sessions'] = $this->mainmodel->common_fetch('school_sessions',array('delete_status' => 1, 'status' => 1));
	    
	    $this->load->view('includes/header');
		$this->load->view('edit_class',$data);
		$this->load->view('includes/footer');
	}
	function update_class_details()
	{
	    $class_name = $this->input->post('class_name');
	    $school_id = $this->input->post('school_id');
	    $class_id = $this->input->post('class_id');
	    $class_section = $this->input->post('class_section');
	    $session = $this->input->post('session');
	   // echo $class_name.$school_id.$class_section.$session;exit;
	    if(!empty($class_name) && !empty($school_id) && !empty($class_section) && !empty($session)){
	       // $checkschool  = $this->mainmodel->common_fetch('class',array('class_name' => $class_name, 'school_id' =>$school_id, 
	       //                                                     'class_section' => $class_section, 'session_id' => $session)); 
	       
	        if(!empty($class_id)){
	            $data = array(
	                'class_name' =>$class_name,
	                'school_id' => $school_id,
	                'class_section' => $class_section,
	                'session_id' => $session,
	                'status' => 1,
	                'updated_on' => date('Y-m-d H:i:s')
	                );
	           $update = $this->mainmodel->common_update('class',$data,array('id' => $class_id));
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Class details updated successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry,Class name with grade and session already exists."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	}
	
		function transfer_class_list()
	{
	    $data['classes'] = $this->mainmodel->common_fetch('class',array('delete_status' => 1, 'school_id' => $this->session->userdata('school_id')));
	    $data['sessions'] = $this->mainmodel->common_fetch('school_sessions',array('delete_status' => 1, 'status' => 1));
	    $this->load->view('includes/header');
		$this->load->view('list_transfer_class',$data);
		$this->load->view('includes/footer');
	}
	
	function get_transfer_class_details()
	{
	        $from_session_id = $this->input->post('from_session_id');
	        $to_session_id = $this->input->post('to_session_id');
	        $from_class_id = $this->input->post('from_class_id');
	        $to_class_id = $this->input->post('to_class_id');
	        $school_id = $this->session->userdata('school_id');
	        if(!empty($from_session_id) && !empty($to_session_id) && !empty($from_class_id) && !empty($to_class_id) && $school_id){
	            $data['get_data'] = $this->mainmodel->get_all_transfer_class_details($from_session_id,$from_class_id,$school_id);
	            $this->load->view('list_ajax_transfer_class',$data);
	        }else{
	            echo "no data";exit;
	        }
	}
	
	function transfer_students_class()
	{
	   // echo "<pre>";
	   // print_r($_POST);exit;
	        $from_session_id = $this->input->post('from_session_id');
	        $to_session_id = $this->input->post('to_session_id');
	        $from_class_id = $this->input->post('from_class_id');
	        $to_class_id = $this->input->post('to_class_id');
	        $school_id = $this->session->userdata('school_id');
	        $students = $this->input->post('students');
	    if(($from_session_id != $to_session_id) || ($from_class_id != $to_class_id)){
	        
	        foreach($students as $row){
	            $data = array(
	                'session_id' => $to_session_id,
	                'class_id' => $to_class_id,
	                'updated_on' => date('Y-m-d H:i:s')
	                );
	           $update = $this->mainmodel->common_update('students',$data,array('id' => $row));
	            
	        }
	        $json_data = array(
	            'status' => true,
	            'message' => "class transfer done successfully."
	            );
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "both sessions or both classes are not same then only class can transfer."
	            );
	    }
	    echo json_encode($json_data);exit;
	}
	
	public function student_breakup()
	{
	    $data['studentbreakup'] = $this->mainmodel->get_all_students_breakup_details();
	    $this->load->view('includes/header');
		$this->load->view('list_student_breakup',$data);
		$this->load->view('includes/footer');
	}
	
	public function school_attendance()
	{
	   $data['studentbreakup'] = $this->mainmodel->get_all_students_breakup_details();
	    $this->load->view('includes/header');
		$this->load->view('list_school_attendance',$data);
		$this->load->view('includes/footer'); 
	}
	public function session_listing()
	{
	    $data['sessions'] = $this->mainmodel->common_fetch('school_sessions',array('school_id' => $this->session->userdata('school_id'), 'delete_status' => 1));
	    $this->load->view('includes/header');
		$this->load->view('list_sessions',$data);
		$this->load->view('includes/footer'); 
	}
	public function add_session()
	{
        $this->load->view('includes/header');
		$this->load->view('add_session');
		$this->load->view('includes/footer'); 
	}
	public function add_session_details()
	{
	     if ($_SERVER['REQUEST_METHOD'] === 'POST') 
	     {
	        $session_name = $this->input->post('session_name');
	        $start_date = $this->input->post('start_date');
	        $end_date = $this->input->post('end_date');
	        $school_id = $this->session->userdata('school_id');
	        if($this->session->userdata('status') == "yes"){ $status = 1; }else{ $status = 0;}
	        $data = array(
	                'school_id' => $school_id,
	                'session_name' => $session_name,
	                'from_year' => date('Y',strtotime($start_date)),
	                'to_year' => date('Y',strtotime($end_date)),
	                'start_date' => $start_date,
	                'end_date' => $end_date,
	                'status' => $status,
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $insert = $this->mainmodel->common_insert('school_sessions',$data);
	           $json_data = array(
        	            'status' => true,
        	            'message' => "Session details added successfully."
        	            );
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry,Staff details with same employee id and school already exists."
	            );
	    }
	    echo json_encode($json_data);
	}
	

	
	/*class creation end*/
	
	/*staff creation start*/
	function create_staff()
	{
	    $data['classes'] = $this->mainmodel->common_fetch('class',array('delete_status' => 1, 'school_id' => $this->session->userdata('school_id')));
	    $this->load->view('includes/header');
		$this->load->view('create_staff',$data);
		$this->load->view('includes/footer');
	}
	function generate_employee_id()
	{
	    $get_all_emp = $this->mainmodel->common_fetch('staff',array('school_id' => $this->session->userdata('school_id')));
	    $employee_id = 'LPIS-'.count($get_all_emp)+1;
	    $json_data = array(
	        'status' => true,
	        'message' => "Employee ID generated",
	        'employee_id' => $employee_id
	        );
	        echo Json_encode($json_data);
	}
	function add_staff_details()
	{
	   // $class_name = $this->input->post('class_name');
	   // $school_id = $this->input->post('school_id');
	   // $class_section = $this->input->post('class_section');
	   // $session = $this->input->post('session');
	   //echo "<pre>";
	   //print_r($_FILES);
	   //print_r($_POST);exit;
	   // echo $class_name.$school_id.$class_section.$session;exit;
	   $school_id = $this->session->userdata('school_id');
	   $employee_id = $this->input->post('employee_id');
	    if(!empty($employee_id) && !empty($school_id)){
	        $checkschool  = $this->mainmodel->common_fetch('staff',array('employee_id' => $employee_id, 'school_id' =>$school_id)); 
	       
	        if(empty($checkschool)){
	            $employee_class = implode(',',$this->input->post('employee_class'));
	            
	            if(!empty($_FILES['employee_picture']['name'])){
	                $config['upload_path']          = 'assets/images/staff/';
            		$config['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config['max_size']             = 2000;
            		
            		$this->load->library('upload', $config);
            		if($this->upload->do_upload('employee_picture')){
            			$imgdata = $this->upload->data();
            			$iconurl = 'assets/images/staff/'.$imgdata['file_name'];
            		}else{
            			$iconurl = '';
            		}
	            }else{
	                	$iconurl = '';
	            }
	            if($this->input->post('employee_use_designation') == "on"){
	                $use_designation = "yes";
	            }else{ $use_designation = "no"; }
	            $data = array(
	                'employee_id' =>$employee_id,
	                'school_id' => $school_id,
	                'employee_name' => $this->input->post('employee_name'),
	                'employee_email' => $this->input->post('employee_email'),
	                'employee_password' => md5($this->input->post('employee_password')),
	                'employee_dob' => $this->input->post('employee_dob'),
	                'employee_gender' => $this->input->post('employee_gender'),
	                'employee_mobile' => $this->input->post('employee_mobile'),
	                'employee_image' => $iconurl,
	                'employee_designation' => $this->input->post('employee_designation'),
	                'employee_department' => $this->input->post('employee_department'),
	                'employee_use_designation' => $use_designation,
	                'employee_class' => $employee_class,
	                'status' => 1,
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $insert = $this->mainmodel->common_insert('staff',$data);
	           if($insert){
	               include('phpqrcode/qrlib.php');
                   //$uniq = sprintf('%04d',$insert);
                    $uniqueNumber = time() . rand(1000, 9999);
                    $item = $uniqueNumber;
        	              //  $item = 'HEALTH_CARD_'.$uniq;
                            
                            //print_r($item);
                            
                        	$file = "assets/qrcodes/staff/".''.$item.'.png';
                            //other parameters
                            	$ecc = 'H';
                        	$pixel_size = 10;
                        	
                        	QRcode::png($item, $file, $ecc, $pixel_size);
                        	
                        	$data_qrcode = array(
                        	    'qrcode' => $file,
                        	    'qrcode_id' => $uniqueNumber,
                        	    'updated_on' =>date('Y-m-d H:i:s')
                        	    );
                        	    $update = $this->mainmodel->common_update('staff',$data_qrcode,array('id' => $insert));
	           }
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Staff details added successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry,Staff details with same employee id and school already exists."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	    
	}
	
	function staff_list()
	{
	    $data['classes'] = $this->mainmodel->common_fetch('class',array('delete_status' => 1, 'school_id' => $this->session->userdata('school_id')));
	    $data['sessions'] = $this->mainmodel->common_fetch('school_sessions',array('delete_status' => 1, 'status' => 1));
	    $this->load->view('includes/header');
		$this->load->view('list_staff',$data);
		$this->load->view('includes/footer');
	}
	
	function all_staff_info()
	{
	    $categories = $this->mainmodel->get_all_staff_details($_POST);
        $result_count=$this->mainmodel->get_all_staff_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	function update_staff_status()
	{
	    $id = $this->input->post('id');
	    $status = $this->input->post('status');
	    if(!empty($id)){
	        if($status == 1)
	    {
	        $status = 0;
	    }else if($status == 0){
	       $status = 1; 
	    }
	    
	       $data = array(
	            'status' => $status,
	            'updated_on' => date('Y-m-d H:i:s')
	            );
	           // print_r($data);
	           // echo $amenity.$id;exit;
	            $update_area = $this->mainmodel->common_update("staff",$data,array('id' => $id));
	      // echo      $update_area;exit;
	      $josn_data = array(
	          'status' => true,
	          'message' => "Staff status changed successfully"
	          );
	    
	    }else{
	         $josn_data = array(
	          'status' => false,
	          'message' => "Staff status Not changed"
	          );
	    }
	    echo json_encode($josn_data);
				exit;
	}
	
	function edit_staff($id)
	{
	    $url_param = rtrim($id, '=');
        // and later:
        $base_64 = $url_param . str_repeat('=', strlen($url_param) % 4);
        $id = base64_decode($base_64);
	    $data['classes'] = $this->mainmodel->common_fetch('class',array('delete_status' => 1, 'school_id' => $this->session->userdata('school_id')));
	    $data['sessions'] = $this->mainmodel->common_fetch('school_sessions',array('delete_status' => 1, 'status' => 1));
	    $data['staff_data'] = $this->mainmodel->common_fetch('staff',array('id' => $id));
	    $this->load->view('includes/header');
		$this->load->view('edit_staff',$data);
		$this->load->view('includes/footer');
	}
	function update_staff_details()
	{
	   // $class_name = $this->input->post('class_name');
	   // $school_id = $this->input->post('school_id');
	   // $class_section = $this->input->post('class_section');
	   // $session = $this->input->post('session');
	   //echo "<pre>";
	   //print_r($_FILES);
	   //print_r($_POST);exit;
	   // echo $class_name.$school_id.$class_section.$session;exit;
	   $school_id = $this->session->userdata('school_id');
	   $staff_id = $this->input->post('staff_id');
	   $employee_id = $this->input->post('employee_id');
	    if(!empty($employee_id) && !empty($school_id)){
	     //   $checkschool  = $this->mainmodel->common_fetch('staff',array('employee_id' => $employee_id, 'school_id' =>$school_id)); 
	        $employee_class = implode(',',$this->input->post('employee_class'));
	      //  echo $employee_class;exit;
	        if(!empty($staff_id)){
	            if(!empty($_FILES['employee_picture']['name'])){
	                $config['upload_path']          = 'assets/images/staff/';
            		$config['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config['max_size']             = 2000;
            		
            		$this->load->library('upload', $config);
            		if($this->upload->do_upload('employee_picture')){
            			$imgdata = $this->upload->data();
            			$iconurl = 'assets/images/staff/'.$imgdata['file_name'];
            		}else{
            			$iconurl = '';
            		}
	            }else{
	                	$iconurl = '';
	            }
	            if($this->input->post('employee_use_designation') == "on"){
	                $use_designation = "yes";
	            }else{ $use_designation = "no"; }
	            
	             
	           
	            $data = array(
	                'employee_id' =>$employee_id,
	                'school_id' => $school_id,
	                'employee_name' => $this->input->post('employee_name'),
	                'employee_email' => $this->input->post('employee_email'),
	                'employee_password' => md5($this->input->post('employee_password')),
	                'employee_dob' => $this->input->post('employee_dob'),
	                'employee_gender' => $this->input->post('employee_gender'),
	                'employee_mobile' => $this->input->post('employee_mobile'),
	                'employee_image' => $iconurl,
	                'employee_designation' => $this->input->post('employee_designation'),
	                'employee_department' => $this->input->post('employee_department'),
	                'employee_use_designation' => $use_designation,
	                'employee_class' => $employee_class,
	                'status' => 1,
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $update = $this->mainmodel->common_update('staff',$data,array('id' => $staff_id));
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Staff details added successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry,Staff details with same employee id and school already exists."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	    
	}
	
	function staff_rights($id)
	{
	    $url_param = rtrim($id, '=');
        // and later:
        $base_64 = $url_param . str_repeat('=', strlen($url_param) % 4);
        $id = base64_decode($base_64);
	    $data['staff_data'] = $this->mainmodel->common_fetch('staff',array('id' => $id));
	    $data['staff_rights'] = $this->mainmodel->common_fetch('staff_rights',array('staff_id' => $id));
	    $this->load->view('includes/header');
		$this->load->view('staff_rights',$data);
		$this->load->view('includes/footer');
	}
	function update_staff_rights_details()
	{
	   // $class_name = $this->input->post('class_name');
	   // $school_id = $this->input->post('school_id');
	   // $class_section = $this->input->post('class_section');
	   // $session = $this->input->post('session');
	  // echo "<pre>";
	  // print_r($_POST);exit;
	   // echo $class_name.$school_id.$class_section.$session;exit;
	   $school_id = $this->session->userdata('school_id');
	   $staff_id = $this->input->post('staff_id');
	   $employee_id = $this->input->post('employee_id');
	    if($_SERVER['REQUEST_METHOD'] === 'POST'){
	    
	       
	        if(!empty($staff_id)){
	            
	            if($this->input->post('school_page') == "on"){ $school_page = "yes";  }else{ $school_page = "no"; }
	            if($this->input->post('create_inquiry_registration') == "on"){ $create_inquiry_registration = "yes";  }else{ $create_inquiry_registration = "no"; }
	            if($this->input->post('edit_inquiry_registration') == "on"){ $edit_inquiry_registration = "yes";  }else{ $edit_inquiry_registration = "no"; }
	            if($this->input->post('visitor_management') == "on"){ $visitor_management = "yes";  }else{ $visitor_management = "no"; }
	            if($this->input->post('gatepass_reports') == "on"){ $gatepass_reports = "yes";  }else{ $gatepass_reports = "no"; }
	            if($this->input->post('manage_fees') == "on"){ $manage_fees = "yes";  }else{ $manage_fees = "no"; }
	            if($this->input->post('collect_fees') == "on"){ $collect_fees = "yes";  }else{ $collect_fees = "no"; }
	            if($this->input->post('delete_transactions') == "on"){ $delete_transactions = "yes";  }else{ $delete_transactions = "no"; }
	            if($this->input->post('send_communications') == "on"){ $send_communications = "yes";  }else{ $send_communications = "no"; }
	            if($this->input->post('create_albums') == "on"){ $create_albums = "yes";  }else{ $create_albums = "no"; }
	            if($this->input->post('manage_exam') == "on"){ $manage_exam = "yes";  }else{ $manage_exam = "no"; }
	            if($this->input->post('view_reports') == "on"){ $view_reports = "yes";  }else{ $view_reports = "no"; }
	            if($this->input->post('add_edit_cab_details') == "on"){ $add_edit_cab_details = "yes";  }else{ $add_edit_cab_details = "no"; }
	            if($this->input->post('set_as_management') == "on"){ $set_as_management = "yes";  }else{ $set_as_management = "no"; }
	            if($this->input->post('set_as_admin') == "on"){ $set_as_admin = "yes";  }else{ $set_as_admin = "no"; }
	            if($this->input->post('add_edit_staff_details') == "on"){ $add_edit_staff_details = "yes";  }else{ $add_edit_staff_details = "no"; }
	            if($this->input->post('timetable') == "on"){ $timetable = "yes";  }else{ $timetable = "no"; }
	            if($this->input->post('expense') == "on"){ $expense = "yes";  }else{ $expense = "no"; }
	            if($this->input->post('library') == "on"){ $library = "yes";  }else{ $library = "no"; }
	            if($this->input->post('add_edit_student_details') == "on"){ $add_edit_student_details = "yes";  }else{ $add_edit_student_details = "no"; }
	            if($this->input->post('view_students') == "on"){ $view_students = "yes";  }else{ $view_students = "no"; }
	            
	             
	           
	            $data = array(
	                'staff_id' =>$staff_id,
	                'school_id' => $school_id,
	                'school_page' => $school_page,
	                'create_inquiry_registration' => $create_inquiry_registration,
	                'edit_inquiry_registration' => $edit_inquiry_registration,
	                'visitor_management' => $visitor_management,
	                'gatepass_reports' => $gatepass_reports,
	                'manage_fees' => $manage_fees,
	                'collect_fees' => $collect_fees,
	                'delete_transactions' => $delete_transactions,
	                'send_communications' => $send_communications,
	                'create_albums' => $create_albums,
	                'manage_exam' => $manage_exam,
	                'view_reports' => $view_reports,
	                'add_edit_cab_details' => $add_edit_cab_details,
	                'set_as_management' => $set_as_management,
	                'set_as_admin' => $set_as_admin,
	                'add_edit_staff_details' => $add_edit_staff_details,
	                'timetable' => $timetable,
	                'expense' => $expense,
	                'library' => $library,
	                'add_edit_student_details' => $add_edit_student_details,
	                'view_students' => $view_students,
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $check  = $this->mainmodel->common_fetch('staff_rights',array('staff_id' => $staff_id, 'school_id' =>$school_id)); 
	           if(empty($check)){
	               $insert = $this->mainmodel->common_insert('staff_rights',$data);
	           }else{
	               $update = $this->mainmodel->common_update('staff_rights',$data,array('staff_id' => $staff_id));
	           }
	           
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Staff Rights updated successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Invalid staff details."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	    
	}
	
	/*staff creation end*/
	
		/*inquiry creation start*/
	function add_inquiry()
	{
	    $data['classes'] = $this->mainmodel->common_fetch('class',array('delete_status' => 1, 'school_id' => $this->session->userdata('school_id')));
	    $data['sessions'] = $this->mainmodel->common_fetch('school_sessions',array('delete_status' => 1, 'status' => 1));
	    $this->load->view('includes/header');
		$this->load->view('add_inquiry',$data);
		$this->load->view('includes/footer');
	}
	function add_inquiry_details()
	{
	  //  echo "<pre>";
	  //  print_r($_POST);exit;
	   
	   $school_id = $this->session->userdata('school_id');
	   $child_name = $this->input->post('child_name');
	   $session_id = $this->input->post('session_id');
	   $class_id = $this->input->post('class_id');
	    if(!empty($school_id)){
	        $checkschool  = $this->mainmodel->common_fetch('student_inquiry',array('school_id' => $school_id, 'child_name' =>$child_name,
	                                   'session_id' => $session_id, 'class_id' =>$class_id   )); 
	       
	        if(empty($checkschool)){
	           // if(!empty($_FILES['employee_picture']['name'])){
	           //     $config['upload_path']          = 'assets/images/staff/';
            // 		$config['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            // 		$config['max_size']             = 2000;
            		
            // 		$this->load->library('upload', $config);
            // 		if($this->upload->do_upload('employee_picture')){
            // 			$imgdata = $this->upload->data();
            // 			$iconurl = 'assets/images/staff/'.$imgdata['file_name'];
            // 		}else{
            // 			$iconurl = '';
            // 		}
	           // }else{
	           //     	$iconurl = '';
	           // }
	            if($this->input->post('employee_use_designation') == "on"){
	                $use_designation = "yes";
	            }else{ $use_designation = "no"; }
	            $data = array(
	                'school_id' => $school_id,
	                'child_name' => $this->input->post('child_name'),
	                'session_id' => $this->input->post('session_id'),
	                'class_id' => $this->input->post('class_id'),
	                'child_dob' => $this->input->post('child_dob'),
	                'child_gender' => $this->input->post('child_gender'),
	                'father_name' => $this->input->post('father_name'),
	                'father_mobile' => $this->input->post('father_mobile'),
	                'father_email' => $this->input->post('father_email'),
	                'mother_name' => $this->input->post('mother_name'),
	                'mother_mobile' => $this->input->post('mother_mobile'),
	                'mother_email' => $this->input->post('mother_email'),
	                'child_address' => $this->input->post('child_address'),
	                'child_city' => $this->input->post('child_city'),
	                'pinode' => $this->input->post('pinode'),
	                'father_occupation' => $this->input->post('father_occupation'),
	                'father_designation' => $this->input->post('father_designation'),
	                'father_ofice_address' => $this->input->post('father_ofice_address'),
	                'mother_occupation' => $this->input->post('mother_occupation'),
	                'mother_designation' => $this->input->post('mother_designation'),
	                'mother_office_address' => $this->input->post('mother_office_address'),
	                'file_no' => $this->input->post('file_no'),
	                'inquiry_date' => $this->input->post('inquiry_date'),
	                'next_followup_date' => $this->input->post('next_followup_date'),
	                'source' => $this->input->post('source'),
	                'inquiry_status' => $this->input->post('inquiry_status'),
	             //   'application_fee' => $this->input->post('application_fee'),
	                'remarks' => $this->input->post('remarks'),
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $insert = $this->mainmodel->common_insert('student_inquiry',$data);
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Student inquiry details added successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry,same child name with this session and class  already exists."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	}
	function edit_inquiry($id)
	{
	    $url_param = rtrim($id, '=');
        // and later:
        $base_64 = $url_param . str_repeat('=', strlen($url_param) % 4);
        $id = base64_decode($base_64);
	    $data['classes'] = $this->mainmodel->common_fetch('class',array('delete_status' => 1, 'school_id' => $this->session->userdata('school_id')));
	    $data['sessions'] = $this->mainmodel->common_fetch('school_sessions',array('delete_status' => 1, 'status' => 1));
	    $data['inquiry_data'] = $this->mainmodel->common_fetch('student_inquiry',array('id' => $id));
	    $this->load->view('includes/header');
		$this->load->view('edit_inquiry',$data);
		$this->load->view('includes/footer');
	}
	function update_inquiry_details()
		{
	  //  echo "<pre>";
	  //  print_r($_POST);exit;
	   $inquiry_id = $this->session->userdata('inquiry_id');
	   $school_id = $this->session->userdata('school_id');
	   $child_name = $this->input->post('child_name');
	   $session_id = $this->input->post('session_id');
	   $class_id = $this->input->post('class_id');
	    if(!empty($school_id) && !empty($inquiry_id)){
	       // $checkschool  = $this->mainmodel->common_fetch('student_inquiry',array('school_id' => $school_id, 'child_name' =>$child_name,
	        //                           'session_id' => $session_id, 'class_id' =>$class_id   )); 
	       
	       // if(empty($checkschool))
	       // {
	         
	            $data = array(
	                'school_id' => $school_id,
	                'child_name' => $this->input->post('child_name'),
	                'session_id' => $this->input->post('session_id'),
	                'class_id' => $this->input->post('class_id'),
	                'child_dob' => $this->input->post('child_dob'),
	                'child_gender' => $this->input->post('child_gender'),
	                'father_name' => $this->input->post('father_name'),
	                'father_mobile' => $this->input->post('father_mobile'),
	                'father_email' => $this->input->post('father_email'),
	                'mother_name' => $this->input->post('mother_name'),
	                'mother_mobile' => $this->input->post('mother_mobile'),
	                'mother_email' => $this->input->post('mother_email'),
	                'child_address' => $this->input->post('child_address'),
	                'child_city' => $this->input->post('child_city'),
	                'pinode' => $this->input->post('pinode'),
	                'father_occupation' => $this->input->post('father_occupation'),
	                'father_designation' => $this->input->post('father_designation'),
	                'father_ofice_address' => $this->input->post('father_ofice_address'),
	                'mother_occupation' => $this->input->post('mother_occupation'),
	                'mother_designation' => $this->input->post('mother_designation'),
	                'mother_office_address' => $this->input->post('mother_office_address'),
	                'file_no' => $this->input->post('file_no'),
	                'inquiry_date' => $this->input->post('inquiry_date'),
	                'next_followup_date' => $this->input->post('next_followup_date'),
	                'source' => $this->input->post('source'),
	                'inquiry_status' => $this->input->post('inquiry_status'),
	             //   'application_fee' => $this->input->post('application_fee'),
	                'remarks' => $this->input->post('remarks'),
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $insert = $this->mainmodel->common_update('student_inquiry',$data,array('id' => $inquiry_id));
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Student inquiry details Updated successfully."
        	            );
	                   
	          
	            
	       // }else{
	       //      $json_data = array(
	       //     'status' => false,
	       //     'message' => "Duplicate entry,same child name with this session and class  already exists."
	       //     );
	       // }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	}
	
	function inquiry_list()
	{
	    $data['classes'] = $this->mainmodel->common_fetch('class',array('delete_status' => 1, 'school_id' => $this->session->userdata('school_id')));
	    $data['sessions'] = $this->mainmodel->common_fetch('school_sessions',array('delete_status' => 1, 'status' => 1));
	    $this->load->view('includes/header');
		$this->load->view('list_inquiry',$data);
		$this->load->view('includes/footer');
	}
	
	function all_inquiry_info()
	{
	    $categories = $this->mainmodel->get_all_inquiry_details($_POST);
        $result_count=$this->mainmodel->get_all_inquiry_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	function update_student_inquiry_status() 
	{
	    if($this->input->post('id')){
	        $get_data = $this->mainmodel->common_fetch('student_inquiry',array('id' => $this->input->post('id')));
	        $json_data = array(
	            'status' => true,
	            'details' => $get_data
	            );
	            echo json_encode($json_data);exit;
	        
	    }
	}
	
	function update_inquiry_next_details()
	{
	    echo "<pre>";
	    print_r($_POST);exit;
	}
	
	function convert_inquiry_to_registration($id)
	{
	    
	    $url_param = rtrim($id, '=');
        // and later:
        $base_64 = $url_param . str_repeat('=', strlen($url_param) % 4);
        $id = base64_decode($base_64);
       // echo $id;exit;
        
	    if(!empty($id)){
	        $data['get_inquiry_data'] = $this->mainmodel->common_fetch('student_inquiry',array('id' => $id , 'inquiry_status !=' => "registered"));
	        if(!empty($data['get_inquiry_data'])){
        	    $data['classes'] = $this->mainmodel->common_fetch('class',array('delete_status' => 1, 'school_id' => $this->session->userdata('school_id')));
        	    $data['sessions'] = $this->mainmodel->common_fetch('school_sessions',array('delete_status' => 1, 'status' => 1));
        	    $this->load->view('includes/header');
        		$this->load->view('inquiry_to_registration',$data);
        		$this->load->view('includes/footer');
	        }else{
	            echo "no data";
	        }
	    }
	}
	
	function add_registration_from_inquiry_details()
	{
	  //  echo "<pre>";
	  //  print_r($_POST);exit;
	    $this->load->library('upload');
	    $inquiry_id = $this->session->userdata('inquiry_id');
	    
	   $school_id = $this->session->userdata('school_id');
	   $child_name = $this->input->post('child_name');
	   $session_id = $this->input->post('session_id');
	   $class_id = $this->input->post('class_id');
	    if(!empty($school_id)){
	        $checkschool  = $this->mainmodel->common_fetch('student_registration',array('school_id' => $school_id, 'child_name' =>$child_name,
	                                   'session_id' => $session_id, 'class_id' =>$class_id   )); 
	       
	        if(empty($checkschool)){
	          /*aadharcard upload*/ 
	            if(!empty($_FILES['aardhar_card']['name'])){
	                $config['upload_path']          = 'assets/images/registration/aadhar/';
            		$config['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config['max_size']             = 2000;
            		$this->upload->initialize($config);
            		$this->load->library('upload', $config);
            		if($this->upload->do_upload('aardhar_card')){
            			$imgdata = $this->upload->data();
            			$aardhar_card = 'assets/images/registration/aadhar/'.$imgdata['file_name'];
            		}else{
            			$aardhar_card = '';
            		}
	            }else{
	                	$aardhar_card = '';
	            }
	             /*birth certificate upload*/ 
	             if(!empty($_FILES['birth_certificate']['name'])){
	                $config1['upload_path']          = 'assets/images/registration/birthcertificate/';
            		$config1['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config1['max_size']             = 2000;
            			$this->upload->initialize($config1);
            		$this->load->library('upload', $config1);
            		if($this->upload->do_upload('birth_certificate')){
            			$imgdata1 = $this->upload->data();
            			$birth_certificate = 'assets/images/registration/birthcertificate/'.$imgdata1['file_name'];
            		}else{
            			$birth_certificate = '';
            		}
	            }else{
	                	$birth_certificate = '';
	            }
	            /*school leaving certificate upload*/ 
	             if(!empty($_FILES['schoolleaving_certificate']['name'])){
	                $config2['upload_path']          = 'assets/images/registration/schoolleaving_certificate/';
            		$config2['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config2['max_size']             = 2000;
            		$this->upload->initialize($config2);
            		$this->load->library('upload', $config2);
            		if($this->upload->do_upload('schoolleaving_certificate')){
            			$imgdata2 = $this->upload->data();
            			$schoolleaving_certificate = 'assets/images/registration/schoolleaving_certificate/'.$imgdata2['file_name'];
            		}else{
            			$schoolleaving_certificate = '';
            		}
	            }else{
	                	$schoolleaving_certificate = '';
	            }
	       
	            /*guardian image upload*/ 
	             if(!empty($_FILES['lastyear_marksheet']['name'])){
	                $config3['upload_path']          = 'assets/images/registration/last_year_marksheet/';
            		$config3['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config3['max_size']             = 2000;
            		$this->upload->initialize($config3);
            		$this->load->library('upload', $config3);
            		if($this->upload->do_upload('lastyear_marksheet')){
            			$imgdata3 = $this->upload->data();
            			$lastyear_marksheet = 'assets/images/registration/last_year_marksheet/'.$imgdata3['file_name'];
            		}else{
            			$lastyear_marksheet = '';
            		}
	            }else{
	                	$lastyear_marksheet = '';
	            }
	           
	            $data = array(
	                'school_id' => $school_id,
	                'child_name' => $this->input->post('child_name'),
	                'session_id' => $this->input->post('session_id'),
	                'class_id' => $this->input->post('class_id'),
	                'child_dob' => $this->input->post('child_dob'),
	                'child_gender' => $this->input->post('child_gender'),
	                'student_aadhar' => $this->input->post('student_aadhar'),
	                'student_nationality' => $this->input->post('student_nationality'),
	                'father_name' => $this->input->post('father_name'),
	                'father_mobile' => $this->input->post('father_mobile'),
	                'father_email' => $this->input->post('father_email'),
	                'mother_name' => $this->input->post('mother_name'),
	                'mother_mobile' => $this->input->post('mother_mobile'),
	                'mother_email' => $this->input->post('mother_email'),
	                'child_address' => $this->input->post('child_address'),
	                'child_city' => $this->input->post('child_city'),
	                'pinode' => $this->input->post('pinode'),
	                'father_occupation' => $this->input->post('father_occupation'),
	                'father_designation' => $this->input->post('father_designation'),
	                'father_ofice_address' => $this->input->post('father_ofice_address'),
	                'mother_occupation' => $this->input->post('mother_occupation'),
	                'mother_designation' => $this->input->post('mother_designation'),
	                'mother_office_address' => $this->input->post('mother_office_address'),
	                'previous_school' => $this->input->post('previous_school'),
	                'previous_class' => $this->input->post('previous_class'),
	                'reason_for_leaving' => $this->input->post('reason_for_leaving'),
	                'aardhar_card' => $aardhar_card,
	                'birth_certificate' => $birth_certificate,
	                'schoolleaving_certificate' => $schoolleaving_certificate,
	                'lastyear_marksheet' => $lastyear_marksheet,
	                'file_no' => $this->input->post('file_no'),
	                'registration_date' => $this->input->post('registration_date'),
	                'registration_status' => $this->input->post('registration_status'),
	                'application_fee' => $this->input->post('application_fee'),
	                'remarks' => $this->input->post('remarks'),
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $insert = $this->mainmodel->common_insert('student_registration',$data);
	           
	           if(!empty($inquiry_id)){
	        $datai = array(
	            'inquiry_status' => "Registered",
	            'updated_on' => date('Y-m-d H:i:s')
	            );
	            $update = $this->mainmodel->common_update('student_inquiry',$data1,array('id' => $inquiry_id));
	    }
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Student Registration details added successfully."
        	            );
        	            
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry,same child name with this session and class  already exists."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	}
	
		/*inquiry creation end*/
		
	/*inquiry creation start*/
	function add_registration()
	{
	    $data['classes'] = $this->mainmodel->common_fetch('class',array('delete_status' => 1, 'school_id' => $this->session->userdata('school_id')));
	    $data['sessions'] = $this->mainmodel->common_fetch('school_sessions',array('delete_status' => 1, 'status' => 1));
	    $this->load->view('includes/header');
		$this->load->view('add_registration',$data);
		$this->load->view('includes/footer');
	}
	function add_registration_details()
	{
	  //  echo "<pre>";
	  //  print_r($_POST);exit;
	    $this->load->library('upload');
	   $school_id = $this->session->userdata('school_id');
	   $child_name = $this->input->post('child_name');
	   $session_id = $this->input->post('session_id');
	   $class_id = $this->input->post('class_id');
	    if(!empty($school_id)){
	        $checkschool  = $this->mainmodel->common_fetch('student_registration',array('school_id' => $school_id, 'child_name' =>$child_name,
	                                   'session_id' => $session_id, 'class_id' =>$class_id   )); 
	       
	        if(empty($checkschool)){
	          /*aadharcard upload*/ 
	            if(!empty($_FILES['aardhar_card']['name'])){
	                $config['upload_path']          = 'assets/images/registration/aadhar/';
            		$config['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config['max_size']             = 2000;
            		$this->upload->initialize($config);
            		$this->load->library('upload', $config);
            		if($this->upload->do_upload('aardhar_card')){
            			$imgdata = $this->upload->data();
            			$aardhar_card = 'assets/images/registration/aadhar/'.$imgdata['file_name'];
            		}else{
            			$aardhar_card = '';
            		}
	            }else{
	                	$aardhar_card = '';
	            }
	             /*birth certificate upload*/ 
	             if(!empty($_FILES['birth_certificate']['name'])){
	                $config1['upload_path']          = 'assets/images/registration/birthcertificate/';
            		$config1['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config1['max_size']             = 2000;
            			$this->upload->initialize($config1);
            		$this->load->library('upload', $config1);
            		if($this->upload->do_upload('birth_certificate')){
            			$imgdata1 = $this->upload->data();
            			$birth_certificate = 'assets/images/registration/birthcertificate/'.$imgdata1['file_name'];
            		}else{
            			$birth_certificate = '';
            		}
	            }else{
	                	$birth_certificate = '';
	            }
	            /*school leaving certificate upload*/ 
	             if(!empty($_FILES['schoolleaving_certificate']['name'])){
	                $config2['upload_path']          = 'assets/images/registration/schoolleaving_certificate/';
            		$config2['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config2['max_size']             = 2000;
            		$this->upload->initialize($config2);
            		$this->load->library('upload', $config2);
            		if($this->upload->do_upload('schoolleaving_certificate')){
            			$imgdata2 = $this->upload->data();
            			$schoolleaving_certificate = 'assets/images/registration/schoolleaving_certificate/'.$imgdata2['file_name'];
            		}else{
            			$schoolleaving_certificate = '';
            		}
	            }else{
	                	$schoolleaving_certificate = '';
	            }
	       
	            /*guardian image upload*/ 
	             if(!empty($_FILES['lastyear_marksheet']['name'])){
	                $config3['upload_path']          = 'assets/images/registration/last_year_marksheet/';
            		$config3['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config3['max_size']             = 2000;
            		$this->upload->initialize($config3);
            		$this->load->library('upload', $config3);
            		if($this->upload->do_upload('lastyear_marksheet')){
            			$imgdata3 = $this->upload->data();
            			$lastyear_marksheet = 'assets/images/registration/last_year_marksheet/'.$imgdata3['file_name'];
            		}else{
            			$lastyear_marksheet = '';
            		}
	            }else{
	                	$lastyear_marksheet = '';
	            }
	           
	            $data = array(
	                'school_id' => $school_id,
	                'child_name' => $this->input->post('child_name'),
	                'session_id' => $this->input->post('session_id'),
	                'class_id' => $this->input->post('class_id'),
	                'child_dob' => $this->input->post('child_dob'),
	                'child_gender' => $this->input->post('child_gender'),
	                'student_aadhar' => $this->input->post('student_aadhar'),
	                'student_nationality' => $this->input->post('student_nationality'),
	                'father_name' => $this->input->post('father_name'),
	                'father_mobile' => $this->input->post('father_mobile'),
	                'father_email' => $this->input->post('father_email'),
	                'mother_name' => $this->input->post('mother_name'),
	                'mother_mobile' => $this->input->post('mother_mobile'),
	                'mother_email' => $this->input->post('mother_email'),
	                'child_address' => $this->input->post('child_address'),
	                'child_city' => $this->input->post('child_city'),
	                'pinode' => $this->input->post('pinode'),
	                'father_occupation' => $this->input->post('father_occupation'),
	                'father_designation' => $this->input->post('father_designation'),
	                'father_ofice_address' => $this->input->post('father_ofice_address'),
	                'mother_occupation' => $this->input->post('mother_occupation'),
	                'mother_designation' => $this->input->post('mother_designation'),
	                'mother_office_address' => $this->input->post('mother_office_address'),
	                'previous_school' => $this->input->post('previous_school'),
	                'previous_class' => $this->input->post('previous_class'),
	                'reason_for_leaving' => $this->input->post('reason_for_leaving'),
	                'aardhar_card' => $aardhar_card,
	                'birth_certificate' => $birth_certificate,
	                'schoolleaving_certificate' => $schoolleaving_certificate,
	                'lastyear_marksheet' => $lastyear_marksheet,
	                'file_no' => $this->input->post('file_no'),
	                'registration_date' => $this->input->post('registration_date'),
	                'registration_status' => $this->input->post('registration_status'),
	                'application_fee' => $this->input->post('application_fee'),
	                'remarks' => $this->input->post('remarks'),
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $insert = $this->mainmodel->common_insert('student_registration',$data);
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Student Registration details added successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry,same child name with this session and class  already exists."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	}
	
	function registration_list()
	{
	    $data['classes'] = $this->mainmodel->common_fetch('class',array('delete_status' => 1, 'school_id' => $this->session->userdata('school_id')));
	    $data['sessions'] = $this->mainmodel->common_fetch('school_sessions',array('delete_status' => 1, 'status' => 1));
	    $this->load->view('includes/header');
		$this->load->view('list_registration',$data);
		$this->load->view('includes/footer');
	}
	
	function all_registrations_info()
	{
	   
	    $categories = $this->mainmodel->get_all_registration_details($_POST);
        $result_count=$this->mainmodel->get_all_registration_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	
		/*registration creation end*/
		
		/*student creation start*/
		function students_list()
	{
	    $data['classes'] = $this->mainmodel->common_fetch('class',array('delete_status' => 1, 'school_id' => $this->session->userdata('school_id')));
	    $data['sessions'] = $this->mainmodel->common_fetch('school_sessions',array('delete_status' => 1, 'status' => 1));
	    $this->load->view('includes/header');
		$this->load->view('list_students',$data);
		$this->load->view('includes/footer');
	}
	
	function all_students_info()
	{
	    $categories = $this->mainmodel->get_all_students_details($_POST);
        $result_count=$this->mainmodel->get_all_students_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	
	public function update_student_status()
	{
	     $id = $this->input->post('id');
	    $status = $this->input->post('status');
	    if(!empty($id)){
	        if($status == 1)
	    {
	        $status = 0;
	    }else if($status == 0){
	       $status = 1; 
	    }
	    
	       $data = array(
	            'status' => $status,
	            'updated_on' => date('Y-m-d H:i:s')
	            );
	           // print_r($data);
	           // echo $amenity.$id;exit;
	            $update_area = $this->mainmodel->common_update("students",$data,array('id' => $id));
	      // echo      $update_area;exit;
	      $josn_data = array(
	          'status' => true,
	          'message' => "Student status changed successfully"
	          );
	    
	    }else{
	         $josn_data = array(
	          'status' => false,
	          'message' => "Class status Not changed"
	          );
	    }
	    echo json_encode($josn_data);
				exit;
	}
	
	
		public function student_add()
		{
		    $data['classes'] = $this->mainmodel->common_fetch('class',array('delete_status' => 1, 'school_id' => $this->session->userdata('school_id')));
	    $data['sessions'] = $this->mainmodel->common_fetch('school_sessions',array('delete_status' => 1, 'status' => 1));
		    $this->load->view('includes/header');
		    $this->load->view('add_student',$data);
	    	$this->load->view('includes/footer');
		}
		
	function generate_admission_id()
	{
	    $get_all_emp = $this->mainmodel->common_fetch('students',array('school_id' => $this->session->userdata('school_id')));
	    $admission_id = 'LPIS-A'.count($get_all_emp)+1;
	    $json_data = array(
	        'status' => true,
	        'message' => "Admission ID generated",
	        'admission_id' => $admission_id
	        );
	        echo Json_encode($json_data);
	}
	public function get_student_qrcode()
	{
	    if ($_SERVER['REQUEST_METHOD'] === 'POST') 
	    {
	        $student_id = $this->input->post('id');
	    $get_all_emp = $this->mainmodel->common_fetch('students',array('id' => $student_id));
	    $json_data = array(
	        'status' => true,
	        'message' => "Admission ID generated",
	        'student_name' => $get_all_emp[0]->student_name,
	        'admission_id' => $get_all_emp[0]->admission_id,
	        'qrcode' => base_url().$get_all_emp[0]->qrcode,
	        );
	    }else{
	        $json_data = array(
	        'status' => false,
	        'message' => "Error in Qrcode fetching"
	        );
	    }
	    
	        echo Json_encode($json_data);
	}
	function add_student_details()
	{
	  //  echo "<pre>";
	  //  print_r($_POST);exit;
	   $this->load->library('upload');
	   $school_id = $this->session->userdata('school_id');
	   $student_name = $this->input->post('student_name');
	   $session_id = $this->input->post('session_id');
	   $class_id = $this->input->post('class_id');
	   $admission_id = $this->input->post('admission_id');
	    if(!empty($school_id)){
	        $checkschool  = $this->mainmodel->common_fetch('students',array('school_id' => $school_id, 'student_name' =>$student_name,
	                                   'session_id' => $session_id, 'class_id' =>$class_id, 'admission_id' => $admission_id  )); 
	       
	        if(empty($checkschool)){
	           /*student image upload*/ 
	            if(!empty($_FILES['student_image']['name'])){
	                $config['upload_path']          = 'assets/images/students/';
            		$config['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config['max_size']             = 2000;
            		$this->upload->initialize($config);
            		$this->load->library('upload', $config);
            		if($this->upload->do_upload('student_image')){
            			$imgdata = $this->upload->data();
            			$student_image = 'assets/images/students/'.$imgdata['file_name'];
            		}else{
            			$student_image = '';
            		}
	            }else{
	                	$student_image = '';
	            }
	             /*father image upload*/ 
	             if(!empty($_FILES['father_image']['name'])){
	                $config1['upload_path']          = 'assets/images/fathers/';
            		$config1['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config1['max_size']             = 2000;
            			$this->upload->initialize($config1);
            		$this->load->library('upload', $config1);
            		if($this->upload->do_upload('father_image')){
            			$imgdata1 = $this->upload->data();
            			$father_image = 'assets/images/fathers/'.$imgdata1['file_name'];
            		}else{
            			$father_image = '';
            		}
	            }else{
	                	$father_image = '';
	            }
	            /*mother image upload*/ 
	             if(!empty($_FILES['mother_image']['name'])){
	                $config2['upload_path']          = 'assets/images/mothers/';
            		$config2['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config2['max_size']             = 2000;
            		$this->upload->initialize($config2);
            		$this->load->library('upload', $config2);
            		if($this->upload->do_upload('mother_image')){
            			$imgdata2 = $this->upload->data();
            			$mother_image = 'assets/images/mothers/'.$imgdata2['file_name'];
            		}else{
            			$mother_image = '';
            		}
	            }else{
	                	$mother_image = '';
	            }
	       
	            /*guardian image upload*/ 
	             if(!empty($_FILES['guardian_image']['name'])){
	                $config3['upload_path']          = 'assets/images/guardians/';
            		$config3['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config3['max_size']             = 2000;
            		$this->upload->initialize($config3);
            		$this->load->library('upload', $config3);
            		if($this->upload->do_upload('guardian_image')){
            			$imgdata3 = $this->upload->data();
            			$guardian_image = 'assets/images/guardians/'.$imgdata3['file_name'];
            		}else{
            			$guardian_image = '';
            		}
	            }else{
	                	$guardian_image = '';
	            }
	            
	            

	            $data = array(
	                'school_id' => $school_id,
	                'admission_id' => $this->input->post('admission_id'),
	                'session_id' => $this->input->post('session_id'),
	                'class_id' => $this->input->post('class_id'),
	                'joining_date' => $this->input->post('joining_date'),
	                'student_name' => $this->input->post('student_name'),
	                'student_dob' => $this->input->post('student_dob'),
	                'student_gender' => $this->input->post('student_gender'),
	                'student_blood_group' => $this->input->post('student_blood_group'),
	                'student_image' => $student_image,
	                'father_name' => $this->input->post('father_name'),
	                'father_mobile' => $this->input->post('father_mobile'),
	                'father_email' => $this->input->post('father_email'),
	                'father_image' => $father_image,
	                'mother_name' => $this->input->post('mother_name'),
	                'mother_mobile' => $this->input->post('mother_mobile'),
	                'mother_email' => $this->input->post('mother_email'),
	                'mother_image' => $mother_image,
	                'guardian_name' => $this->input->post('guardian_name'),
	                'guardian_mobile' => $this->input->post('guardian_mobile'),
	                'guardian_email' => $this->input->post('guardian_email'),
	                'guardian_image' => $guardian_image,
	                'address' => $this->input->post('address'),
	                'city' => $this->input->post('city'),
	                'pincode' => $this->input->post('pincode'),
	                'father_occupation' => $this->input->post('father_occupation'),
	                'father_office_designation' => $this->input->post('father_office_designation'),
	                'father_office_address' => $this->input->post('father_office_address'),
	                'father_annual_income' => $this->input->post('father_annual_income'),
	                'mother_occupation' => $this->input->post('mother_occupation'),
	                'mother_office_designation' => $this->input->post('mother_office_designation'),
	                'mother_office_address' => $this->input->post('mother_office_address'),
	                'mother_annual_income' => $this->input->post('mother_annual_income'),
	                'status' => 1,
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $insert = $this->mainmodel->common_insert('students',$data);
	           if($insert){
	               include('phpqrcode/qrlib.php');
                   //$uniq = sprintf('%04d',$insert);
                    $uniqueNumber = time() . rand(1000, 9999);
                    $item = $uniqueNumber;
        	              //  $item = 'HEALTH_CARD_'.$uniq;
                            
                            //print_r($item);
                            
                        	$file = "assets/qrcodes/student/".''.$item.'.png';
                            //other parameters
                            	$ecc = 'H';
                        	$pixel_size = 10;
                        	
                        	QRcode::png($item, $file, $ecc, $pixel_size);
                        	
                        	$data_qrcode = array(
                        	    'qrcode' => $file,
                        	    'qrcode_id' => $uniqueNumber,
                        	    'updated_on' =>date('Y-m-d H:i:s')
                        	    );
                        	    $update = $this->mainmodel->common_update('students',$data_qrcode,array('id' => $insert));
	           }
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Student details added successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry,same Student name with this session and class  already exists."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	}
	function edit_student($id)
	{
	    $url_param = rtrim($id, '=');
        // and later:
        $base_64 = $url_param . str_repeat('=', strlen($url_param) % 4);
        $id = base64_decode($base_64);
	    $data['classes'] = $this->mainmodel->common_fetch('class',array('delete_status' => 1, 'school_id' => $this->session->userdata('school_id')));
	    $data['sessions'] = $this->mainmodel->common_fetch('school_sessions',array('delete_status' => 1, 'status' => 1));
	    $data['student_data'] = $this->mainmodel->common_fetch('students',array('id' => $id));
	    $this->load->view('includes/header');
		$this->load->view('edit_student',$data);
		$this->load->view('includes/footer');
	}
	function update_student_details()
	{
	  //  echo "<pre>";
	  //  print_r($_POST);exit;
	   $this->load->library('upload');
	   $student_id = $this->input->post('student_id');
	   $school_id = $this->session->userdata('school_id');
	   $student_name = $this->input->post('student_name');
	   $session_id = $this->input->post('session_id');
	   $class_id = $this->input->post('class_id');
	   $admission_id = $this->input->post('admission_id');
	    if(!empty($school_id)){
	       // $checkschool  = $this->mainmodel->common_fetch('students',array('school_id' => $school_id, 'student_name' =>$student_name,
	       //                            'session_id' => $session_id, 'class_id' =>$class_id, 'admission_id' => $admission_id  )); 
	       
	        if(!empty($student_id)){
	           /*student image upload*/ 
	            if(!empty($_FILES['student_image']['name'])){
	                $config['upload_path']          = 'assets/images/students/';
            		$config['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config['max_size']             = 2000;
            		$this->upload->initialize($config);
            		$this->load->library('upload', $config);
            		if($this->upload->do_upload('student_image')){
            			$imgdata = $this->upload->data();
            			$student_image = 'assets/images/students/'.$imgdata['file_name'];
            		}else{
            			$student_image = '';
            		}
	            }else{
	                	$student_image = '';
	            }
	             /*father image upload*/ 
	             if(!empty($_FILES['father_image']['name'])){
	                $config1['upload_path']          = 'assets/images/fathers/';
            		$config1['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config1['max_size']             = 2000;
            			$this->upload->initialize($config1);
            		$this->load->library('upload', $config1);
            		if($this->upload->do_upload('father_image')){
            			$imgdata1 = $this->upload->data();
            			$father_image = 'assets/images/fathers/'.$imgdata1['file_name'];
            		}else{
            			$father_image = '';
            		}
	            }else{
	                	$father_image = '';
	            }
	            /*mother image upload*/ 
	             if(!empty($_FILES['mother_image']['name'])){
	                $config2['upload_path']          = 'assets/images/mothers/';
            		$config2['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config2['max_size']             = 2000;
            		$this->upload->initialize($config2);
            		$this->load->library('upload', $config2);
            		if($this->upload->do_upload('mother_image')){
            			$imgdata2 = $this->upload->data();
            			$mother_image = 'assets/images/mothers/'.$imgdata2['file_name'];
            		}else{
            			$mother_image = '';
            		}
	            }else{
	                	$mother_image = '';
	            }
	       
	            /*guardian image upload*/ 
	             if(!empty($_FILES['guardian_image']['name'])){
	                $config3['upload_path']          = 'assets/images/guardians/';
            		$config3['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config3['max_size']             = 2000;
            		$this->upload->initialize($config3);
            		$this->load->library('upload', $config3);
            		if($this->upload->do_upload('guardian_image')){
            			$imgdata3 = $this->upload->data();
            			$guardian_image = 'assets/images/guardians/'.$imgdata3['file_name'];
            		}else{
            			$guardian_image = '';
            		}
	            }else{
	                	$guardian_image = '';
	            }
	            
	            

	            $data = array(
	                'school_id' => $school_id,
	                'admission_id' => $this->input->post('admission_id'),
	                'session_id' => $this->input->post('session_id'),
	                'class_id' => $this->input->post('class_id'),
	                'joining_date' => $this->input->post('joining_date'),
	                'student_name' => $this->input->post('student_name'),
	                'student_dob' => $this->input->post('student_dob'),
	                'student_gender' => $this->input->post('student_gender'),
	                'student_blood_group' => $this->input->post('student_blood_group'),
	                'student_image' => $student_image,
	                'father_name' => $this->input->post('father_name'),
	                'father_mobile' => $this->input->post('father_mobile'),
	                'father_email' => $this->input->post('father_email'),
	                'father_image' => $father_image,
	                'mother_name' => $this->input->post('mother_name'),
	                'mother_mobile' => $this->input->post('mother_mobile'),
	                'mother_email' => $this->input->post('mother_email'),
	                'mother_image' => $mother_image,
	                'guardian_name' => $this->input->post('guardian_name'),
	                'guardian_mobile' => $this->input->post('guardian_mobile'),
	                'guardian_email' => $this->input->post('guardian_email'),
	                'guardian_image' => $guardian_image,
	                'address' => $this->input->post('address'),
	                'city' => $this->input->post('city'),
	                'pincode' => $this->input->post('pincode'),
	                'father_occupation' => $this->input->post('father_occupation'),
	                'father_office_designation' => $this->input->post('father_office_designation'),
	                'father_office_address' => $this->input->post('father_office_address'),
	                'father_annual_income' => $this->input->post('father_annual_income'),
	                'mother_occupation' => $this->input->post('mother_occupation'),
	                'mother_office_designation' => $this->input->post('mother_office_designation'),
	                'mother_office_address' => $this->input->post('mother_office_address'),
	                'mother_annual_income' => $this->input->post('mother_annual_income'),
	                'status' => 1,
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $insert = $this->mainmodel->common_insert('students',$data);
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Student details added successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry,same Student name with this session and class  already exists."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	}
	
	function update_student_documents()
	{
	   // echo "<pre>";
	   // print_r($_POST);
	   // print_r($_FILES);exit;
	    if ($_SERVER['REQUEST_METHOD'] === 'POST') 
	    {
	        $this->load->library('upload');
           foreach ($_FILES as $key => $file) {
        
	         if(!empty($file['name'])){
	                $config['upload_path']          = 'assets/documents/students/';
            		$config['allowed_types']        = 'jpg|png|gif|jpeg|webp|pdf';
            	//	$config['max_size']             = 2000;
            		$this->upload->initialize($config);
            	//	$this->load->library('upload', $config);
            		if($this->upload->do_upload($key)){
            			$imgdata = $this->upload->data();
            			$student_image = 'assets/documents/students/'.$imgdata['file_name'];
            		}else{
            			$student_image = '';
            		}
	            }else{
	                	$student_image = '';
	            }
	            $data = array(
	                'student_id' => $this->input->post('student_id'),
	                'document' => $student_image,
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $insert = $this->mainmodel->common_insert('student_documents',$data);
         }
         $json_data = array(
	            'status' => true,
	            'message' => "Student documents uploaded successfully."
	            );
	            echo json_encode($json_data);
        } 
	}
		/*student creation start*/
		
		
		/*albums module start*/
		
		/*albums module end*/
		
		/*day care module start*/
	public function add_meal()
	{
	        $this->load->view('includes/header');
		    $this->load->view('add_meal');
	    	$this->load->view('includes/footer');
	}
	public function add_meal_details()
	{
	    $breakfast = $this->input->post('breakfast');
	    $lunch = $this->input->post('lunch');
	    $snacks = $this->input->post('snacks');
	    $evngsnacks = $this->input->post('evngsnacks');
	    $school_id = $this->session->userdata('school_id');
	    $date = date('Y-m-d');
	 //  echo $breakfast;exit;
	    if(!empty($breakfast) && !empty($school_id) && !empty($lunch) && !empty($snacks) && !empty($evngsnacks)){
	        $checkschool  = $this->mainmodel->common_fetch('meals',array('breakfast' => $breakfast, 'school_id' =>$school_id, 'date' => $date,
	                                                            'lunch' => $lunch, 'snacks' => $snacks, 'evngsnacks' => $evngsnacks)); 
	       
	        if(empty($checkschool)){
	            $data = array(
	                'breakfast' =>$breakfast,
	                'school_id' => $school_id,
	                'lunch' => $lunch,
	                'snacks' => $snacks,
	                'evngsnacks' => $evngsnacks,
	                'date' => date('Y-m-d'),
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $insert = $this->mainmodel->common_insert('meals',$data);
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Meal details added successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry,Meal details already exists."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	}
	public function add_activity()
	{
	        $this->load->view('includes/header');
		    $this->load->view('add_activity');
	    	$this->load->view('includes/footer');
	}
	public function add_activity_details()
	{
	    $activity_name = $this->input->post('activity_name');
	    $description = $this->input->post('description');
	    $start_time = $this->input->post('start_time');
	    $end_time = $this->input->post('end_time');
	    $school_id = $this->session->userdata('school_id');
	    $date = date('Y-m-d');
	 //  echo $breakfast;exit;
	    if(!empty($activity_name) && !empty($school_id) && !empty($description) && !empty($start_time) && !empty($end_time)){
	        $checkschool  = $this->mainmodel->common_fetch('activities',array('activity_name' => $activity_name, 'school_id' =>$school_id, 'date' => $date,
	                                                            'description' => $description, 'start_time' => $start_time, 'end_time' => $end_time)); 
	       
	        if(empty($checkschool)){
	            $data = array(
	                'activity_name' =>$activity_name,
	                'school_id' => $school_id,
	                'description' => $description,
	                'start_time' => $start_time,
	                'end_time' => $end_time,
	                'date' => date('Y-m-d'),
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $insert = $this->mainmodel->common_insert('activities',$data);
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Activity details added successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry,Activity details already exists."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	}
	public function edit_activity($id)
	{
	    $url_param = rtrim($id, '=');
        // and later:
        $base_64 = $url_param . str_repeat('=', strlen($url_param) % 4);
        $id = base64_decode($base_64);
        $data['activity'] = $this->mainmodel->common_fetch('activities',array('id' => $id));
	        $this->load->view('includes/header');
		    $this->load->view('edit_activity',$data);
	    	$this->load->view('includes/footer');
	}
	public function update_activity_details()
	{
	    $activity_id = $this->input->post('activity_id');
	    $activity_name = $this->input->post('activity_name');
	    $description = $this->input->post('description');
	    $start_time = $this->input->post('start_time');
	    $end_time = $this->input->post('end_time');
	    $school_id = $this->session->userdata('school_id');
	    $date = date('Y-m-d');
	 //  echo $breakfast;exit;
	    if(!empty($activity_name) && !empty($school_id) && !empty($description) && !empty($start_time) && !empty($end_time) && $activity_id){
	       // $checkschool  = $this->mainmodel->common_fetch('activities',array('activity_name' => $activity_name, 'school_id' =>$school_id, 'date' => $date,
	       //                                                     'description' => $description, 'start_time' => $start_time, 'end_time' => $end_time)); 
	       
	        if(!empty($activity_id)){
	            $data = array(
	                'activity_name' =>$activity_name,
	                //'school_id' => $school_id,
	                'description' => $description,
	                'start_time' => $start_time,
	                'end_time' => $end_time,
	                'date' => date('Y-m-d'),
	                'updated_on' => date('Y-m-d H:i:s')
	                );
	           $update = $this->mainmodel->common_update('activities',$data,array('id' => $activity_id));
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Activity details updated successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Activity details not updated."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	}
	public function delete_activity_details()
	{
	    $id = $this->input->post('id');
	    //echo $id;exit;
	    if(!empty($id)){
	        $data = array(
	            'delete_status' => 0,
	            'updated_on' => date('Y-m-d H:i:s')
	            );
	        $getdetails = $this->mainmodel->common_update('activities',$data,array('id' => $id));
	        $json_data = array(
	            'status' => true,
	            'message' => "Activity deleted successfully",
	            'details' => ""
	            );
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "No details",
	            'details' => ""
	            );
	    }
	    echo json_encode($json_data);exit;
	}
	
	function activities_list()
	{
	    $data['classes'] = $this->mainmodel->common_fetch('class',array('delete_status' => 1, 'school_id' => $this->session->userdata('school_id')));
	    $data['sessions'] = $this->mainmodel->common_fetch('school_sessions',array('delete_status' => 1, 'status' => 1));
	    $data['all_activities'] = $this->mainmodel->get_all_daycare_data($this->session->userdata('school_id'));
	    $this->load->view('includes/header');
		$this->load->view('list_activities',$data);
		$this->load->view('includes/footer');
	}
	
		/*day care module end*/ 
		
		 
		/* fee module start*/
		
	public function fee_setup()
	{
	    $get_session = $this->mainmodel->common_fetch('school_sessions',array('delete_status' => 1, 'status' => 1));
	    $startDate = $get_session[0]->start_date;
	    $endDate = $get_session[0]->end_date;
	    // Get all months
       $data['months'] = $this->getMonthsBetweenDates($startDate, $endDate);
	    $this->load->view('includes/header');
		$this->load->view('fee_setup',$data);
		$this->load->view('includes/footer');
	}
	// Function to get all months between two dates
    function getMonthsBetweenDates($startDate, $endDate) 
    {
        $start = new DateTime($startDate);
        $end = new DateTime($endDate);
        $months = [];
    
        while ($start <= $end) {
            $months[] = $start->format('F'); // Get the full month name and year
            $start->modify('+1 month');
        }
    
        return $months;
   }
   public function add_fee_due_date_details()
   {
       $due_date = $this->input->post('due_date');
	    $school_id = $this->session->userdata('school_id');
	    $due_month = $this->input->post('due_month');
	    if(!empty($due_month) && !empty($school_id) && !empty($due_date)){
	        $checkschool  = $this->mainmodel->common_fetch('fee_due_dates',array('due_month' => $due_month, 'school_id' =>$school_id, )); 
	       
	       if($this->input->post('fee_reminders') == "yes"){
	           $fee_reminders = "yes";
	       }else{
	           $fee_reminders = "no";
	       }
	        if(empty($checkschool)){
	            $data = array(
	                'due_month' =>$due_month,
	                'school_id' => $school_id,
	                'due_date' => $due_date,
	                'fee_reminders' => $fee_reminders,
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $insert = $this->mainmodel->common_insert('fee_due_dates',$data);
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Fee Cycle due date added successfully."
        	            );
	            
	        }else{
	            $data = array(
	                'due_month' =>$due_month,
	                'school_id' => $school_id,
	                'due_date' => $due_date,
	                'fee_reminders' => $fee_reminders,
	                'updated_on' => date('Y-m-d H:i:s')
	                );
	           $insert = $this->mainmodel->common_update('fee_due_dates',$data,array('due_month' => $due_month, 'school_id' =>$school_id, ));
	             $json_data = array(
	            'status' => true,
	            'message' => "Fee Cycle due date updated successfully."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
   }
	
	public function fee_components()
	{
	    $data['getdetails'] = $this->mainmodel->common_fetch('fee_components',array('delete_status' => 1));
	    $this->load->view('includes/header');
		$this->load->view('fee_components',$data);
		$this->load->view('includes/footer');
	}
	public function add_fee_components_details()
	{
	     $component_name = $this->input->post('component_name');
	    $school_id = $this->session->userdata('school_id');
	    $time_period = $this->input->post('time_period');
	 //   echo "<pre>";
	 //   print_r($_POST);exit;
	   // echo $class_name.$school_id.$class_section.$session;exit;
	    if(!empty($component_name) && !empty($school_id) && !empty($time_period)){
	        $checkschool  = $this->mainmodel->common_fetch('fee_components',array('component_name' => $component_name, 'school_id' =>$school_id, 
	                                                            'time_period' => $time_period)); 
	       
	        if(empty($checkschool)){
	            $data = array(
	                'component_name' =>$component_name,
	                'school_id' => $school_id,
	                'time_period' => $time_period,
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $insert = $this->mainmodel->common_insert('fee_components',$data);
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Fee Component added successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry,Fee Component name with periodicity already exists."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	}
	public function get_fee_component_details()
	{
	    $id = $this->input->post('id');
	    //echo $id;exit;
	    if(!empty($id)){
	        $getdetails = $this->mainmodel->common_fetch('fee_components',array('id' => $id));
	        $json_data = array(
	            'status' => true,
	            'message' => "Details fetched successfully",
	            'details' => $getdetails
	            );
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "No details",
	            'details' => ""
	            );
	    }
	    echo json_encode($json_data);exit;
	}
	public function update_fee_component_details()
	{
	    
	    $component_name = $this->input->post('component_name_u');
	    $fee_component_id = $this->input->post('fee_component_id');
	    $time_period = $this->input->post('time_period_u');
	    $include_month = $this->input->post('include_month');
	    $bank_account = $this->input->post('bank_account');
	    $school_id = $this->session->userdata('school_id');
	    $date = date('Y-m-d');
	 //  echo $breakfast;exit;
	    if(!empty($component_name) && !empty($school_id) && !empty($fee_component_id) && !empty($time_period)){
	       // $checkschool  = $this->mainmodel->common_fetch('activities',array('activity_name' => $activity_name, 'school_id' =>$school_id, 'date' => $date,
	                                                    //        'description' => $description, 'start_time' => $start_time, 'end_time' => $end_time)); 
	       
	        if(!empty($fee_component_id)){
	            $data = array(
	                'component_name' =>$component_name,
	                'school_id' => $school_id,
	                'time_period' => $time_period,
	                'include_month' => $include_month,
	                'bank_account' => $bank_account,
	                'updated_on' => date('Y-m-d H:i:s')
	                );
	           $update = $this->mainmodel->common_update('fee_components',$data,array('id' => $fee_component_id));
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Fee components details updated successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Invalid details."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	}
	public function delete_fee_component_details()
	{
	    $id = $this->input->post('id');
	    //echo $id;exit;
	    if(!empty($id)){
	        $data = array(
	            'delete_status' => 0,
	            'updated_on' => date('Y-m-d H:i:s')
	            );
	        $getdetails = $this->mainmodel->common_update('fee_components',$data,array('id' => $id));
	        $json_data = array(
	            'status' => true,
	            'message' => "Component deleted successfully",
	            'details' => ""
	            );
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "No details",
	            'details' => ""
	            );
	    }
	    echo json_encode($json_data);exit;
	}
	
	
	public function class_fee_structure()
	{
	     $school_id = $this->session->userdata('school_id');
	    $data['classes'] = $this->mainmodel->common_fetch('class',array('school_id' => $school_id,'delete_status' => 1, 'status' => 1));
	    $data['sessions'] = $this->mainmodel->common_fetch('school_sessions',array('school_id' => $school_id,'delete_status' => 1, 'status' => 1));
	    $data['components'] = $this->mainmodel->common_fetch('fee_components',array('school_id' => $school_id,'delete_status' => 1));
	    $this->load->view('includes/header');
		$this->load->view('class_fee_structure',$data);
		$this->load->view('includes/footer');
	}
	
	public function add_edit_class_fee_template()
	{
	     $school_id = $this->session->userdata('school_id');
	    $data['classes'] = $this->mainmodel->common_fetch('class',array('school_id' => $school_id,'delete_status' => 1, 'status' => 1));
	    $data['templates'] = $this->mainmodel->common_fetch('school_class_fee_templates',array('school_id' => $school_id,'delete_status' => 1));
	    $data['components'] = $this->mainmodel->common_fetch('fee_components',array('school_id' => $school_id,'delete_status' => 1));
	    $this->load->view('includes/header');
		$this->load->view('add_edit_class_fee_structure',$data);
		$this->load->view('includes/footer');
	}
	public function add_fee_component_class_details()
	{
       $class = $this->input->post('class');
	    $school_id = $this->session->userdata('school_id');
	    $component = $this->input->post('component');
	    if(!empty($class) && !empty($school_id) && !empty($component)){
	   $checkschool  = $this->mainmodel->common_fetch('class_fee_components',array('class_id' => $class, 'component_id' => $component, 'school_id' =>$school_id, )); 
	       
	       
	        if(empty($checkschool)){
	            $data = array(
	                'class_id' =>$class,
	                'school_id' => $school_id,
	                'component_id' => $component,
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $insert = $this->mainmodel->common_insert('class_fee_components',$data);
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Fee component added to class successfully."
        	            );
	            
	        }else{
	            
	             $json_data = array(
	            'status' => false,
	            'message' => "Fee component already added to class."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
   }
   
   public function view_class_components_ajax()
   {
       $class_id =  $this->input->post('class_id');
      
       
       $school_id = $this->session->userdata('school_id');
       if($class_id > 0){
          $data['components'] = $this->mainmodel->get_class_component_data($school_id,$class_id);
         // echo $this->db->last_query();exit;
          $this->load->view('ajax_class_fee_component',$data);
       }
   }
   public function view_class_fee_template_ajax()
   {
       $class_id =  $this->input->post('class_id');
       $school_id = $this->session->userdata('school_id');
       $data['components'] = $this->mainmodel->get_fee_class_template_data($school_id,$class_id);
          //echo $this->db->last_query();exit;
        //     echo "<pre>";
      //print_r($data);exit;
         // $this->load->view('ajax_class_fee_component',$data);
          $this->load->view('ajax_view_class_fee_template_component',$data);
   }
   public function get_class_fee_template_details()
   {
       $class_id =  $this->input->post('class_id');
       $getdetails = $this->mainmodel->common_fetch('school_class_fee_templates',array('class_id' => $class_id));
       $json_data = array(
	            'status' => true,
	            'message' => "Template Details fetched successfully",
	            'id' => $getdetails[0]->id,
	            'template_name' => $getdetails[0]->template_name
	            );
	       echo json_encode($json_data);exit;
   }
   public function update_class_default_fee_template()
   {
    //         echo "<pre>";
    //   print_r($_POST);exit;
      if ($_SERVER['REQUEST_METHOD'] === 'POST') 
	    {
	     $class_id = $this->input->post('class_id');
	     $template_id = $this->input->post('template_id');
	     if($class_id != 0 && $template_id != 0){
	         $data = array(
	             'default_class' => $class_id,
	             'updated_on' => date('Y-m-d H:i:s')
	             );
	             $update = $this->mainmodel->common_update('school_class_fee_templates',$data,array('id' => $template_id));
	           $json_data = array(
	            'status' => true,
	            'message' => "Marked as Default Template For Class.",
	            );
	       echo json_encode($json_data);exit;
	     }else{
	         $json_data = array(
	            'status' => false,
	            'message' => "$template_id Default Template Not Marked For Class $class_id.",
	            );
	       echo json_encode($json_data);exit;
	     }
          
      }else{
          $json_data = array(
	            'status' => false,
	            'message' => "Default Template Not Marked For Class.",
	            );
	       echo json_encode($json_data);exit;
      }
   }
   public function get_fee_component_ajax()
   {
       $id = $this->input->post('component_id');
	  //  echo $id;exit;
	    if(!empty($id)){
	       
	        $getdetails = $this->mainmodel->common_fetch('fee_components',array('id' => $id));
	        $json_data = array(
	            'status' => true,
	            'message' => "Component Fetched successfully",
	            'id' => $getdetails[0]->id,
	            'component_name' => $getdetails[0]->component_name,
	            'time_period' => $getdetails[0]->time_period
	            );
	            echo json_encode($json_data);exit;
	    }
	    
   }
   public function delete_class_fee_component_details()
   {
       $id = $this->input->post('id');
	    //echo $id;exit;
	    if(!empty($id)){
	        $data = array(
	            'delete_status' => 0,
	            'updated_on' => date('Y-m-d H:i:s')
	            );
	        $getdetails = $this->mainmodel->common_update('class_fee_components',$data,array('id' => $id));
	        $json_data = array(
	            'status' => true,
	            'message' => "Component deleted successfully",
	            'details' => ""
	            );
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "No details",
	            'details' => ""
	            );
	    }
	    echo json_encode($json_data);exit;
   }
   public function update_class_fee_component_details()
   {
    //   echo "<pre>";
    //   print_r($_POST);exit;
       if ($_SERVER['REQUEST_METHOD'] === 'POST') 
       {
            $school_id = $this->session->userdata('school_id');
           $template_name =   $this->input->post('template_name');
           $assigned_class = $this->input->post('assigned_class');
           if(empty($template_name)){
                $json_data = array(
        	            'status' => false,
        	            'message' => "Please Add Template Name."
        	            );
        	            echo json_encode($json_data);exit;
           }
           $component_id =   $this->input->post('component_id');
         $component_value =   $this->input->post('component_value');
           if(!empty($component_id) && !empty($component_value)){
               $data = array(
                   'template_name' => $template_name,
                   'school_id' => $school_id,
                   'class_id' => $assigned_class,
                   'created_on' =>date('Y-m-d H:i:s')
                   );
                   $insert = $this->mainmodel->common_insert('school_class_fee_templates',$data);
               for ($i = 0; $i < count($component_id); $i++) {
               $data1 = array(
                   'fee_template_id' => $insert,
                   'component_id' => $component_id[$i],
                   'amount' => $component_value[$i],
                   'created_on' => date('Y-m-d H:i:s')
                   );
                   $update = $this->mainmodel->common_insert('school_class_fee_template_components',$data1);
           }
           
           $json_data = array(
        	            'status' => true,
        	            'message' => "Fee Template Cretaed successfully."
        	            );
        	            
           }
         
           
           
        //   if(!empty($this->input->post('duplicate_class')) && $this->input->post('duplicate_class') > 0){
        //       $emptyclass = $this->mainmodel->common_delete('class_fee_components',array('class_id' => $this->input->post('duplicate_class'),
        //       'school_id' => $this->session->userdata('school_id')));
        //       for ($i = 0; $i < count($component_id); $i++) {
        //       $data1 = array(
        //           'class_id' => $this->input->post('duplicate_class'),
        //           'school_id' => $this->session->userdata('school_id'),
        //           'amount' => $component_value[$i],
        //           'created_on' => date('Y-m-d H:i:s')
        //           );
        //           $update = $this->mainmodel->common_insert('class_fee_components',$data1);
        //       }
               
               
        //   }
           
           
       }else{
           $json_data = array(
        	            'status' => false,
        	            'message' => "Fee component added to class not updated."
        	            );
       }
       
       echo json_encode($json_data);exit;
   }
   public function get_fee_template_details_ajax()
   {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') 
       {
          $template_id = $this->input->post('template_id');
          $get_template = $this->mainmodel->common_fetch('school_class_fee_templates',array('id' => $template_id));
          $get_template_components = $this->mainmodel->get_fee_template_components($template_id);
          $json_data = array(
        	            'status' => true,
        	            'message' => "Fee component added to class not updated.",
        	            'template' => $get_template,
        	            'components' => $get_template_components,
        	            );
       }else{
           $json_data = array(
        	            'status' => false,
        	            'message' => "Fee component added to class not updated."
        	            );
       }
       echo json_encode($json_data);exit;
   }
   public function fee_concession()
   {
       //echo "hi";exit;
       $data['concessions'] = $this->mainmodel->common_fetch('concession_category',array('delete_status' => 1));
        $this->load->view('includes/header');
		$this->load->view('fee_concession',$data);
		$this->load->view('includes/footer');
   } 
   
   public function view_fee_concession_ajax()
   {
       $concession_id =  $this->input->post('concession_id');
       $school_id = $this->session->userdata('school_id');
       if($concession_id > 0){
           $data['classconcession'] = $this->mainmodel->get_class_consession_data($school_id,$concession_id);
          //  echo $this->db->last_query();exit;
          $data['concessions'] = $this->mainmodel->common_fetch('fee_components',array('delete_status' => 1));
         $data['concession_id'] = $concession_id;
          $this->load->view('ajax_class_fee_consession',$data);
       }
   }
   public function add_school_fee_concession_details()
   {
    //       echo "<pre>";
    //   print_r($_POST);exit;
      
      if ($_SERVER['REQUEST_METHOD'] === 'POST') 
       {
         $concession_id =   $this->input->post('concession_id');
         $component_id =   $this->input->post('component_id');
         $concession_amount =   $this->input->post('concession_amount');
         $check = $this->mainmodel->common_fetch('school_concessions',array('concession_id' => $concession_id));
         if(!empty($check)){
        $this->mainmodel->common_delete('school_concessions',array('concession_id' => $concession_id));
         }
        // if(empty($check))
         {
             for ($i = 0; $i < count($component_id); $i++) {
               $data = array(
                   'school_id' => $this->session->userdata('school_id'),
                   'concession_id' =>$concession_id,
                   'component_id' => $component_id[$i],
                   'concession_amount' => $concession_amount[$i],
                   'updated_on' => date('Y-m-d H:i:s')
                   );
                  $update = $this->mainmodel->common_insert('school_concessions',$data); 
           }
         }
         //else
         {
            // $this->mainmodel->common_delete('school_concessions',array('concession_id' => $concession_id));
        //      for ($i = 0; $i < count($component_id); $i++) {
        //       $data1 = array(
        //           'school_id' => $this->session->userdata('school_id'),
        //           'concession_id' =>$concession_id,
        //           'component_id' => $component_id[$i],
        //           'concession_amount' => $concession_amount[$i],
        //           'created_on' => date('Y-m-d H:i:s')
        //           );
                   
        //           $update = $this->mainmodel->common_update('school_concessions',$data1,array('concession_id' =>$concession_id,
        //             'component_id' => $component_id[$i],'school_id' => $this->session->userdata('school_id')));
        //   }
         }
           
           
         
               
               $json_data = array(
        	            'status' => true,
        	            'message' => "Fee Concession added to school successfully."
        	            );
           
           
       }else{
           $json_data = array(
        	            'status' => false,
        	            'message' => "Fee Concession added to school not updated."
        	            );
       }
       echo json_encode($json_data);
   }
   
   public function student_fee_structure()
   {
       $data['sessions'] = $this->mainmodel->common_fetch('school_sessions',array('school_id' => $this->session->userdata('school_id')));
       $data['concessions'] = $this->mainmodel->common_fetch('concession_category',array('delete_status' => 1));
       
       $this->load->view('includes/header');
		$this->load->view('student_fee_structure',$data);
		$this->load->view('includes/footer');
	
   }
   public function get_student_details()
   {
       $student_id =  $this->input->post('student_id');
       $get_class= $this->mainmodel->common_fetch('students',array('id' => $student_id));
       $class_id = $get_class[0]->class_id;
       $get_student= $this->mainmodel->get_student_all_details($student_id);
       $get_template = $this->mainmodel->common_fetch('school_class_fee_templates',array('default_class' => $class_id));
       if(!empty($get_template)){
           $tempalte_name = $get_template[0]->template_name;
           $template_id = $get_template[0]->id;
       }else{
           $tempalte_name = '';
           $template_id = '';
       }
       $json_data = array(
        	            'status' => true,
        	            'message' => "Students Details Fetched.",
        	            'details' => $get_student[0],
        	            'tempalte_name' => $tempalte_name,
        	            'template_id' => $template_id,
        	            );
       echo json_encode($json_data);
   }
   public function get_student_fee_structure()
   {
       $student_id =  $this->input->post('student_id');
        $session_id = $this->input->post('session_id');
       $get_class= $this->mainmodel->common_fetch('students',array('id' => $student_id));
       $class_id = $get_class[0]->class_id;
       $school_id = $this->session->userdata('school_id');
       if($class_id > 0){
           
           $data['student_fee'] = $this->mainmodel->get_student_fee_deatils_all($student_id,$session_id);
           //  echo "<pre>";
      // print_r($data['student_fee']);exit;
     
     
           if(!empty($data['student_fee'])){
             //  echo "hi";exit;
               $this->load->view('ajax_student_existing_fee_structure',$data);
           }else{
                $data['components'] = $this->mainmodel->get_fee_class_template_data($school_id,$class_id);
          $data['studnets_fee_detaisl'] = $this->mainmodel->get_student_fee_structure_details($student_id);
         // echo $this->db->last_query();exit;
          $this->load->view('ajax_student_fee_structure',$data);
           }
           
           
         
       }
   }
   public function add_student_fee_details()
   {
     //  echo "<pre>";
     //  print_r($_POST);exit;
       if ($_SERVER['REQUEST_METHOD'] === 'POST') 
       {
           $check = $this->mainmodel->common_fetch('student_fee_structure',array('student_id' => $this->input->post('student_id'),
           'session_id' => $this->input->post('session_id')));
           if(empty($check)){
                       $component_id = explode(',',$this->input->post('component_id'));
                       $component_value = explode(',',$this->input->post('component_value'));
                       $component_concesion = explode(',',$this->input->post('component_concesion'));
                       $component_payable_amount = explode(',',$this->input->post('component_payable_amount'));    
                      // echo "<pre>";
                      // print_r($component_id);exit;
                      
               $data = array(
                   'student_id' => $this->input->post('student_id'),
                   'session_id' => $this->input->post('session_id'),
                   'fee_frequency' => $this->input->post('fee_frequency'),
                   'concesion_category' => $this->input->post('concession_id'),
                   'fee_template' => $this->input->post('fee_template'),
                   'fee_security' => $this->input->post('fee_security'),
                   'concesion_type' => $this->input->post('concesion_type'),
                   'total_fee' => $this->input->post('grandtotal')
                   );
                   $insert = $this->mainmodel->common_insert('student_fee_structure',$data);
                   if($insert){
                      // echo "<pre>";
                      // print_r($component_id);exit;
                       for($i = 0; $i < count($component_id); $i++){
                           $datac = array(
                               'student_fee_id' => $insert,
                             //  'student_id' => $this->input->post('student_id'),
                               'component_id' => $component_id[$i],
                               'component_amount' => $component_value[$i],
                               'concesion_amount' => $component_concesion[$i],
                               'net_payable' => $component_payable_amount[$i],
                               'created_on' => date('Y-m-d H:i:s')
                               );
                       //         echo "<pre>";
                       //print_r($datac);exit;
                      
                               $this->mainmodel->common_insert('student_fee_components',$datac);
                       }
                   }
                   $json_data = array(
        	            'status' => true,
        	            'message' => "Fee Details added to student."
        	            );
           }else{
               $data = array(
                   
                   );
           }
       }else{
           $json_data = array(
        	            'status' => false,
        	            'message' => "Fee Concession added to school not updated."
        	            );
       }
       echo json_encode($json_data);
   }
   public function calculate_fee()
   {
       $this->load->view('includes/header');
		$this->load->view('calculate_fee');
		$this->load->view('includes/footer');
   }
	/*fee module end */
	
	/* inventory start */
	public function add_variants()
	{
	    $this->load->view('includes/header');
		$this->load->view('add_variants');
		$this->load->view('includes/footer');
	}
	public function add_variant_details()
	{
	    $variant_name = $this->input->post('variant_name');
	    $school_id = $this->session->userdata('school_id');
	    $variant_values = $this->input->post('variant_values');
	   
	   // echo $class_name.$school_id.$class_section.$session;exit;
	    if(!empty($variant_name) && !empty($school_id) && !empty($variant_values)){
	        $checkschool  = $this->mainmodel->common_fetch('inventory_varients',array('variant_name' => $variant_name, 'school_id' =>$school_id)); 
	      $variant_values =  implode(',',$variant_values);
	        if(empty($checkschool)){
	            $data = array(
	                'variant_name' =>$variant_name,
	                'school_id' => $school_id,
	                'variant_values' => $variant_values,
	                'status' => 1,
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $insert = $this->mainmodel->common_insert('inventory_varients',$data);
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Inventory variant added successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry,Inventory variant name already exists."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	}
	public function edit_variants($id)
	{
	    $url_param = rtrim($id, '=');
        // and later:
        $base_64 = $url_param . str_repeat('=', strlen($url_param) % 4);
        $id = base64_decode($base_64);
        $data['variant'] = $this->mainmodel->common_fetch('inventory_varients',array('id' => $id));
	        $this->load->view('includes/header');
		    $this->load->view('edit_variants',$data);
	    	$this->load->view('includes/footer');
	}
	public function update_variant_details()
	{
	    $variant_id = $this->input->post('variant_id');
	    $variant_name = $this->input->post('variant_name');
	    $school_id = $this->session->userdata('school_id');
	    $variant_values = $this->input->post('variant_values');
	   
	   // echo $class_name.$school_id.$class_section.$session;exit;
	    if(!empty($variant_name) && !empty($school_id) && !empty($variant_values)){
	        $checkschool  = $this->mainmodel->common_fetch('inventory_varients',array('variant_name' => $variant_name, 'school_id' =>$school_id)); 
	      $variant_values =  implode(',',$variant_values);
	        if(!empty($variant_id) && $variant_id > 0){
	            $data = array(
	                'variant_name' =>$variant_name,
	                'school_id' => $school_id,
	                'variant_values' => $variant_values,
	                'status' => 1,
	                'updated_on' => date('Y-m-d H:i:s')
	                );
	           $update = $this->mainmodel->common_update('inventory_varients',$data,array('id' => $variant_id));
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Inventory variant Updated successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Inventory variant not updated."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	}
	public function delete_variants()
	{
	    
        $id = $this->input->post('id');
         $this->mainmodel->common_delete('inventory_varients',array('id' => $id));
        $json_data = array(
	            'status' => true,
	            'message' => "Inventory variant deleted."
	            );
	            echo json_encode($json_data);
	}
	public function list_variants()
	{
	    $this->load->view('includes/header');
		$this->load->view('list_variants');
		$this->load->view('includes/footer');
	}
	public function all_inventory_variant_info()
	{
	    $categories = $this->mainmodel->get_all_inventory_variant_details($_POST);
        $result_count=$this->mainmodel->get_all_inventory_variant_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	
	public function add_vendor()
	{
	    $this->load->view('includes/header');
		$this->load->view('add_vendor');
		$this->load->view('includes/footer');
	}
	public function add_vendor_details()
	{
	    $company_name = $this->input->post('company_name');
	    $school_id = $this->session->userdata('school_id');
	    $category = $this->input->post('category');
	    $gst_no = $this->input->post('gst_no');
	   
	   // echo $class_name.$school_id.$class_section.$session;exit;
	    if(!empty($company_name) && !empty($school_id) && !empty($category) && !empty($gst_no)){
	        $checkschool  = $this->mainmodel->common_fetch('vendors',array('company_name' => $company_name, 'school_id' =>$school_id,
	        'category' => $category, 'gst_no' =>$gst_no )); 
	    //  $variant_values =  implode(',',$variant_values);
	        if(empty($checkschool)){
	            $data = array(
	                'school_id' => $school_id,
	                 'company_name' =>$this->input->post('company_name'),
	                 'gst_no' =>$this->input->post('gst_no'),
	                 'category' =>$this->input->post('category'),
	                 'address' =>$this->input->post('address'),
	                 'contact_person_name' =>$this->input->post('contact_person_name'),
	                 'contact_person_mobile' =>$this->input->post('contact_person_mobile'),
	                 'contact_person_email' =>$this->input->post('contact_person_email'),
	                 'account_name' =>$this->input->post('account_name'),
	                 'ifsc_code' =>$this->input->post('ifsc_code'),
	                 'account_number' =>$this->input->post('account_number'),
	                 'remarks' =>$this->input->post('remarks'),
	                'status' => 1,
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $insert = $this->mainmodel->common_insert('vendors',$data);
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Vendor details added successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry,Vendor name already exists."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	}
	public function edit_vendor($id)
	{
	    $url_param = rtrim($id, '=');
        // and later:
        $base_64 = $url_param . str_repeat('=', strlen($url_param) % 4);
        $id = base64_decode($base_64);
        $data['vendor'] = $this->mainmodel->common_fetch('vendors',array('id' => $id));
	        $this->load->view('includes/header');
		    $this->load->view('edit_vendor',$data);
	    	$this->load->view('includes/footer');
	}
	public function update_vendor_details()
	{
	    $vendor_id = $this->input->post('vendor_id');
	    $company_name = $this->input->post('company_name');
	    $school_id = $this->session->userdata('school_id');
	    $category = $this->input->post('category');
	    $gst_no = $this->input->post('gst_no');
	   
	   // echo $class_name.$school_id.$class_section.$session;exit;
	    if(!empty($company_name) && !empty($school_id) && !empty($category) && !empty($gst_no)){
	        $checkschool  = $this->mainmodel->common_fetch('vendors',array('company_name' => $company_name, 'school_id' =>$school_id,
	        'category' => $category, 'gst_no' =>$gst_no )); 
	    //  $variant_values =  implode(',',$variant_values);
	        if(!empty($vendor_id) && $vendor_id > 0){
	            $data = array(
	                'school_id' => $school_id,
	                 'company_name' =>$this->input->post('company_name'),
	                 'gst_no' =>$this->input->post('gst_no'),
	                 'category' =>$this->input->post('category'),
	                 'address' =>$this->input->post('address'),
	                 'contact_person_name' =>$this->input->post('contact_person_name'),
	                 'contact_person_mobile' =>$this->input->post('contact_person_mobile'),
	                 'contact_person_email' =>$this->input->post('contact_person_email'),
	                 'account_name' =>$this->input->post('account_name'),
	                 'ifsc_code' =>$this->input->post('ifsc_code'),
	                 'account_number' =>$this->input->post('account_number'),
	                 'remarks' =>$this->input->post('remarks'),
	                'status' => 1,
	                'updated_on' => date('Y-m-d H:i:s')
	                );
	           $update = $this->mainmodel->common_update('vendors',$data,array('id' => $vendor_id));
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Vendor details updated successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Vendor details not updated."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	}
	public function delete_vendor()
	{
	    
        $id = $this->input->post('id');
         $this->mainmodel->common_delete('vendors',array('id' => $id));
        $json_data = array(
	            'status' => true,
	            'message' => "Vendor details deleted."
	            );
	            echo json_encode($json_data);
	}
	public function list_vendors()
	{
	    $this->load->view('includes/header');
		$this->load->view('list_vendors');
		$this->load->view('includes/footer');
	}
	public function all_inventory_vendor_info()
	{
	    $categories = $this->mainmodel->get_all_inventory_vendor_details($_POST);
        $result_count=$this->mainmodel->get_all_inventory_vendor_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	public function add_item()
	{
	    $this->load->view('includes/header');
		$this->load->view('add_item');
		$this->load->view('includes/footer');
	}
	public function add_item_details()
	{
	    $item_name = $this->input->post('item_name');
	    $school_id = $this->session->userdata('school_id');
	    $item_category = $this->input->post('item_category');
	    $sku_no = $this->input->post('sku_no');
	   
	   // echo $class_name.$school_id.$class_section.$session;exit;
	    if(!empty($item_name) && !empty($school_id) && !empty($item_category) && !empty($sku_no)){
	        $checkschool  = $this->mainmodel->common_fetch('inventory_items',array('item_name' => $item_name, 'school_id' =>$school_id,
	        'item_category' => $item_category, 'sku_no' =>$sku_no )); 
	    //  $variant_values =  implode(',',$variant_values);
	        if(empty($checkschool)){
	            $data = array(
	                'school_id' => $school_id,
	                 'item_name' =>$this->input->post('item_name'),
	                 'sku_no' =>$this->input->post('sku_no'),
	                 'item_category' =>$this->input->post('item_category'),
	                 'quantity' =>$this->input->post('quantity'),
	                 'cost_price' =>$this->input->post('cost_price'),
	                 'sale_price' =>$this->input->post('sale_price'),
	                 'purchased_date' =>$this->input->post('purchased_date'),
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $insert = $this->mainmodel->common_insert('inventory_items',$data);
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Item details added successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry,Item name already exists."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	}
	public function list_items()
	{
	    $this->load->view('includes/header');
		$this->load->view('list_items');
		$this->load->view('includes/footer');
	}
	public function all_items_info()
	{
	    $categories = $this->mainmodel->get_all_inventory_items_details($_POST);
        $result_count=$this->mainmodel->get_all_inventory_items_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	public function edit_item($id)
	{
	    $url_param = rtrim($id, '=');
        // and later:
        $base_64 = $url_param . str_repeat('=', strlen($url_param) % 4);
        $id = base64_decode($base_64);
        $data['item'] = $this->mainmodel->common_fetch('inventory_items',array('id' => $id));
	        $this->load->view('includes/header');
		    $this->load->view('edit_item',$data);
	    	$this->load->view('includes/footer');
	}
	public function update_item_details()
	{
	    $item_id = $this->input->post('item_id');
	    $item_name = $this->input->post('item_name');
	    $school_id = $this->session->userdata('school_id');
	    $item_category = $this->input->post('item_category');
	    $sku_no = $this->input->post('sku_no');
	   
	   // echo $class_name.$school_id.$class_section.$session;exit;
	    if(!empty($item_name) && !empty($school_id) && !empty($item_category) && !empty($sku_no) && !empty($item_id)){
	       // $checkschool  = $this->mainmodel->common_fetch('inventory_items',array('item_name' => $item_name, 'school_id' =>$school_id,
	       // 'item_category' => $item_category, 'sku_no' =>$sku_no )); 
	    //  $variant_values =  implode(',',$variant_values);
	        if(!empty($item_id)){
	            $data = array(
	                'school_id' => $school_id,
	                 'item_name' =>$this->input->post('item_name'),
	                 'sku_no' =>$this->input->post('sku_no'),
	                 'item_category' =>$this->input->post('item_category'),
	                 'quantity' =>$this->input->post('quantity'),
	                 'cost_price' =>$this->input->post('cost_price'),
	                 'sale_price' =>$this->input->post('sale_price'),
	                 'purchased_date' =>$this->input->post('purchased_date'),
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $update = $this->mainmodel->common_update('inventory_items',$data,array('id' => $item_id));
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Item details updated successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry,Item name already exists."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	}
	/*inventory end */
	
	/*cab start*/
	
	public function add_cab()
	{
	    $data['staff'] = $this->mainmodel->common_fetch('staff',array('school_id' => $this->session->userdata('school_id')));
	    $this->load->view('includes/header');
		$this->load->view('add_cab',$data);
		$this->load->view('includes/footer');
	}
	public function add_cab_details()
	{
	   // echo "<pre>";
	   // print_r($_POST);exit;
	    $cab_name = $this->input->post('cab_name');
	    $school_id = $this->session->userdata('school_id');
	    $vehicle_no = $this->input->post('vehicle_no');
	    $driver_name = $this->input->post('driver_name');
	    $driver_no = $this->input->post('driver_no');
	   
	   // echo $class_name.$school_id.$class_section.$session;exit;
	    if(!empty($cab_name) && !empty($school_id) && !empty($vehicle_no) && !empty($driver_name)){
	        $checkschool  = $this->mainmodel->common_fetch('cabs',array('cab_name' => $cab_name, 'school_id' =>$school_id,
	        'vehicle_no' => $vehicle_no )); 
	    //  $variant_values =  implode(',',$variant_values);
	        if(empty($checkschool)){
	            $data = array(
	                'school_id' => $school_id,
	                 'cab_name' =>$this->input->post('cab_name'),
	                 'vehicle_no' =>$this->input->post('vehicle_no'),
	                 'driver_name' =>$this->input->post('driver_name'),
	                 'driver_no' =>$this->input->post('driver_no'),
	                 'description' =>$this->input->post('description'),
	                 'assigned_user' =>$this->input->post('assigned_user'),
	                 'cab_type' =>$this->input->post('cab_type'),
	                 'status' => 1,
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $insert = $this->mainmodel->common_insert('cabs',$data);
	           if($insert){
	               if(!empty($this->input->post('pickuppoint'))){
	                  $pickuppoint =  $this->input->post('pickuppoint');
	                  $i = 1;
	                  foreach($pickuppoint as $pick){
	                      $data_pick = array(
                        	    'cab_id' => $insert,
                        	    'route_type' => 'pickup',
                        	    'location' => $pick,
                        	    'route_order' => $i,
                        	    'created_on' =>date('Y-m-d H:i:s')
                        	    );
                        	    $this->mainmodel->common_insert('cab_routes',$data_pick);
                        	    $i++;
	                  }
	                   
	               }
	               if(!empty($this->input->post('droppoint'))){
	                    $droppoint =  $this->input->post('droppoint');
	                    $j = 1;
	                  foreach($droppoint as $drop){
	                      $data_drop = array(
                        	    'cab_id' => $insert,
                        	    'route_type' => 'drop',
                        	    'location' => $drop,
                        	    'route_order' => $j,
                        	    'created_on' =>date('Y-m-d H:i:s')
                        	    );
                        	    $this->mainmodel->common_insert('cab_routes',$data_drop);
                        	    $j++;
	                  }
	               }
	               
	               include('phpqrcode/qrlib.php');
                   //$uniq = sprintf('%04d',$insert);
                    $uniqueNumber = time() . rand(1000, 9999);
                    $item = $uniqueNumber;
        	              //  $item = 'HEALTH_CARD_'.$uniq;
                            
                            //print_r($item);
                            
                        	$file = "assets/qrcodes/cab/".''.$item.'.png';
                            //other parameters
                            	$ecc = 'H';
                        	$pixel_size = 10;
                        	
                        	QRcode::png($item, $file, $ecc, $pixel_size);
                        	
                        	$data_qrcode = array(
                        	    'qrcode' => $file,
                        	    'qrcode_id' => $uniqueNumber,
                        	    'updated_on' =>date('Y-m-d H:i:s')
                        	    );
                        	    $update = $this->mainmodel->common_update('cabs',$data_qrcode,array('id' => $insert));
	           }
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Item details added successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry,Item name already exists."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	}
	public function list_cabs()
	{
	    $this->load->view('includes/header');
		$this->load->view('list_cabs');
		$this->load->view('includes/footer');
	}
	public function all_cabs_info()
	{
	    $categories = $this->mainmodel->get_all_cabs_details($_POST);
        $result_count=$this->mainmodel->get_all_cabs_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	public function get_cab_qrcode()
	{
	   if ($_SERVER['REQUEST_METHOD'] === 'POST') 
	    {
	        $cab_id = $this->input->post('id');
	    $get_all_emp = $this->mainmodel->common_fetch('cabs',array('id' => $cab_id));
	    $json_data = array(
	        'status' => true,
	        'message' => "Admission ID generated",
	        'cab_name' => $get_all_emp[0]->cab_name,
	        'qrcode' => base_url().$get_all_emp[0]->qrcode,
	        );
	    }else{
	        $json_data = array(
	        'status' => false,
	        'message' => "Error in Qrcode fetching"
	        );
	    }
	    
	        echo Json_encode($json_data); 
	}
	public function edit_cab($id)
	{
	    $url_param = rtrim($id, '=');
        // and later:
        $base_64 = $url_param . str_repeat('=', strlen($url_param) % 4);
        $id = base64_decode($base_64);
        $data['cab'] = $this->mainmodel->common_fetch('cabs',array('id' => $id));
        $data['cabroutes'] = $this->mainmodel->common_fetch('cab_routes',array('cab_id' => $id));
        $data['staff'] = $this->mainmodel->common_fetch('staff',array('school_id' => $this->session->userdata('school_id')));
	        $this->load->view('includes/header');
		    $this->load->view('edit_cab',$data);
	    	$this->load->view('includes/footer');
	}
	public function update_cab_details()
	{
	   // echo "<pre>";
	   // print_r($_POST);exit;
	   $cab_id = $this->input->post('cab_id');
	    $cab_name = $this->input->post('cab_name');
	    $school_id = $this->session->userdata('school_id');
	    $vehicle_no = $this->input->post('vehicle_no');
	    $driver_name = $this->input->post('driver_name');
	    $driver_no = $this->input->post('driver_no');
	   
	   // echo $class_name.$school_id.$class_section.$session;exit;
	    if(!empty($cab_name) && !empty($school_id) && !empty($vehicle_no) && !empty($driver_name)){
	       // $checkschool  = $this->mainmodel->common_fetch('cabs',array('cab_name' => $cab_name, 'school_id' =>$school_id,
	       // 'vehicle_no' => $vehicle_no )); 
	    //  $variant_values =  implode(',',$variant_values);
	        if(!empty($cab_id) && $cab_id > 0){
	            $data = array(
	                'school_id' => $school_id,
	                 'cab_name' =>$this->input->post('cab_name'),
	                 'vehicle_no' =>$this->input->post('vehicle_no'),
	                 'driver_name' =>$this->input->post('driver_name'),
	                 'driver_no' =>$this->input->post('driver_no'),
	                 'description' =>$this->input->post('description'),
	                 'assigned_user' =>$this->input->post('assigned_user'),
	                 'cab_type' =>$this->input->post('cab_type'),
	                 'status' => 1,
	                'created_on' => date('Y-m-d H:i:s')
	                );
	           $update = $this->mainmodel->common_update('cabs',$data,array('id' => $cab_id));
	           if($update){
	               if(!empty($this->input->post('pickuppoint'))){
	                   $delete = $this->mainmodel->common_delete('cab_routes',array( 'cab_id' => $cab_id,'route_type' => 'pickup'));
	                  $pickuppoint =  $this->input->post('pickuppoint');
	                  $j = 1;
	                  foreach($pickuppoint as $pick){
	                      $data_pick = array(
                        	    'cab_id' => $cab_id,
                        	    'route_type' => 'pickup',
                        	    'location' => $pick,
                        	    'route_order' => $j,
                        	    'created_on' =>date('Y-m-d H:i:s')
                        	    );
                        	    $this->mainmodel->common_insert('cab_routes',$data_pick);
                        	    $j++;
	                  }
	                   
	               }
	               if(!empty($this->input->post('droppoint'))){
	                    $delete = $this->mainmodel->common_delete('cab_routes',array( 'cab_id' => $cab_id,'route_type' => 'drop'));
	                    $droppoint =  $this->input->post('droppoint');
	                    $i = 1;
	                  foreach($droppoint as $drop){
	                      $data_drop = array(
                        	    'cab_id' => $cab_id,
                        	    'route_type' => 'drop',
                        	    'location' => $drop,
                        	    'route_order' => $i,
                        	    'created_on' =>date('Y-m-d H:i:s')
                        	    );
                        	    $this->mainmodel->common_insert('cab_routes',$data_drop);
                        	    $i++;
	                  }
	               }
	               
	               //include('phpqrcode/qrlib.php');
                //   //$uniq = sprintf('%04d',$insert);
                //     $uniqueNumber = time() . rand(1000, 9999);
                //     $item = $uniqueNumber;
        	       //       //  $item = 'HEALTH_CARD_'.$uniq;
                            
                //             //print_r($item);
                            
                //         	$file = "assets/qrcodes/cab/".''.$item.'.png';
                //             //other parameters
                //             	$ecc = 'H';
                //         	$pixel_size = 10;
                        	
                //         	QRcode::png($item, $file, $ecc, $pixel_size);
                        	
                //         	$data_qrcode = array(
                //         	    'qrcode' => $file,
                //         	    'qrcode_id' => $uniqueNumber,
                //         	    'updated_on' =>date('Y-m-d H:i:s')
                //         	    );
                //         	    $update = $this->mainmodel->common_update('cabs',$data_qrcode,array('id' => $insert));
	           }
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Item details added successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry,Item name already exists."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	}
	public function edit_cab_route_students($id)
	{
	     $url_param = rtrim($id, '=');
        // and later:
        $base_64 = $url_param . str_repeat('=', strlen($url_param) % 4);
        $id = base64_decode($base_64);
        $data['cab'] = $this->mainmodel->common_fetch('cabs',array('id' => $id));
        $data['cabroutes'] = $this->mainmodel->common_fetch('cab_routes',array('cab_id' => $id));
        $data['class'] = $this->mainmodel->common_fetch('class',array('school_id' => $this->session->userdata('school_id')));
        $data['cab_students'] = $this->mainmodel->get_all_cab_students($id);
	        $this->load->view('includes/header');
		    $this->load->view('edit_cab_routes',$data);
	    	$this->load->view('includes/footer');
	}
	public function update_cab_route_details()
	{
	    
	   // echo "<pre>";
	   // print_r($_POST);exit;
	   $cab_id = $this->input->post('cab_id');
       $route_ids  = $this->input->post('route_ids');
       $route_order = $this->input->post('route_order');
	        if(!empty($cab_id) && $cab_id > 0){
	            
	                  for($i=0; $i < count($route_ids); $i++){
	                      $data_drop = array(
                        	   // 'cab_id' => $cab_id,
                        	    'route_order' => $route_order[$i],
                        	    'updated_on' =>date('Y-m-d H:i:s')
                        	    );
                        	 $update =    $this->mainmodel->common_update('cab_routes',$data_drop,array('id' => $route_ids[$i]));
                        	 
	                  }
	               
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Cab route order details added successfully."
        	            );
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Cab route order details not updated."
	            );
	        }
	        
	   
	    echo json_encode($json_data);
	
	}
	public function get_all_class_students()
	{
	    if ($_SERVER['REQUEST_METHOD'] === 'POST') 
       {
	    $get_data = $this->mainmodel->common_fetch('students',array('class_id' => $this->input->post('class_id')));
	    if(!empty($get_data)){
	                $option = '<option value="">Select students</option>';
	               foreach($get_data as $row){
	                   $option .= "<option value='".$row->id."'>".$row->student_name."</option>";
	               }
	           }else{
	               $option = "";
	           }
	           
	     $json_data = array(
                    'status' => true,
                    'message' => "options fetched",
                    'values' => $option
                    );
                    echo json_encode($json_data);exit;
       }

	}
	public function update_cab_student_details()
	{
	    
	   // echo "<pre>";
	   // print_r($_POST);exit;
	   $cab_id = $this->input->post('cab_id');
	   $class_id = $this->input->post('class_id');
       $students  = $this->input->post('students');
      
	        if(!empty($cab_id) && $cab_id > 0){
	            
	                  for($i=0; $i < count($students); $i++)
	                  {
	                      $check = $this->mainmodel->common_fetch('cab_students',array('cab_id' => $cab_id,'student_id' => $students[$i]));
	                      if(empty($check)){
	                          $data_drop = array(
                        	    'cab_id' => $cab_id,
                        	    'class_id' => $class_id,
                        	    'student_id' => $students[$i],
                        	    'date' => date('Y-m-d'),
                        	    'created_on' =>date('Y-m-d H:i:s')
                        	    );
                        	 $update =    $this->mainmodel->common_insert('cab_students',$data_drop);
	                      } 
	                  }
	               
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Cab student details added successfully."
        	            );
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Cab route order details not updated."
	            );
	        }
	        
	   
	    echo json_encode($json_data);
	
	}
	public function delete_cab()
	{
	    $id = $this->input->post('id');
         $this->mainmodel->common_delete('cabs',array('id' => $id));
        $json_data = array(
	            'status' => true,
	            'message' => "Cab details deleted."
	            );
	            echo json_encode($json_data);
	}
	public function delete_cab_student()
	{
	    $id = $this->input->post('id');
         $this->mainmodel->common_delete('cab_students',array('id' => $id));
        $json_data = array(
	            'status' => true,
	            'message' => "Student details deleted from cab."
	            );
	            echo json_encode($json_data);
	}
	
	/*cab end */
	
	/*messages start*/
	public function compose_message()
	{
	    $data['classes'] = $this->mainmodel->common_fetch('class',array('school_id' => $this->session->userdata('school_id'), 'status' => 1, 'delete_status' => 1));
	    $data['students'] = $this->mainmodel->common_fetch('students',array('school_id' => $this->session->userdata('school_id'), 'status' => 1, 'delete_status' => 1));
	    $data['staff'] = $this->mainmodel->common_fetch('staff',array('school_id' => $this->session->userdata('school_id'), 'status' => 1, 'delete_status' => 1));
	    $this->load->view('includes/header');
		$this->load->view('compose_message',$data);
		$this->load->view('includes/footer');
	}
	public function add_new_message()
	{
	   // echo "<pre>";
	   // print_r($_POST);
	  //  print_r($_FILES);
	  //  exit;
	    $to_class  = implode(",",$this->input->post('classes'));
	    if($this->input->post('students') != ''){
	        $to_student  = implode(",",$this->input->post('students'));
	    }else{$to_student = '';}
	    
	    if($this->input->post('users') != ''){
	        $to_staff  = implode(",",$this->input->post('users'));
	    }else{$to_staff = '';}
	    
	    if($this->input->post('groups') != ''){
	       $to_group  = implode(",",$this->input->post('groups'));
	    }else{$to_group = '';}
         
         
         
	    $school_id = $this->session->userdata('school_id');
	    
	   
	   // echo $class_name.$school_id.$class_section.$session;exit;
	    if(!empty($to_class) && !empty($school_id)){
	       // $checkschool  = $this->mainmodel->common_fetch('vendors',array('company_name' => $company_name, 'school_id' =>$school_id,
	       // 'category' => $category, 'gst_no' =>$gst_no )); 
	        
	        $this->load->library('upload');
	        // Configuration for file uploads
$config['upload_path']   = 'assets/documents/attachments/'; // Specify the upload directory
$config['allowed_types'] = 'pdf|doc|docx|jpg|png'; // Allowed file types
$config['max_size']      = 2048; // Maximum file size in KB (e.g., 2MB)


	        $attachments = '';
	        $files = $_FILES['attachments'];
	        
	        	   // print_r($files);
           foreach ($files['name'] as $key => $file_name) {
               
               if ($files['name'][$key] == "") {
        continue;
    }
               
               // Create a file array for the current file
    $_FILES['single_file']['name']     = $files['name'][$key];
    $_FILES['single_file']['type']     = $files['type'][$key];
    $_FILES['single_file']['tmp_name'] = $files['tmp_name'][$key];
    $_FILES['single_file']['error']    = $files['error'][$key];
    $_FILES['single_file']['size']     = $files['size'][$key];


        
	        // if(!empty($file)){
	              //  $config['upload_path']          = 'assets/documents/attachments/';
            	//	$config['allowed_types']        = 'jpg|png|gif|jpeg|webp|pdf';
            	//	$config['max_size']             = 2000;
            		$this->upload->initialize($config);
            	//	$this->load->library('upload', $config);
            		if($this->upload->do_upload('single_file')){
            			$imgdata = $this->upload->data();
            		//	echo "<pre>";print_r($imgdata);
            			$student_image = 'assets/documents/attachments/'.$imgdata['file_name'];
            		}else{
            		   // echo $this->upload->display_errors();
            			$student_image = '';
            		}
	          //  }else{
	          ///      	$student_image = '';
	         //   }
	         if(empty($attachments)){
	             $attachments = $student_image;
	         }else if(!empty($student_image)){
	                $attachments = $attachments.','.$student_image;
	            }
	           
         }
         
         
         if($this->input->post('disable_replies') == "yes"){
	                $disable_replies = "yes";
	            }else{ $disable_replies = "no"; }
	            if(!empty($this->input->post('schedule_date')) && !empty($this->input->post('schedule_time'))){
	               $message_type = "scheduled";
	            }else{
	                $message_type = "normal";
	            }
         
	    //  $variant_values =  implode(',',$variant_values);
	        if(!empty($to_class)){
	            $data = array(
	                'school_id' => $school_id,
	                'date' => date('Y-m-d'),
	                 'from' =>$this->session->userdata('admin_id'),
	                 'sent_from' =>"school_admin",
	                 'to_class' =>$to_class,
	                 'to_student' =>$to_student,
	                 'to_staff' =>$to_staff,
	                 'to_group' =>$to_group,
	                 'message_type' =>$message_type,
	                 'schedule_date' =>$this->input->post('schedule_date'),
	                 'schedule_time' =>$this->input->post('schedule_time'),
	                 'disable_replies' =>$disable_replies,
	                 'subject' =>$this->input->post('subject'),
	                 'message' =>$this->input->post('message'),
	                 'attachments' =>$attachments,
	                 'message_status' =>"sent",
	               // 'status' => 1,
	                'created_on' => date('Y-m-d H:i:s')
	                );
	               // print_r($data);
	           $insert = $this->mainmodel->common_insert('messages',$data);
	         
	                   $json_data = array(
        	            'status' => true,
        	            'message' => "Message details added successfully."
        	            );
	                   
	          
	            
	        }else{
	             $json_data = array(
	            'status' => false,
	            'message' => "Duplicate entry,Vendor name already exists."
	            );
	        }
	        
	    }else{
	        $json_data = array(
	            'status' => false,
	            'message' => "Please fill all the required fileds."
	            );
	    }
	    echo json_encode($json_data);
	}
	
	public function sent_messages()
	{
	    $_POST = array();
	    $data['sent_messages'] = $this->mainmodel->get_all_sent_messages_details($_POST);
	    $this->load->view('includes/header');
		$this->load->view('sent_messages',$data);
		$this->load->view('includes/footer');
	}
	public function all_sent_messages_info()
	{
	   // echo "<pre>";
	   // print_r($_POST);exit;
	    $data['sent_messages'] =  $this->mainmodel->get_all_sent_messages_details($_POST);
       
        
         
	        //$this->load->view('includes/header');
		$this->load->view('ajax_sent_messages_details',$data);
		
		//$this->load->view('includes/footer');
	   // }
	}
	public function view_sent_message($id)
	{
	     $url_param = rtrim($id, '=');
        // and later:
        $base_64 = $url_param . str_repeat('=', strlen($url_param) % 4);
        $id = base64_decode($base_64);
        
        $data['view_message'] = $this->mainmodel->get_single_sent_message($id);
	    $this->load->view('includes/header');
		$this->load->view('view_sent_message_details',$data);
		$this->load->view('includes/footer');
	}
	
	public function scheduled_messages()
	{
	    $_POST = array();
	    $data['sent_messages'] = $this->mainmodel->get_all_scheduled_messages_details($_POST);
	    // echo "<pre>";
	   //  echo $this->db->last_query();exit;
	   // print_r($_POST);exit;
	    $this->load->view('includes/header');
		$this->load->view('scheduled_messages',$data);
		$this->load->view('includes/footer');
	}
	public function all_scheduled_messages_info()
	{
	   // echo "<pre>";
	   // print_r($_POST);exit;
	    $data['sent_messages'] =  $this->mainmodel->get_all_scheduled_messages_details($_POST);
       
        
         
	        //$this->load->view('includes/header');
		$this->load->view('ajax_scheduled_messages_details',$data);
		
		//$this->load->view('includes/footer');
	   // }
	}
// 	public function view_sent_message($id)
// 	{
// 	     $url_param = rtrim($id, '=');
//         // and later:
//         $base_64 = $url_param . str_repeat('=', strlen($url_param) % 4);
//         $id = base64_decode($base_64);
        
//         $data['view_message'] = $this->mainmodel->get_single_sent_message($id);
// 	    $this->load->view('includes/header');
// 		$this->load->view('view_sent_message_details',$data);
// 		$this->load->view('includes/footer');
// 	}
	
	/*messages end*/
	
	/*gate pass start*/
	public function create_gatepasses()
	{
	    $data['students'] = $this->mainmodel->common_fetch('students',array('status' => 1, 'delete_status' => 1));
	    $this->load->view('includes/header');
		$this->load->view('add_gate_passes',$data);
		$this->load->view('includes/footer');
	}
	public function get_users_details()
	{
	    $searchTerm = $this->input->get('q');
       
        $users = $this->mainmodel->get_users_by_search($searchTerm);

        $data = [];
        foreach ($users as $user) {
            $data[] = ['id' => $user->id, 'text' => $user->student_name.' ('.$user->admission_id.') -'.$user->father_mobile];
        }

        echo json_encode($data);
	}
	public function get_gatepass_details_of_student()
	{
	   // echo $this->input->post('student_id');exit;
	    $student_id = '';
	       $student_id = isset($student_id) ? $this->input->post('student_id') : '';
	    $student_id = $this->input->post('student_id');
	   // if(!empty($student_id) && $student_id > 0)
	    {
	     $data['students'] = $this->mainmodel->get_all_students_data_for_gatepass($student_id);
	   //  echo $this->db->last_query();exit;
	     $this->load->view('ajax_admin_card_data',$data);
	    }
	}
		public function list_gate_passes()
	{
	    $this->load->view('includes/header');
		$this->load->view('list_gate_passes');
		$this->load->view('includes/footer');
	}
	public function all_gatepasses_info()
	{
	    $categories = $this->mainmodel->get_all_gate_passes_details($_POST);
        $result_count=$this->mainmodel->get_all_gate_passes_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	public function get_gatepass_otp()
	{
	    $mobile = '';
	       $mobile = isset($mobile) ? $this->input->post('mobile') : '';
	      // $checkmobile = $this->mainmodel->common_fetch('students',);
	       if($mobile > 0){
	           $otp = rand(1000,9999);
	           $json_data = array(
	               'status' => true,
	               'otp' => $otp
	               );
	           
	       }else{
	            $json_data = array(
	               'status' => false,
	               'otp' => ''
	               );
	              
	       }
	        echo json_encode($json_data);exit;
	}
	
	public function add_gatepass_details()
	{
	 //   echo "<pre>";
	    // print_r($_FILES);
	  //  print_r($_POST);exit;
	    
	    if ($_SERVER['REQUEST_METHOD'] === 'POST') 
	    {
	        if (!empty($imageData)) {
            // Decode the base64 image
            $image = str_replace('data:image/png;base64,', '', $imageData);
            $image = str_replace(' ', '+', $image);
            $decodedImage = base64_decode($image);

            // Save the image
            $fileName = 'assets/images/gatepass/captured_image_' . time() . '.png';
            file_put_contents($fileName, $decodedImage);
            $image = $fileName;
            //echo "Image saved successfully: " . base_url($fileName);
            } else {
                //echo "No image data received.";
                $image = '';
            }
            
            $data = array(
                'school_id' => $this->session->userdata('school_id'),
                'student_id' => $this->input->post('student_id'),
                'visitor_image' => $image,
                'visitor_name' => $this->input->post('visitor_name'),
                'visitor_mobile' => $this->input->post('visitor_mobile'),
                'relation_with_child' => $this->input->post('relation_with_child'),
                'purpose' => $this->input->post('purpose'),
                'remarks' => $this->input->post('remarks'),
                'otp_sent_to' => $this->input->post('relation_with_child'),
                'picked_datetime' => date('Y-m-d H:i:s'),
                'created_on' => date('Y-m-d H:i:s')
                );
                $insert = $this->mainmodel->common_insert('gate_passes',$data);
                $json_data = array(
                    'status' => true,
                    'message' => "Gatepass created successfully"
                    );
            
	    }else{
	         $json_data = array(
                    'status' => false,
                    'message' => "Gatepass not created"
                    );
	    }
	    echo json_encode($json_data);exit;
	}
	/*gate pass end*/
	
	/*visitors start*/
	
		public function list_visitors()
	{
	    $this->load->view('includes/header');
		$this->load->view('list_visitors');
		$this->load->view('includes/footer');
	}
	public function all_visitors_info()
	{
	    $categories = $this->mainmodel->get_all_visitors_details($_POST);
        $result_count=$this->mainmodel->get_all_visitors_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}

	/*visitors end*/
	
		/*expenses start*/
	
		public function list_expenses()
	{
	    $data['vendors'] = $this->mainmodel->common_fetch('vendors',array('school_id' => $this->session->userdata('school_id')));
	    $this->load->view('includes/header');
		$this->load->view('list_expenses',$data);
		$this->load->view('includes/footer');
	}
	public function all_expenses_info()
	{
	    $categories = $this->mainmodel->get_all_expenses_details($_POST);
        $result_count=$this->mainmodel->get_all_expenses_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	public function add_expense()
	{
	    $data['vendors'] = $this->mainmodel->common_fetch('vendors',array('school_id' => $this->session->userdata('school_id')));
	    $this->load->view('includes/header');
		$this->load->view('add_expense',$data);
		$this->load->view('includes/footer');
	}
	public function add_expense_details()
	{
	     //   echo "<pre>";
	    // print_r($_FILES);
	  //  print_r($_POST);exit;
	    $this->load->library('upload');
	    if ($_SERVER['REQUEST_METHOD'] === 'POST') 
	    {
	            if(!empty($_FILES['invoice']['name'])){
	                $config2['upload_path']          = 'assets/documents/invoices/';
            		$config2['allowed_types']        = 'jpg|png|gif|jpeg|webp|pdf';
            		$config2['max_size']             = 10000;
            		$this->upload->initialize($config2);
            		$this->load->library('upload', $config2);
            		if($this->upload->do_upload('invoice')){
            			$imgdata2 = $this->upload->data();
            			$invoice = 'assets/documents/invoices/'.$imgdata2['file_name'];
            		}else{
            		echo    $this->upload->display_errors();
            			$invoice = '';
            		}
	            }else{
	                	$invoice = '';
	            }
	            if($this->input->post('payment_status') == "paid"){
	                $payment_status = "paid";
	            }else{ $payment_status = "unpaid"; }
            
            $data = array(
                'school_id' => $this->session->userdata('school_id'),
                'expense_no' => $this->input->post('admission_id'),
                'invoice_no' => $this->input->post('invoice_no'),
                'date_of_expense' => $this->input->post('date_of_expense'),
                'vendor' => $this->input->post('vendor'),
                'expense_category' => $this->input->post('expense_category'),
                'amount_spent' => $this->input->post('amount_spent'),
                'payment_status' => $payment_status,
                'date_of_payment' =>$this->input->post('date_of_payment'),
                 'mode_of_payment' =>$this->input->post('mode_of_payment'),
                  'remarks' =>$this->input->post('remarks'),
                   'invoice' =>$invoice,
                'created_on' => date('Y-m-d H:i:s')
                );
                $insert = $this->mainmodel->common_insert('school_expenses',$data);
                $json_data = array(
                    'status' => true,
                    'message' => "School Expense created successfully"
                    );
            
	    }else{
	         $json_data = array(
                    'status' => false,
                    'message' => "School Expense not created"
                    );
	    }
	    echo json_encode($json_data);exit;
	}
	
	function generate_expense_id()
	{
	    $get_all_emp = $this->mainmodel->common_fetch('school_expenses',array('school_id' => $this->session->userdata('school_id')));
	    $admission_id = 'E'.count($get_all_emp)+1;
	    $json_data = array(
	        'status' => true,
	        'message' => "Expense Number generated",
	        'admission_id' => $admission_id
	        );
	        echo Json_encode($json_data);
	}
	public function edit_expense($id)
	{
	    $url_param = rtrim($id, '=');
        // and later:
        $base_64 = $url_param . str_repeat('=', strlen($url_param) % 4);
        $id = base64_decode($base_64);
        $data['expense'] = $this->mainmodel->common_fetch('school_expenses',array('id' => $id));
	        $this->load->view('includes/header');
		    $this->load->view('edit_expense',$data);
	    	$this->load->view('includes/footer');
	}
	public function update_expense_details()
	{
	     //   echo "<pre>";
	    // print_r($_FILES);
	  //  print_r($_POST);exit;
	    $this->load->library('upload');
	    if ($_SERVER['REQUEST_METHOD'] === 'POST') 
	    {
	            if(!empty($_FILES['invoice']['name'])){
	                $config2['upload_path']          = 'assets/documents/invoices/';
            		$config2['allowed_types']        = 'jpg|png|gif|jpeg|webp|pdf';
            		$config2['max_size']             = 10000;
            		$this->upload->initialize($config2);
            		$this->load->library('upload', $config2);
            		if($this->upload->do_upload('invoice')){
            			$imgdata2 = $this->upload->data();
            			$invoice = 'assets/documents/invoices/'.$imgdata2['file_name'];
            		}else{
            		echo    $this->upload->display_errors();
            			$invoice = $this->input->post('invoice_link');
            		}
	            }else{
	                	$invoice = $this->input->post('invoice_link');
	            }
	            if($this->input->post('payment_status') == "paid"){
	                $payment_status = "paid";
	            }else{ $payment_status = "unpaid"; }
            
            $data = array(
                'school_id' => $this->session->userdata('school_id'),
                'expense_no' => $this->input->post('admission_id'),
                'invoice_no' => $this->input->post('invoice_no'),
                'date_of_expense' => $this->input->post('date_of_expense'),
                'vendor' => $this->input->post('vendor'),
                'expense_category' => $this->input->post('expense_category'),
                'amount_spent' => $this->input->post('amount_spent'),
                'payment_status' => $payment_status,
                'date_of_payment' =>$this->input->post('date_of_payment'),
                 'mode_of_payment' =>$this->input->post('mode_of_payment'),
                  'remarks' =>$this->input->post('remarks'),
                   'invoice' =>$invoice,
                'created_on' => date('Y-m-d H:i:s')
                );
                $update = $this->mainmodel->common_update('school_expenses',$data,array('id' => $this->input->post('expense_id')));
                $json_data = array(
                    'status' => true,
                    'message' => "School Expense Details updated successfully"
                    );
            
	    }else{
	         $json_data = array(
                    'status' => false,
                    'message' => "School Expense not updated"
                    );
	    }
	    echo json_encode($json_data);exit;
	}
	public function delete_expense()
	{
	    
        $id = $this->input->post('id');
         $this->mainmodel->common_delete('school_expenses',array('id' => $id));
        $json_data = array(
	            'status' => true,
	            'message' => "Expense details deleted."
	            );
	            echo json_encode($json_data);
	}

	/*expenses end*/
	
	/*cctv start*/
	
		public function list_cctv()
	{
	    $data['vendors'] = $this->mainmodel->common_fetch('vendors',array('school_id' => $this->session->userdata('school_id')));
	    $this->load->view('includes/header');
		$this->load->view('list_cctv',$data);
		$this->load->view('includes/footer');
	}
	public function all_cctv_info()
	{
	    $categories = $this->mainmodel->get_all_cctv_details($_POST);
        $result_count=$this->mainmodel->get_all_cctv_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	public function add_cctv()
	{
	    $data['vendors'] = $this->mainmodel->common_fetch('vendors',array('school_id' => $this->session->userdata('school_id')));
	    $this->load->view('includes/header');
		$this->load->view('add_cctv',$data);
		$this->load->view('includes/footer');
	}
	public function add_cctv_details()
	{
	     //   echo "<pre>";
	    // print_r($_FILES);
	  //  print_r($_POST);exit;
	    $this->load->library('upload');
	    if ($_SERVER['REQUEST_METHOD'] === 'POST') 
	    {
	         $check = $this->mainmodel->common_fetch('cctv',array('camera_name' => $this->input->post('camera_name'),'school_id' => $this->session->userdata('school_id')));
	       if(empty($check)){
    	           $data = array(
                    'school_id' => $this->session->userdata('school_id'),
                    'camera_name' => $this->input->post('camera_name'),
                    'camera_stream' => $this->input->post('camera_stream'),
                    'start_time' => $this->input->post('start_time'),
                    'end_time' => $this->input->post('end_time'),
                    'camera_attached_type' => $this->input->post('camera_attached_type'),
                    'camera_attached_area' => $this->input->post('camera_attached_area'),
                    'status' => '1',
                    'created_on' => date('Y-m-d H:i:s')
                    );
                    $insert = $this->mainmodel->common_insert('cctv',$data);
                    $json_data = array(
                        'status' => true,
                        'message' => "CCTV created successfully"
                        );
	       }else{
	            $json_data = array(
                    'status' => false,
                    'message' => "cctv with same already exist"
                    );
	       }
            
            
	    }else{
	         $json_data = array(
                    'status' => false,
                    'message' => "CCTV not created"
                    );
	    }
	    echo json_encode($json_data);exit;
	}
	public function edit_cctv($id)
	{
	    $url_param = rtrim($id, '=');
        // and later:
        $base_64 = $url_param . str_repeat('=', strlen($url_param) % 4);
        $id = base64_decode($base_64);
        $data['cctv'] = $this->mainmodel->common_fetch('cctv',array('id' => $id));
	        $this->load->view('includes/header');
		    $this->load->view('edit_cctv',$data);
	    	$this->load->view('includes/footer');
	 
	}
	public function update_cctv_details()
	{
	     //   echo "<pre>";
	    // print_r($_FILES);
	  //  print_r($_POST);exit;
	    $this->load->library('upload');
	    $cctv_id = $this->input->post('cctv_id');
	    if ($_SERVER['REQUEST_METHOD'] === 'POST') 
	    {
	         //$check = $this->mainmodel->common_fetch('cctv',array('camera_name' => $this->input->post('camera_name'),'school_id' => $this->session->userdata('school_id')));
	       if(!empty($cctv_id) && $cctv_id > 0){
    	           $data = array(
                    'school_id' => $this->session->userdata('school_id'),
                    'camera_name' => $this->input->post('camera_name'),
                    'camera_stream' => $this->input->post('camera_stream'),
                    'start_time' => $this->input->post('start_time'),
                    'end_time' => $this->input->post('end_time'),
                    'camera_attached_type' => $this->input->post('camera_attached_type'),
                    'camera_attached_area' => $this->input->post('camera_attached_area'),
                    'status' => '1',
                    'updated_on' => date('Y-m-d H:i:s')
                    );
                    $insert = $this->mainmodel->common_update('cctv',$data,array('id' => $cctv_id));
                    $json_data = array(
                        'status' => true,
                        'message' => "CCTV updated successfully"
                        );
	       }else{
	            $json_data = array(
                    'status' => false,
                    'message' => "cctv not updated"
                    );
	       }
            
            
	    }else{
	         $json_data = array(
                    'status' => false,
                    'message' => "CCTV not updated"
                    );
	    }
	    echo json_encode($json_data);exit;
	}
	public function delete_cctv()
	{
	    
        $id = $this->input->post('id');
         $this->mainmodel->common_delete('cctv',array('id' => $id));
        $json_data = array(
	            'status' => true,
	            'message' => "Inventory variant deleted."
	            );
	            echo json_encode($json_data);
	}
	
	public function add_common_area()
	{
	    $data['vendors'] = $this->mainmodel->common_fetch('vendors',array('school_id' => $this->session->userdata('school_id')));
	    $this->load->view('includes/header');
		$this->load->view('add_common_area',$data);
		$this->load->view('includes/footer');
	}
	public function add_common_area_details()
	{
	     //   echo "<pre>";
	    // print_r($_FILES);
	  //  print_r($_POST);exit;
	    $this->load->library('upload');
	    if ($_SERVER['REQUEST_METHOD'] === 'POST') 
	    {
	        $check = $this->mainmodel->common_fetch('common_area',array('area_name' => $this->input->post('area_name'),'school_id' => $this->session->userdata('school_id')));
           
           if(empty($check)){
               $data = array(
                'school_id' => $this->session->userdata('school_id'),
                'area_name' => $this->input->post('area_name'),
                'description' => $this->input->post('description'),
                'created_on' => date('Y-m-d H:i:s')
                );
                $insert = $this->mainmodel->common_insert('common_area',$data);
                $json_data = array(
                    'status' => true,
                    'message' => "Common Area created successfully"
                    );
           }else{
             $json_data = array(
                    'status' => false,
                    'message' => "Common Area with same name already exist"
                    );  
           }
            
	    }else{
	         $json_data = array(
                    'status' => false,
                    'message' => "Common Area not created"
                    );
	    }
	    echo json_encode($json_data);exit;
	}
	public function get_all_options_to_dropdown()
	{
	    if ($_SERVER['REQUEST_METHOD'] === 'POST') 
	    {
	       $dropoption = $this->input->post('dropoption');
	      
	       if($dropoption == "class"){
	           $get = $this->mainmodel->common_fetch('class',array('school_id' => $this->session->userdata('school_id') ,'status' => 1 ,'delete_status' => 1));
	           if(!empty($get)){
	                $option = '<option value="">Select a option</option>';
	               foreach($get as $row){
	                   $option .= "<option value='".$row->id."'>".$row->class_name." - ".$row->class_section."</option>";
	               }
	           }
	       }else if($dropoption == "group"){
	           $get = array();
	           $option = '';
	       }else if($dropoption == "commonarea"){
	           $get = $this->mainmodel->common_fetch('common_area',array('school_id' => $this->session->userdata('school_id'),'delete_status' => 1));
	            if(!empty($get)){
	             $option = '<option value="">Select a option</option>';
	               foreach($get as $row){
	                   $option .= "<option value='".$row->id."'>".$row->area_name."</option>";
	               }
	       }
	       
	    }
	    
	     $json_data = array(
                    'status' => true,
                    'message' => "options fetched",
                    'values' => $option
                    );
                    echo json_encode($json_data);exit;
	    }
	}
	
	
	
	/*cctv end */
	
	/*library start*/
	
	public function list_books()
	{
	    $data['vendors'] = $this->mainmodel->common_fetch('vendors',array('school_id' => $this->session->userdata('school_id')));
	    $this->load->view('includes/header');
		$this->load->view('list_books',$data);
		$this->load->view('includes/footer');
	}
	public function all_books_info()
	{
	   // echo "<pre>";
	   // print_r($_POST);exit;
	    $categories = $this->mainmodel->get_all_books_details($_POST);
        $result_count=$this->mainmodel->get_all_books_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	public function add_book()
	{
	    $data['vendors'] = $this->mainmodel->common_fetch('vendors',array('school_id' => $this->session->userdata('school_id')));
	    $this->load->view('includes/header');
		$this->load->view('add_book',$data);
		$this->load->view('includes/footer');
	}
	public function add_book_details()
	{
	     //   echo "<pre>";
	    // print_r($_FILES);
	  //  print_r($_POST);exit;
	    $this->load->library('upload');
	    if ($_SERVER['REQUEST_METHOD'] === 'POST') 
	    {
	         $check = $this->mainmodel->common_fetch('school_books',array('book_name' => $this->input->post('book_name'),'school_id' => $this->session->userdata('school_id')));
	       if(empty($check)){
    	           $data = array(
                    'school_id' => $this->session->userdata('school_id'),
                    'accession_id' => $this->input->post('accession_id'),
                    'book_name' => $this->input->post('book_name'),
                    'author_name' => $this->input->post('author_name'),
                    'publisher_name' => $this->input->post('publisher_name'),
                    'category' => $this->input->post('category'),
                    'subject' => $this->input->post('subject'),
                    'year_of_publication' => $this->input->post('year_of_publication'),
                    'received_date' => $this->input->post('received_date'),
                    'isbn_no' => $this->input->post('isbn_no'),
                    'ddc_no' => $this->input->post('ddc_no'),
                    'volume' => $this->input->post('volume'),
                    'cost' => $this->input->post('cost'),
                    'shelf_rack_position' => $this->input->post('shelf_rack_position'),
                    'vendor' => $this->input->post('vendor'),
                    'ordered_date' => $this->input->post('ordered_date'),
                    'purchasing_date' => $this->input->post('purchasing_date'),
                    'pages' => $this->input->post('pages'),
                    'remarks' => $this->input->post('remarks'),
                    'status' => 'not issued',
                    'added_date' => date('Y-m-d'),
                    'created_on' => date('Y-m-d H:i:s')
                    );
                    $insert = $this->mainmodel->common_insert('school_books',$data);
                    $json_data = array(
                        'status' => true,
                        'message' => "Book created successfully"
                        );
	       }else{
	            $json_data = array(
                    'status' => false,
                    'message' => "Book with same name already exist"
                    );
	       }
            
            
	    }else{
	         $json_data = array(
                    'status' => false,
                    'message' => "Book not created"
                    );
	    }
	    echo json_encode($json_data);exit;
	}
	public function edit_book($id)
	{
	    $url_param = rtrim($id, '=');
        // and later:
        $base_64 = $url_param . str_repeat('=', strlen($url_param) % 4);
        $id = base64_decode($base_64);
        $data['book'] = $this->mainmodel->common_fetch('school_books',array('id' => $id));
	        $this->load->view('includes/header');
		    $this->load->view('edit_book',$data);
	    	$this->load->view('includes/footer');
	}
	public function update_book_details()
	{
	    $book_id = $this->input->post('book_id');
	    
	    if ($_SERVER['REQUEST_METHOD'] === 'POST') 
	    {
	        // $check = $this->mainmodel->common_fetch('school_books',array('book_name' => $this->input->post('book_name'),'school_id' => $this->session->userdata('school_id')));
	       if(!empty($book_id) && $book_id > 0){
    	           $data = array(
                    'school_id' => $this->session->userdata('school_id'),
                    'accession_id' => $this->input->post('accession_id'),
                    'book_name' => $this->input->post('book_name'),
                    'author_name' => $this->input->post('author_name'),
                    'publisher_name' => $this->input->post('publisher_name'),
                    'category' => $this->input->post('category'),
                    'subject' => $this->input->post('subject'),
                    'year_of_publication' => $this->input->post('year_of_publication'),
                    'received_date' => $this->input->post('received_date'),
                    'isbn_no' => $this->input->post('isbn_no'),
                    'ddc_no' => $this->input->post('ddc_no'),
                    'volume' => $this->input->post('volume'),
                    'cost' => $this->input->post('cost'),
                    'shelf_rack_position' => $this->input->post('shelf_rack_position'),
                    'vendor' => $this->input->post('vendor'),
                    'ordered_date' => $this->input->post('ordered_date'),
                    'purchasing_date' => $this->input->post('purchasing_date'),
                    'pages' => $this->input->post('pages'),
                    'remarks' => $this->input->post('remarks'),
                    //'status' => 'not issued',
                    'added_date' => date('Y-m-d'),
                    'updated_on' => date('Y-m-d H:i:s')
                    );
                    $insert = $this->mainmodel->common_update('school_books',$data,array('id' => $book_id));
                    $json_data = array(
                        'status' => true,
                        'message' => "Book Details Updated successfully"
                        );
	       }else{
	            $json_data = array(
                    'status' => false,
                    'message' => "Book Details not updated"
                    );
	       }
            
            
	    }else{
	         $json_data = array(
                    'status' => false,
                    'message' => "Book Details not updated"
                    );
	    }
	    echo json_encode($json_data);exit;
	   
	}
	function generate_accession_id()
	{
	    $get_all_emp = $this->mainmodel->common_fetch('school_books',array('school_id' => $this->session->userdata('school_id')));
	    $accession_id = 'LIB/'.count($get_all_emp)+1;
	    $json_data = array(
	        'status' => true,
	        'message' => "Accession ID generated",
	        'accession_id' => $accession_id
	        );
	        echo Json_encode($json_data);
	}
	
	
	
	/*library start*/
	
	/*albmus start */
	public function list_albums()
	{
	    $data['classes'] = $this->mainmodel->common_fetch('class',array('school_id' => $this->session->userdata('school_id')));
	    $this->load->view('includes/header');
		$this->load->view('list_albums',$data);
		$this->load->view('includes/footer');
	}

    public function load_filtered_data() {
        $limit = $this->input->get('limit');
        $offset = $this->input->get('offset');
        $filters = [
            'search' => $this->input->get('search')
        ];

        
        $data = $this->mainmodel->get_filtered_data($limit, $offset, $filters);

        echo json_encode($data);
    }


	public function add_album()
	{
	    $data['classes'] = $this->mainmodel->common_fetch('class',array('school_id' => $this->session->userdata('school_id')));
	    $this->load->view('includes/header');
		$this->load->view('add_album',$data);
		$this->load->view('includes/footer');
	}
	public function add_album_details()
	{
	   // echo "<pre>";
	   // print_r($_POST);
	   // print_r($_FILES);exit;
	   
	   
	    
	    $this->load->library('upload');
	    $uploadedFiles = [
        'images' => [],
        'videos' => []
        ];
        
       $type = $this->input->post('type');
       if($type == "Public"){
           $classes = '';
       }else{
           if(!empty($this->input->post('class'))){
               $classes = implode(",",$this->input->post('class'));
           }else{
               $classes = '';
           }
           
       }
        if($this->input->post('albumquota') == "yes"){
            $albumquota = "yes";
        }else{ $albumquota = "no"; }
        
        if($this->input->post('imagecheck') == "yes"){
            $album_type = "image";
        }else if($this->input->post('videocheck') == "yes"){
            $album_type = "video";
        }
       // if(!empty($type) && !empty($album_type))
        {
            
            $data = array(
                'school_id' => $this->session->userdata('school_id'), 
                'type' => $type,
                'classes' => $classes,
                'title' => $this->input->post('title'),
                'description' => $this->input->post('description'),
                'album_type' => $album_type,
                'tag_album' => $albumquota,
                'created_on' => date('Y-m-d H:i:s')
                );
            //     echo "<pre>";
            // print_r($data);exit;
            $insert = $this->mainmodel->common_insert('albums',$data);
            if($insert){
                // Handle images (if any)
                if (!empty($_FILES['images']['name'])) {
                    $files = $_FILES['images'];
                    for ($i = 0; $i < count($files['name']); $i++) {
                        $_FILES['image']['name'] = $files['name'][$i];
                        $_FILES['image']['type'] = $files['type'][$i];
                        $_FILES['image']['tmp_name'] = $files['tmp_name'][$i];
                        $_FILES['image']['error'] = $files['error'][$i];
                        $_FILES['image']['size'] = $files['size'][$i];
            
                        $config['upload_path'] = 'assets/albums/images/';
                        $config['allowed_types'] = 'jpg|jpeg|png|gif';
                        $config['max_size'] = 2048; // 2 MB
                        $config['file_name'] = time() . '_' . $files['name'][$i];
            
                        $this->upload->initialize($config);
            
                        if ($this->upload->do_upload('image')) {
                           // $uploadedFiles['images'][] = $this->upload->data();
                            $imgdata2 = $this->upload->data();
                    			$imageadded = 'assets/albums/images/'.$imgdata2['file_name'];
                    			$dataimage = array(
                    			    'album_id' => $insert,
                    			    'file_name' => $imageadded,
                    			    'created_on' => date('Y-m-d H:i:s')
                    			    );
                    			$insertimage = $this->mainmodel->common_insert('album_content',$dataimage);
                    			    
                        }else{
                            $imageadded = '';
                        }
                    }
                }

               // Handle videos (if any)
                if (!empty($_FILES['videos']['name'])) {
                    $files = $_FILES['videos'];
                    for ($i = 0; $i < count($files['name']); $i++) {
                        $_FILES['video']['name'] = $files['name'][$i];
                        $_FILES['video']['type'] = $files['type'][$i];
                        $_FILES['video']['tmp_name'] = $files['tmp_name'][$i];
                        $_FILES['video']['error'] = $files['error'][$i];
                        $_FILES['video']['size'] = $files['size'][$i];
            
                        $config['upload_path'] = 'assets/albums/videos/';
                        $config['allowed_types'] = 'mp4|mov|avi|mkv';
                        $config['max_size'] = 50480; // 20 MB
                        $config['file_name'] = time() . '_' . $files['name'][$i];
            
                        $this->upload->initialize($config);
            
                        if ($this->upload->do_upload('video')) {
                            //$uploadedFiles['videos'][] = $this->upload->data();
                            $imgdata2 = $this->upload->data();
                    			$videoadded = 'assets/albums/videos/'.$imgdata2['file_name'];
                    			$datavideo = array(
                    			    'album_id' => $insert,
                    			    'file_name' => $videoadded,
                    			    'created_on' => date('Y-m-d H:i:s')
                    			    );
                    			$insertimage = $this->mainmodel->common_insert('album_content',$datavideo);
                        }else{
                            $videoadded = '';
                        }
                    }
                }
                
             $json_data = array(
	        'status' => true,
	        'message' => "Album added successfully."
	        
	        );
	        echo Json_encode($json_data);
                
            }else{
                $json_data = array(
	        'status' => false,
	        'message' => "Album not added successfully."
	        
	        );
	        echo Json_encode($json_data);
            }
            
          
            
            
        }
        // else{
        //     $json_data = array(
	       // 'status' => false,
	       // 'message' => "Album not added successfully.please upload any one image or video"
	        
	       // );
	       // echo Json_encode($json_data);
        // }
        
        /*file uploads start*/
        //  if(!empty($_FILES['invoice']['name'])){
	       //         $config2['upload_path']          = 'assets/documents/invoices/';
        //     		$config2['allowed_types']        = 'jpg|png|gif|jpeg|webp|pdf';
        //     		$config2['max_size']             = 10000;
        //     		$this->upload->initialize($config2);
        //     		$this->load->library('upload', $config2);
        //     		if($this->upload->do_upload('invoice')){
        //     			$imgdata2 = $this->upload->data();
        //     			$invoice = 'assets/documents/invoices/'.$imgdata2['file_name'];
        //     		}else{
        //     		echo    $this->upload->display_errors();
        //     			$invoice = '';
        //     		}
	       //     }else{
	       //         	$invoice = '';
	       //     }
	   /*file upload end */
        
        

        // Send response
        
	}
	
	public function edit_album($id)
	{
	    $url_param = rtrim($id, '=');
        // and later:
        $base_64 = $url_param . str_repeat('=', strlen($url_param) % 4);
        $id = base64_decode($base_64);
        $data['album'] = $this->mainmodel->common_fetch('albums',array('id' => $id));
        $data['album_content'] = $this->mainmodel->common_fetch('album_content',array('album_id' => $id));
        $data['classes'] = $this->mainmodel->common_fetch('class',array('school_id' => $this->session->userdata('school_id')));
	        $this->load->view('includes/header');
		    $this->load->view('edit_album',$data);
	    	$this->load->view('includes/footer');
	}
	public function update_album_details()
	{
	   // echo "<pre>";
	   // print_r($_POST);
	   // print_r($_FILES);exit;
	   
	   
	    
	    $this->load->library('upload');
	    $uploadedFiles = [
        'images' => [],
        'videos' => []
        ];
        
       $type = $this->input->post('type');
       if($type == "Public"){
           $classes = '';
       }else{
           if(!empty($this->input->post('class'))){
               $classes = implode(",",$this->input->post('class'));
           }else{
               $classes = '';
           }
           
       }
        if($this->input->post('albumquota') == "yes"){
            $albumquota = "yes";
        }else{ $albumquota = "no"; }
        
        if($this->input->post('imagecheck') == "yes"){
            $album_type = "image";
        }else if($this->input->post('videocheck') == "yes"){
            $album_type = "video";
        }
       // if(!empty($type) && !empty($album_type))
        {
            
            $data = array(
                'school_id' => $this->session->userdata('school_id'), 
                'type' => $type,
                'classes' => $classes,
                'title' => $this->input->post('title'),
                'description' => $this->input->post('description'),
                'album_type' => $album_type,
                'tag_album' => $albumquota,
                'updated_on' => date('Y-m-d H:i:s')
                );
            //     echo "<pre>";
            // print_r($data);exit;
            $update = $this->mainmodel->common_update('albums',$data,array('id' => $this->input->post('album_id')));
            if($update){
                // Handle images (if any)
                if (!empty($_FILES['images']['name'])) {
                    $files = $_FILES['images'];
                    for ($i = 0; $i < count($files['name']); $i++) {
                        $_FILES['image']['name'] = $files['name'][$i];
                        $_FILES['image']['type'] = $files['type'][$i];
                        $_FILES['image']['tmp_name'] = $files['tmp_name'][$i];
                        $_FILES['image']['error'] = $files['error'][$i];
                        $_FILES['image']['size'] = $files['size'][$i];
            
                        $config['upload_path'] = 'assets/albums/images/';
                        $config['allowed_types'] = 'jpg|jpeg|png|gif';
                        $config['max_size'] = 2048; // 2 MB
                        $config['file_name'] = time() . '_' . $files['name'][$i];
            
                        $this->upload->initialize($config);
            
                        if ($this->upload->do_upload('image')) {
                           // $uploadedFiles['images'][] = $this->upload->data();
                            $imgdata2 = $this->upload->data();
                    			$imageadded = 'assets/albums/images/'.$imgdata2['file_name'];
                    			$dataimage = array(
                    			    'album_id' => $this->input->post('album_id'),
                    			    'file_name' => $imageadded,
                    			    'created_on' => date('Y-m-d H:i:s')
                    			    );
                    			$insertimage = $this->mainmodel->common_insert('album_content',$dataimage);
                    			    
                        }else{
                            $imageadded = '';
                        }
                    }
                }

               // Handle videos (if any)
                if (!empty($_FILES['videos']['name'])) {
                    $files = $_FILES['videos'];
                    for ($i = 0; $i < count($files['name']); $i++) {
                        $_FILES['video']['name'] = $files['name'][$i];
                        $_FILES['video']['type'] = $files['type'][$i];
                        $_FILES['video']['tmp_name'] = $files['tmp_name'][$i];
                        $_FILES['video']['error'] = $files['error'][$i];
                        $_FILES['video']['size'] = $files['size'][$i];
            
                        $config['upload_path'] = 'assets/albums/videos/';
                        $config['allowed_types'] = 'mp4|mov|avi|mkv';
                        $config['max_size'] = 50480; // 20 MB
                        $config['file_name'] = time() . '_' . $files['name'][$i];
            
                        $this->upload->initialize($config);
            
                        if ($this->upload->do_upload('video')) {
                            //$uploadedFiles['videos'][] = $this->upload->data();
                            $imgdata2 = $this->upload->data();
                    			$videoadded = 'assets/albums/videos/'.$imgdata2['file_name'];
                    			$datavideo = array(
                    			    'album_id' => $this->input->post('album_id'),
                    			    'file_name' => $videoadded,
                    			    'created_on' => date('Y-m-d H:i:s')
                    			    );
                    			$insertimage = $this->mainmodel->common_insert('album_content',$datavideo);
                        }else{
                            $videoadded = '';
                        }
                    }
                }
                
             $json_data = array(
	        'status' => true,
	        'message' => "Album updated successfully."
	        
	        );
	        echo Json_encode($json_data);
                
            }else{
                $json_data = array(
	        'status' => false,
	        'message' => "Album not updated successfully."
	        
	        );
	        echo Json_encode($json_data);
            }
            
        }
        
        
	}
	
	/* albums end */
	
	/*certificates start*/
	public function list_certificates()
	{
	    $data['students'] = $this->mainmodel->common_fetch('students',array('school_id' => $this->session->userdata('school_id'), 'delete_status' => 1));
	    $this->load->view('includes/header');
		$this->load->view('list_certificates',$data);
		$this->load->view('includes/footer');
	}
	public function get_ceritificates_data()
	{
        $certificate_type = $this->input->post('certificate_type');
        $student_id = $this->input->post('student_id');
        $offset = $this->input->post('offset'); // For pagination
        $limit = 10; // Number of records per request

        $data = $this->mainmodel->fetch_certificates_data($certificate_type, $student_id, $offset, $limit);
        echo json_encode($data);
	}
	public function preview()
	{
	    if ($_SERVER['REQUEST_METHOD'] === 'POST') 
	    {
	       // echo "<pre>";
	       // print_r($_POST);exit;
	       
	        $certificate_type = $this->input->post('certificate_type');
	        $student_id = $this->input->post('student_id');
	        $check_student_cer = $this->mainmodel->common_fetch('student_certificates',array('certificate_type' => $certificate_type,'student_id' => $student_id));
	        if(empty($check_student_cer)){
	            $data = array(
	            'school_id' => $this->session->userdata('school_id'),
	            'student_id' => $student_id,
	            'date' => date('Y-m-d'),
	            'certificate_type' => $certificate_type,
	            'created_on' => date('Y-m-d H:i:s')
	            );
	            $insert = $this->mainmodel->common_insert('student_certificates',$data);
	            if($insert){
	                $fetch = $this->mainmodel->common_fetch('student_certificates',array('id' => $insert));
	                   if($fetch[0]->certificate_type == "transfer")
	                    {
	                        $chcek = $this->mainmodel->common_fetch('tc_certificates',array('student_id' => $student_id));
	                        if(empty($chcek)){
	                            $fetch_student = $this->mainmodel->common_fetch('students',array('id' => $student_id));
	                            $datatc = array(
	                                'school_id' => $this->session->userdata('school_id'),
	                                'student_id' => $student_id,
	                                'certificate_no' => 'TCF-'.time().'-'.rand('100000','999999'),
	                                'student_name' => $fetch_student[0]->student_name,
	                                'admission_id' => $fetch_student[0]->admission_id,
	                                'dob' => $fetch_student[0]->student_dob,
	                                'father_name' => $fetch_student[0]->father_mobile,
	                                'mother_name' => $fetch_student[0]->mother_name,
	                                'last_studied_class' => $fetch_student[0]->class_id,
	                               // 'nationality' => $fetch_student[0]->student_name,
	                            //    'student_caste' => $fetch_student[0]->student_name,
	                             //   'subject_studied' => $fetch_student[0]->student_name,
	                                'joining_date' => $fetch_student[0]->joining_date,
	                              //  'class_joining_time' => $fetch_student[0]->student_name,
	                               // 'fee_concession_type' => $fetch_student[0]->student_name,
	                                'created_on' => date('Y-m-d H:i:s'),
	                                );
	                                $inserttc = $this->mainmodel->common_insert('tc_certificates',$datatc);
	                            
	                        }
	                        $id = base64_encode($insert);
	                       redirect('preview-tc/'.$id);
	                     }
	            }
	        }else{
	            if($check_student_cer[0]->certificate_type == "transfer")
	           {
	               $id = base64_encode($check_student_cer[0]->id);
	                       redirect('preview-tc/'.$id);
	           }
	        }
	        
	            
	        
	    }else{
	        redirect('certificate','refresh');
	    }
	}
	
	public function preview_tc($id)
	{
	    $url_param = rtrim($id, '=');
        // and later:
        $base_64 = $url_param . str_repeat('=', strlen($url_param) % 4);
        $id = base64_decode($base_64);
	    $details = $this->mainmodel->common_fetch('student_certificates',array('id' => $id));
	   // echo "<pre>";
	   // print_r($details);exit;
	    $data['tc'] = $this->mainmodel->common_fetch('tc_certificates',array('student_id' => $details[0]->student_id));
	    $data['details'] = $details;
	    
	    $this->load->view('includes/header');
		$this->load->view('preview_tc',$data);
		$this->load->view('includes/footer');
	}
	
	public function download_tc($id){
    
   // $sess_data = $this->session_data();
    // Load mPDF library
    require_once APPPATH . 'third_party/mpdf/autoload.php';
  // $tc = $this->mainmodel->common_fetch('tc_certificates',array('id' => $id));
	   
	   
        // Create HTML for PDF
        $html = '
           <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
 
 
</head>
<body>
    <div class="container mt-3 border border-1 " style="border:1px solid rgba(0,0,0,0.5);>
        <div class="heading-container"
        style="display:flex;
    justify-content:flex-start;
    align-items:center;
    gap:1rem;>
            <div class="img-logo">
                <img src="./assets/img/fav.png" alt="" style="width:100px;">
            </div>
            <div>
                <h2>Little Pebbles Pre International School </h2>
            <p>Email.: Info@Littlepebbles.Com Website: https://littlepebbles.net/index.html</p>
            </div>
        </div>
        <div class="certificate pt-4 pb-3">
            <h3 class="text-center">Transfer Certificate</h3>
        </div>
        <div class="id-no d-flex justify-content-between align-items-center">
            <p style="margin:left;">TC No: TCF-90144585-202409 </p>
            <p style="margin:right;"> Admission No: 4220</p>

            
        </div>

        <table>
<tbody>
    <tr>
        <td>1</td>
        <td>2</td>
        <td>3</td>
    </tr>
    <tr>
        <td>1</td>
        <td>2</td>
        <td>3</td>
    </tr>
</tbody>

        </table>
    </div>
    <style>
        table{
            width: 100%;
            border: 1px solid rgba(0,0,0,.5);
        }
        td{
            border: 1px solid rgba(0,0,0,.5);
        }
        h3
        {
            text-align:center;
        }
        .heading-container
        {
           display:flex;
    justify-content:flex-start;
    align-items:center;
    gap:1rem; 
        }
        .id-no
        {
            display:flex;
    justify-content:flex-start;
    align-items:center;
        }
    
    </style>

</body>
</html>
        ';
    
        //print_r($data);exit;
        
       // $html = $this->load->view('sub_admin/payslip_template', $data, true);
    
        // Initialize mPDF
        $mpdf = new \Mpdf\Mpdf();
    
        // Write HTML content to PDF
        $mpdf->WriteHTML($html);
    
        // Clear output buffer to avoid extra content
       // ob_clean();
    
        // Output the PDF with correct headers
        $file_path = 'assets/certificates/students/tc-' . time() . '.pdf';
        
        //$update = $this->registermodel->common_update('teacher_salaries',['pdf' => $file_path],['id' => $insert]);
        
        $mpdf->Output($file_path, 'D'); // 'F' saves the file to the specified path
        
        echo json_encode(['success' => true, 'message' => 'Teacher Salary added successfully']);
        return;
    
}
	
	
	/*certificates end*/

}//end of page
